/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.repository.base;

import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import run.halo.app.annotation.SensitiveConceal;
import run.halo.app.model.entity.BaseComment;
import run.halo.app.model.enums.CommentStatus;
import run.halo.app.model.projection.CommentChildrenCountProjection;
import run.halo.app.model.projection.CommentCountProjection;
import run.halo.app.repository.base.BaseRepository;

@NoRepositoryBean
public interface BaseCommentRepository<COMMENT extends BaseComment>
extends BaseRepository<COMMENT, Long>,
JpaSpecificationExecutor<COMMENT> {
    @NonNull
    @SensitiveConceal
    public Page<COMMENT> findAllByStatus(@Nullable CommentStatus var1, @NonNull Pageable var2);

    @NonNull
    @SensitiveConceal
    public List<COMMENT> findAllByPostIdIn(@NonNull Collection<Integer> var1);

    @NonNull
    @SensitiveConceal
    public List<COMMENT> findAllByPostId(@NonNull Integer var1);

    @Query(value="select new run.halo.app.model.projection.CommentCountProjection(count(comment.id), comment.postId) from BaseComment comment where comment.postId in ?1 group by comment.postId")
    @NonNull
    public List<CommentCountProjection> countByPostIds(@NonNull Collection<Integer> var1);

    @Query(value="select new run.halo.app.model.projection.CommentCountProjection(count(comment.id), comment.postId) from BaseComment comment where comment.status = ?1 and comment.postId in ?2 group by comment.postId")
    @NonNull
    public List<CommentCountProjection> countByStatusAndPostIds(@NonNull CommentStatus var1, @NonNull Collection<Integer> var2);

    public long countByPostId(@NonNull Integer var1);

    public long countByStatusAndPostId(@NonNull CommentStatus var1, @NonNull Integer var2);

    public long countByStatus(@NonNull CommentStatus var1);

    @NonNull
    public List<COMMENT> deleteByPostId(@NonNull Integer var1);

    @NonNull
    public List<COMMENT> deleteByParentId(@NonNull Long var1);

    @NonNull
    @SensitiveConceal
    public List<COMMENT> findAllByPostIdAndStatus(Integer var1, CommentStatus var2);

    @NonNull
    @SensitiveConceal
    public Page<COMMENT> findAllByPostIdAndStatus(Integer var1, CommentStatus var2, Pageable var3);

    @NonNull
    @SensitiveConceal
    public List<COMMENT> findAllByPostIdAndStatusAndParentId(@NonNull Integer var1, @NonNull CommentStatus var2, @NonNull Long var3);

    @NonNull
    @SensitiveConceal
    public Page<COMMENT> findAllByPostIdAndStatusAndParentId(Integer var1, CommentStatus var2, Long var3, Pageable var4);

    @NonNull
    @SensitiveConceal
    public List<COMMENT> findAllByPostIdAndParentId(@NonNull Integer var1, @NonNull Long var2);

    @NonNull
    @SensitiveConceal
    public List<COMMENT> findAllByStatusAndParentIdIn(@NonNull CommentStatus var1, @NonNull Collection<Long> var2);

    @SensitiveConceal
    public List<COMMENT> findAllByParentIdIn(@NonNull Collection<Long> var1);

    @Query(value="select new run.halo.app.model.projection.CommentChildrenCountProjection(count(comment.id), comment.parentId) from BaseComment comment where comment.parentId in ?1 group by comment.parentId")
    @NonNull
    @Deprecated
    public List<CommentChildrenCountProjection> findDirectChildrenCount(@NonNull Collection<Long> var1);

    @Query(value="select new run.halo.app.model.projection.CommentChildrenCountProjection(count(comment.id), comment.parentId) from BaseComment comment where comment.parentId in ?1 and comment.status = ?2 group by comment.parentId")
    @NonNull
    public List<CommentChildrenCountProjection> findDirectChildrenCount(@NonNull Collection<Long> var1, @NonNull CommentStatus var2);
}

