/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.repository.base;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.lang.NonNull;
import run.halo.app.model.entity.BasePost;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.repository.base.BaseRepository;

public interface BasePostRepository<POST extends BasePost>
extends BaseRepository<POST, Integer> {
    @Query(value="select sum(p.visits) from BasePost p")
    public Long countVisit();

    @Query(value="select sum(p.likes) from BasePost p")
    public Long countLike();

    @NonNull
    public Page<POST> findAllByStatus(@NonNull PostStatus var1, @NonNull Pageable var2);

    @NonNull
    public List<POST> findAllByStatus(@NonNull PostStatus var1);

    @NonNull
    public List<POST> findAllByStatus(@NonNull PostStatus var1, @NonNull Sort var2);

    @NonNull
    public Page<POST> findAllByStatusAndCreateTimeBefore(@NonNull PostStatus var1, @NonNull Date var2, @NonNull Pageable var3);

    @NonNull
    public Page<POST> findAllByStatusAndCreateTimeAfter(@NonNull PostStatus var1, @NonNull Date var2, @NonNull Pageable var3);

    @NonNull
    public Page<POST> findAllByStatusAndEditTimeBefore(@NonNull PostStatus var1, @NonNull Date var2, @NonNull Pageable var3);

    @NonNull
    public Page<POST> findAllByStatusAndEditTimeAfter(@NonNull PostStatus var1, @NonNull Date var2, @NonNull Pageable var3);

    @NonNull
    public Page<POST> findAllByStatusAndVisitsBefore(@NonNull PostStatus var1, @NonNull Long var2, @NonNull Pageable var3);

    @NonNull
    public Page<POST> findAllByStatusAndVisitsAfter(@NonNull PostStatus var1, @NonNull Long var2, @NonNull Pageable var3);

    @NonNull
    public Optional<POST> getBySlugAndStatus(@NonNull String var1, @NonNull PostStatus var2);

    @NonNull
    public Optional<POST> getByIdAndStatus(@NonNull Integer var1, @NonNull PostStatus var2);

    public long countByStatus(@NonNull PostStatus var1);

    public boolean existsBySlug(@NonNull String var1);

    public boolean existsByIdNotAndSlug(@NonNull Integer var1, @NonNull String var2);

    public Optional<POST> getBySlug(@NonNull String var1);

    @Modifying
    @Query(value="update BasePost p set p.visits = p.visits + :visits where p.id = :postId")
    public int updateVisit(@Param(value="visits") long var1, @Param(value="postId") @NonNull Integer var3);

    @Modifying
    @Query(value="update BasePost p set p.likes = p.likes + :likes where p.id = :postId")
    public int updateLikes(@Param(value="likes") long var1, @Param(value="postId") @NonNull Integer var3);

    @Modifying
    @Query(value="update BasePost p set p.status = :status where p.id = :postId")
    public int updateStatus(@Param(value="status") @NonNull PostStatus var1, @Param(value="postId") @NonNull Integer var2);
}

