/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.repository.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Parameter;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import run.halo.app.annotation.SensitiveConceal;
import run.halo.app.repository.base.BaseRepository;
import run.halo.app.repository.base.BaseRepositoryImpl;

/*
 * Exception performing whole class analysis ignored.
 */
public class BaseRepositoryImpl<DOMAIN, ID>
extends SimpleJpaRepository<DOMAIN, ID>
implements BaseRepository<DOMAIN, ID> {
    private static final Logger log = LoggerFactory.getLogger(BaseRepositoryImpl.class);
    private final JpaEntityInformation<DOMAIN, ID> entityInformation;
    private final EntityManager entityManager;

    public BaseRepositoryImpl(JpaEntityInformation<DOMAIN, ID> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.entityInformation = entityInformation;
        this.entityManager = entityManager;
    }

    private static long executeCountQuery(TypedQuery<Long> query) {
        Assert.notNull(query, (String)"TypedQuery must not be null!");
        List totals = query.getResultList();
        long total = 0L;
        for (Long element : totals) {
            total += element == null ? 0L : element;
        }
        return total;
    }

    @SensitiveConceal
    public List<DOMAIN> findAllByIdIn(Collection<ID> ids, Sort sort) {
        Assert.notNull(ids, (String)"The given Collection of Id's must not be null!");
        Assert.notNull((Object)sort, (String)"Sort info must nto be null");
        log.debug("Customized findAllById method was invoked");
        if (!ids.iterator().hasNext()) {
            return Collections.emptyList();
        }
        if (this.entityInformation.hasCompositeId()) {
            ArrayList results = new ArrayList();
            ids.forEach(id -> super.findById(id).ifPresent(results::add));
            return results;
        }
        ByIdsSpecification specification = new ByIdsSpecification(this.entityInformation);
        TypedQuery query = super.getQuery((Specification)specification, sort);
        return query.setParameter((Parameter)specification.parameter, ids).getResultList();
    }

    @SensitiveConceal
    public Page<DOMAIN> findAllByIdIn(Collection<ID> ids, Pageable pageable) {
        Assert.notNull(ids, (String)"The given Collection of Id's must not be null!");
        Assert.notNull((Object)pageable, (String)"Page info must nto be null");
        if (!ids.iterator().hasNext()) {
            return new PageImpl(Collections.emptyList());
        }
        if (this.entityInformation.hasCompositeId()) {
            throw new UnsupportedOperationException("Unsupported find all by composite id with page info");
        }
        ByIdsSpecification specification = new ByIdsSpecification(this.entityInformation);
        TypedQuery query = super.getQuery((Specification)specification, pageable).setParameter((Parameter)specification.parameter, ids);
        TypedQuery countQuery = this.getCountQuery((Specification)specification, this.getDomainClass()).setParameter((Parameter)specification.parameter, ids);
        return pageable.isUnpaged() ? new PageImpl(query.getResultList()) : this.readPage(query, this.getDomainClass(), pageable, countQuery);
    }

    @Transactional
    public long deleteByIdIn(Collection<ID> ids) {
        log.debug("Customized deleteByIdIn method was invoked");
        List domains = this.findAllById(ids);
        this.deleteInBatch((Iterable)domains);
        return domains.size();
    }

    protected <S extends DOMAIN> Page<S> readPage(TypedQuery<S> query, Class<S> domainClass, Pageable pageable, TypedQuery<Long> countQuery) {
        if (pageable.isPaged()) {
            query.setFirstResult((int)pageable.getOffset());
            query.setMaxResults(pageable.getPageSize());
        }
        return PageableExecutionUtils.getPage((List)query.getResultList(), (Pageable)pageable, () -> BaseRepositoryImpl.executeCountQuery((TypedQuery)countQuery));
    }
}

