/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.security.filter;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UrlPathHelper;
import run.halo.app.cache.AbstractStringCacheStore;
import run.halo.app.config.properties.HaloProperties;
import run.halo.app.exception.AbstractHaloException;
import run.halo.app.exception.BadRequestException;
import run.halo.app.exception.ForbiddenException;
import run.halo.app.exception.NotInstallException;
import run.halo.app.model.enums.Mode;
import run.halo.app.model.properties.PrimaryProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.security.context.SecurityContextHolder;
import run.halo.app.security.handler.AuthenticationFailureHandler;
import run.halo.app.security.handler.DefaultAuthenticationFailureHandler;
import run.halo.app.security.service.OneTimeTokenService;
import run.halo.app.service.OptionService;

public abstract class AbstractAuthenticationFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(AbstractAuthenticationFilter.class);
    protected final AntPathMatcher antPathMatcher;
    protected final HaloProperties haloProperties;
    protected final OptionService optionService;
    protected final AbstractStringCacheStore cacheStore;
    private final UrlPathHelper urlPathHelper = new UrlPathHelper();
    private final OneTimeTokenService oneTimeTokenService;
    private volatile AuthenticationFailureHandler failureHandler;
    private Set<String> excludeUrlPatterns = new HashSet(16);
    private Set<String> urlPatterns = new LinkedHashSet();

    AbstractAuthenticationFilter(HaloProperties haloProperties, OptionService optionService, AbstractStringCacheStore cacheStore, OneTimeTokenService oneTimeTokenService) {
        this.haloProperties = haloProperties;
        this.optionService = optionService;
        this.cacheStore = cacheStore;
        this.oneTimeTokenService = oneTimeTokenService;
        this.antPathMatcher = new AntPathMatcher();
    }

    @Nullable
    protected abstract String getTokenFromRequest(@NonNull HttpServletRequest var1);

    protected String getTokenFromRequest(@NonNull HttpServletRequest request, @NonNull String tokenQueryName, @NonNull String tokenHeaderName) {
        Assert.notNull((Object)request, (String)"Http servlet request must not be null");
        Assert.hasText((String)tokenQueryName, (String)"Token query name must not be blank");
        Assert.hasText((String)tokenHeaderName, (String)"Token header name must not be blank");
        String accessKey = request.getHeader(tokenHeaderName);
        if (StringUtils.isBlank((CharSequence)accessKey)) {
            accessKey = request.getParameter(tokenQueryName);
            log.debug("Got access key from parameter: [{}: {}]", (Object)tokenQueryName, (Object)accessKey);
        } else {
            log.debug("Got access key from header: [{}: {}]", (Object)tokenHeaderName, (Object)accessKey);
        }
        return accessKey;
    }

    protected abstract void doAuthenticate(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws ServletException, IOException;

    protected boolean shouldNotFilter(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"Http servlet request must not be null");
        boolean result = this.excludeUrlPatterns.stream().anyMatch(p -> this.antPathMatcher.match(p, this.urlPathHelper.getRequestUri(request)));
        return result || this.urlPatterns.stream().noneMatch(p -> this.antPathMatcher.match(p, this.urlPathHelper.getRequestUri(request)));
    }

    public void addExcludeUrlPatterns(String ... excludeUrlPatterns) {
        Assert.notNull((Object)excludeUrlPatterns, (String)"Exclude url patterns must not be null");
        Collections.addAll(this.excludeUrlPatterns, excludeUrlPatterns);
    }

    @NonNull
    public Set<String> getExcludeUrlPatterns() {
        return this.excludeUrlPatterns;
    }

    public void setExcludeUrlPatterns(@NonNull Collection<String> excludeUrlPatterns) {
        Assert.notNull(excludeUrlPatterns, (String)"Exclude url patterns must not be null");
        this.excludeUrlPatterns = new HashSet<String>(excludeUrlPatterns);
    }

    public Collection<String> getUrlPatterns() {
        return this.urlPatterns;
    }

    public void setUrlPatterns(Collection<String> urlPatterns) {
        Assert.notNull(urlPatterns, (String)"UrlPatterns must not be null");
        this.urlPatterns = new LinkedHashSet<String>(urlPatterns);
    }

    public void addUrlPatterns(String ... urlPatterns) {
        Assert.notNull((Object)urlPatterns, (String)"UrlPatterns must not be null");
        Collections.addAll(this.urlPatterns, urlPatterns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private AuthenticationFailureHandler getFailureHandler() {
        if (this.failureHandler == null) {
            AbstractAuthenticationFilter abstractAuthenticationFilter = this;
            synchronized (abstractAuthenticationFilter) {
                if (this.failureHandler == null) {
                    DefaultAuthenticationFailureHandler failureHandler = new DefaultAuthenticationFailureHandler();
                    failureHandler.setProductionEnv(this.haloProperties.getMode().isProductionEnv());
                    this.failureHandler = failureHandler;
                }
            }
        }
        return this.failureHandler;
    }

    public synchronized void setFailureHandler(@NonNull AuthenticationFailureHandler failureHandler) {
        Assert.notNull((Object)failureHandler, (String)"Authentication failure handler must not be null");
        this.failureHandler = failureHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Boolean isInstalled = (Boolean)this.optionService.getByPropertyOrDefault((PropertyEnum)PrimaryProperties.IS_INSTALLED, Boolean.class, (Object)false);
        if (!isInstalled.booleanValue() && !Mode.TEST.equals((Object)this.haloProperties.getMode())) {
            this.getFailureHandler().onFailure(request, response, (AbstractHaloException)new NotInstallException("\u5f53\u524d\u535a\u5ba2\u8fd8\u6ca1\u6709\u521d\u59cb\u5316"));
            return;
        }
        try {
            if (this.isSufficientOneTimeToken(request)) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            this.doAuthenticate(request, response, filterChain);
        }
        catch (AbstractHaloException e) {
            this.getFailureHandler().onFailure(request, response, e);
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    private boolean isSufficientOneTimeToken(HttpServletRequest request) {
        String oneTimeToken = this.getTokenFromRequest(request, "ott", "ott");
        if (StringUtils.isBlank((CharSequence)oneTimeToken)) {
            return false;
        }
        String allowedUri = (String)this.oneTimeTokenService.get(oneTimeToken).orElseThrow(() -> new BadRequestException("The one-time token does not exist or has been expired").setErrorData((Object)oneTimeToken));
        String requestUri = request.getRequestURI();
        if (!StringUtils.equals((CharSequence)requestUri, (CharSequence)allowedUri)) {
            throw new ForbiddenException("The one-time token does not correspond the request uri").setErrorData((Object)oneTimeToken);
        }
        this.oneTimeTokenService.revoke(oneTimeToken);
        return true;
    }
}

