/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.security.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import run.halo.app.cache.AbstractStringCacheStore;
import run.halo.app.config.properties.HaloProperties;
import run.halo.app.exception.AuthenticationException;
import run.halo.app.model.entity.User;
import run.halo.app.security.authentication.Authentication;
import run.halo.app.security.authentication.AuthenticationImpl;
import run.halo.app.security.context.SecurityContext;
import run.halo.app.security.context.SecurityContextHolder;
import run.halo.app.security.context.SecurityContextImpl;
import run.halo.app.security.filter.AbstractAuthenticationFilter;
import run.halo.app.security.handler.AuthenticationFailureHandler;
import run.halo.app.security.handler.DefaultAuthenticationFailureHandler;
import run.halo.app.security.service.OneTimeTokenService;
import run.halo.app.security.support.UserDetail;
import run.halo.app.security.util.SecurityUtils;
import run.halo.app.service.OptionService;
import run.halo.app.service.UserService;

@Component
@Order(value=1)
public class AdminAuthenticationFilter
extends AbstractAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(AdminAuthenticationFilter.class);
    private final HaloProperties haloProperties;
    private final UserService userService;

    public AdminAuthenticationFilter(AbstractStringCacheStore cacheStore, UserService userService, HaloProperties haloProperties, OptionService optionService, OneTimeTokenService oneTimeTokenService, ObjectMapper objectMapper) {
        super(haloProperties, optionService, cacheStore, oneTimeTokenService);
        this.userService = userService;
        this.haloProperties = haloProperties;
        this.addUrlPatterns(new String[]{"/api/admin/**", "/api/content/comments"});
        this.addExcludeUrlPatterns(new String[]{"/api/admin/login", "/api/admin/refresh/*", "/api/admin/installations", "/api/admin/migrations/halo", "/api/admin/is_installed", "/api/admin/password/code", "/api/admin/password/reset", "/api/admin/login/precheck"});
        DefaultAuthenticationFailureHandler failureHandler = new DefaultAuthenticationFailureHandler();
        failureHandler.setProductionEnv(haloProperties.getMode().isProductionEnv());
        failureHandler.setObjectMapper(objectMapper);
        this.setFailureHandler((AuthenticationFailureHandler)failureHandler);
    }

    protected void doAuthenticate(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.haloProperties.isAuthEnabled()) {
            this.userService.getCurrentUser().ifPresent(user -> SecurityContextHolder.setContext((SecurityContext)new SecurityContextImpl((Authentication)new AuthenticationImpl(new UserDetail(user)))));
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String token = this.getTokenFromRequest(request);
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new AuthenticationException("\u672a\u767b\u5f55\uff0c\u8bf7\u767b\u5f55\u540e\u8bbf\u95ee");
        }
        Optional optionalUserId = this.cacheStore.getAny(SecurityUtils.buildTokenAccessKey((String)token), Integer.class);
        if (!optionalUserId.isPresent()) {
            throw new AuthenticationException("Token \u5df2\u8fc7\u671f\u6216\u4e0d\u5b58\u5728").setErrorData((Object)token);
        }
        User user2 = (User)this.userService.getById((Object)((Integer)optionalUserId.get()));
        UserDetail userDetail = new UserDetail(user2);
        SecurityContextHolder.setContext((SecurityContext)new SecurityContextImpl((Authentication)new AuthenticationImpl(userDetail)));
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected String getTokenFromRequest(@NonNull HttpServletRequest request) {
        return this.getTokenFromRequest(request, "admin_token", "ADMIN-Authorization");
    }
}

