/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.security.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import run.halo.app.cache.AbstractStringCacheStore;
import run.halo.app.config.properties.HaloProperties;
import run.halo.app.exception.AuthenticationException;
import run.halo.app.exception.ForbiddenException;
import run.halo.app.model.properties.ApiProperties;
import run.halo.app.model.properties.CommentProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.security.filter.AbstractAuthenticationFilter;
import run.halo.app.security.handler.AuthenticationFailureHandler;
import run.halo.app.security.handler.DefaultAuthenticationFailureHandler;
import run.halo.app.security.service.OneTimeTokenService;
import run.halo.app.service.OptionService;

@Component
@Order(value=0)
public class ApiAuthenticationFilter
extends AbstractAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(ApiAuthenticationFilter.class);
    private final OptionService optionService;

    public ApiAuthenticationFilter(HaloProperties haloProperties, OptionService optionService, AbstractStringCacheStore cacheStore, OneTimeTokenService oneTimeTokenService, ObjectMapper objectMapper) {
        super(haloProperties, optionService, cacheStore, oneTimeTokenService);
        this.optionService = optionService;
        this.addUrlPatterns(new String[]{"/api/content/**"});
        this.addExcludeUrlPatterns(new String[]{"/api/content/**/comments", "/api/content/**/comments/**", "/api/content/options/comment", "/api/content/journals/*/likes", "/api/content/posts/*/likes"});
        DefaultAuthenticationFailureHandler failureHandler = new DefaultAuthenticationFailureHandler();
        failureHandler.setProductionEnv(haloProperties.getMode().isProductionEnv());
        failureHandler.setObjectMapper(objectMapper);
        this.setFailureHandler((AuthenticationFailureHandler)failureHandler);
    }

    protected void doAuthenticate(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.haloProperties.isAuthEnabled()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Boolean apiEnabled = (Boolean)this.optionService.getByPropertyOrDefault((PropertyEnum)ApiProperties.API_ENABLED, Boolean.class, (Object)false);
        if (!apiEnabled.booleanValue()) {
            throw new ForbiddenException("API has been disabled by blogger currently");
        }
        String accessKey = this.getTokenFromRequest(request);
        if (StringUtils.isBlank((CharSequence)accessKey)) {
            throw new AuthenticationException("Missing API access key");
        }
        Optional optionalAccessKey = this.optionService.getByProperty((PropertyEnum)ApiProperties.API_ACCESS_KEY, String.class);
        if (optionalAccessKey.isEmpty()) {
            throw new AuthenticationException("API access key hasn't been set by blogger");
        }
        if (!StringUtils.equals((CharSequence)accessKey, (CharSequence)((CharSequence)optionalAccessKey.get()))) {
            throw new AuthenticationException("API access key is mismatch").setErrorData((Object)accessKey);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected boolean shouldNotFilter(HttpServletRequest request) {
        Boolean commentApiEnabled;
        boolean result = super.shouldNotFilter(request);
        if (this.antPathMatcher.match("/api/content/*/comments", request.getServletPath()) && !(commentApiEnabled = (Boolean)this.optionService.getByPropertyOrDefault((PropertyEnum)CommentProperties.API_ENABLED, Boolean.class, (Object)true)).booleanValue()) {
            result = false;
        }
        return result;
    }

    protected String getTokenFromRequest(@NonNull HttpServletRequest request) {
        return this.getTokenFromRequest(request, "api_access_key", "API-Authorization");
    }
}

