/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.security.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import run.halo.app.cache.AbstractStringCacheStore;
import run.halo.app.config.properties.HaloProperties;
import run.halo.app.security.filter.AbstractAuthenticationFilter;
import run.halo.app.security.handler.AuthenticationFailureHandler;
import run.halo.app.security.handler.ContentAuthenticationFailureHandler;
import run.halo.app.security.service.OneTimeTokenService;
import run.halo.app.service.OptionService;
import run.halo.app.utils.HaloUtils;

@Component
@Order(value=-1)
public class ContentFilter
extends AbstractAuthenticationFilter {
    public ContentFilter(HaloProperties haloProperties, OptionService optionService, AbstractStringCacheStore cacheStore, OneTimeTokenService oneTimeTokenService) {
        super(haloProperties, optionService, cacheStore, oneTimeTokenService);
        this.addUrlPatterns(new String[]{"/**"});
        String adminPattern = HaloUtils.ensureBoth((String)haloProperties.getAdminPath(), (String)"/") + "**";
        this.addExcludeUrlPatterns(new String[]{adminPattern, "/api/**", "/install", "/version", "/js/**", "/css/**"});
        this.setFailureHandler((AuthenticationFailureHandler)new ContentAuthenticationFailureHandler());
    }

    protected String getTokenFromRequest(HttpServletRequest request) {
        return null;
    }

    protected void doAuthenticate(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        request.getSession(true);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

