/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.security.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import run.halo.app.exception.AbstractHaloException;
import run.halo.app.model.support.BaseResponse;
import run.halo.app.security.handler.AuthenticationFailureHandler;
import run.halo.app.utils.ExceptionUtils;
import run.halo.app.utils.JsonUtils;
import run.halo.app.utils.ServletUtils;

public class DefaultAuthenticationFailureHandler
implements AuthenticationFailureHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultAuthenticationFailureHandler.class);
    private boolean productionEnv = true;
    private ObjectMapper objectMapper = JsonUtils.DEFAULT_JSON_MAPPER;

    public void onFailure(HttpServletRequest request, HttpServletResponse response, AbstractHaloException exception) throws IOException {
        log.warn("Handle unsuccessful authentication, ip: [{}]", (Object)ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        log.error("Authentication failure: [{}], status: [{}], data: [{}]", new Object[]{exception.getMessage(), exception.getStatus(), exception.getErrorData()});
        BaseResponse errorDetail = new BaseResponse();
        errorDetail.setStatus(Integer.valueOf(exception.getStatus().value()));
        errorDetail.setMessage(exception.getMessage());
        errorDetail.setData(exception.getErrorData());
        if (!this.productionEnv) {
            errorDetail.setDevMessage(ExceptionUtils.getStackTrace((Throwable)exception));
        }
        response.setContentType("application/json;charset=UTF-8");
        response.setStatus(exception.getStatus().value());
        response.getWriter().write(this.objectMapper.writeValueAsString((Object)errorDetail));
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"Object mapper must not be null");
        this.objectMapper = objectMapper;
    }

    public void setProductionEnv(boolean productionEnv) {
        this.productionEnv = productionEnv;
    }
}

