/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.security.resolver;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import run.halo.app.exception.AuthenticationException;
import run.halo.app.model.entity.User;
import run.halo.app.security.authentication.Authentication;
import run.halo.app.security.context.SecurityContextHolder;
import run.halo.app.security.support.UserDetail;

public class AuthenticationArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationArgumentResolver.class);

    public AuthenticationArgumentResolver() {
        log.debug("Initializing AuthenticationArgumentResolver");
    }

    public boolean supportsParameter(MethodParameter parameter) {
        Class parameterType = parameter.getParameterType();
        return Authentication.class.isAssignableFrom(parameterType) || UserDetail.class.isAssignableFrom(parameterType) || User.class.isAssignableFrom(parameterType);
    }

    @Nullable
    public Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) {
        log.debug("Handle AuthenticationArgument");
        Class parameterType = parameter.getParameterType();
        Authentication authentication = Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).orElseThrow(() -> new AuthenticationException("You haven't signed in yet"));
        if (Authentication.class.isAssignableFrom(parameterType)) {
            return authentication;
        }
        if (UserDetail.class.isAssignableFrom(parameterType)) {
            return authentication.getDetail();
        }
        if (User.class.isAssignableFrom(parameterType)) {
            return authentication.getDetail().getUser();
        }
        throw new UnsupportedOperationException("Unknown parameter type: " + parameterType);
    }
}

