/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.security.service.impl;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import run.halo.app.cache.AbstractStringCacheStore;
import run.halo.app.security.service.OneTimeTokenService;
import run.halo.app.utils.HaloUtils;

@Service
public class OneTimeTokenServiceImpl
implements OneTimeTokenService {
    private static final String tokenPrefix = "OTT-";
    private static final Duration OTT_EXPIRATION_TIME = Duration.ofMinutes(5L);
    private final AbstractStringCacheStore cacheStore;

    public OneTimeTokenServiceImpl(AbstractStringCacheStore cacheStore) {
        this.cacheStore = cacheStore;
    }

    public Optional<String> get(String oneTimeToken) {
        Assert.hasText((String)oneTimeToken, (String)"One-time token must not be blank");
        return this.cacheStore.get((Object)(tokenPrefix + oneTimeToken));
    }

    public String create(String uri) {
        Assert.hasText((String)uri, (String)"Request uri must not be blank");
        String oneTimeToken = HaloUtils.randomUUIDWithoutDash();
        this.cacheStore.put((Object)(tokenPrefix + oneTimeToken), (Object)uri, OTT_EXPIRATION_TIME.getSeconds(), TimeUnit.SECONDS);
        return oneTimeToken;
    }

    public void revoke(String oneTimeToken) {
        Assert.hasText((String)oneTimeToken, (String)"One-time token must not be blank");
        this.cacheStore.delete((Object)(tokenPrefix + oneTimeToken));
    }
}

