/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.security.util;

import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import run.halo.app.model.entity.User;

public class SecurityUtils {
    private static final String TOKEN_ACCESS_CACHE_PREFIX = "halo.admin.access.token.";
    private static final String TOKEN_REFRESH_CACHE_PREFIX = "halo.admin.refresh.token.";
    private static final String ACCESS_TOKEN_CACHE_PREFIX = "halo.admin.access_token.";
    private static final String REFRESH_TOKEN_CACHE_PREFIX = "halo.admin.refresh_token.";

    private SecurityUtils() {
    }

    @NonNull
    public static String buildAccessTokenKey(@NonNull User user) {
        Assert.notNull((Object)user, (String)"User must not be null");
        return ACCESS_TOKEN_CACHE_PREFIX + user.getId();
    }

    @NonNull
    public static String buildRefreshTokenKey(@NonNull User user) {
        Assert.notNull((Object)user, (String)"User must not be null");
        return REFRESH_TOKEN_CACHE_PREFIX + user.getId();
    }

    @NonNull
    public static String buildTokenAccessKey(@NonNull String accessToken) {
        Assert.hasText((String)accessToken, (String)"Access token must not be blank");
        return TOKEN_ACCESS_CACHE_PREFIX + accessToken;
    }

    @NonNull
    public static String buildTokenRefreshKey(@NonNull String refreshToken) {
        Assert.hasText((String)refreshToken, (String)"Refresh token must not be blank");
        return TOKEN_REFRESH_CACHE_PREFIX + refreshToken;
    }
}

