/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service;

import com.qiniu.common.Zone;
import com.qiniu.storage.Region;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.exception.MissingPropertyException;
import run.halo.app.model.dto.OptionDTO;
import run.halo.app.model.dto.OptionSimpleDTO;
import run.halo.app.model.enums.PostPermalinkType;
import run.halo.app.model.enums.SheetPermalinkType;
import run.halo.app.model.enums.ValueEnum;
import run.halo.app.model.params.OptionQuery;
import run.halo.app.model.properties.BlogProperties;
import run.halo.app.model.properties.OtherProperties;
import run.halo.app.model.properties.PermalinkProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.properties.QiniuOssProperties;
import run.halo.app.model.properties.SeoProperties;

public interface OptionProvideService {
    @NonNull
    @Transactional
    public Map<String, Object> listOptions();

    @NonNull
    default public Map<String, Object> listOptions(@Nullable Collection<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptyMap();
        }
        Map optionMap = this.listOptions();
        HashMap<String, Object> result = new HashMap<String, Object>(keys.size());
        keys.stream().filter(optionMap::containsKey).forEach(key -> result.put((String)key, optionMap.get(key)));
        return result;
    }

    @NonNull
    default public List<OptionDTO> listDtos() {
        LinkedList<OptionDTO> result = new LinkedList<OptionDTO>();
        this.listOptions().forEach((key, value) -> result.add(new OptionDTO(key, value)));
        return result;
    }

    public Page<OptionSimpleDTO> pageDtosBy(@NonNull Pageable var1, OptionQuery var2);

    @Nullable
    default public Object getByKeyOfNullable(@NonNull String key) {
        return this.getByKey(key).orElse(null);
    }

    @NonNull
    default public Object getByKeyOfNonNull(@NonNull String key) {
        return this.getByKey(key).orElseThrow(() -> new MissingPropertyException("You have to config " + key + " setting"));
    }

    @NonNull
    default public Optional<Object> getByKey(@NonNull String key) {
        Assert.hasText((String)key, (String)"Option key must not be blank");
        return Optional.ofNullable(this.listOptions().get(key));
    }

    @NonNull
    default public <T> Optional<T> getByKey(@NonNull String key, @NonNull Class<T> valueType) {
        return this.getByKey(key).map(value -> PropertyEnum.convertTo((String)value.toString(), (Class)valueType));
    }

    @Nullable
    default public Object getByPropertyOfNullable(@NonNull PropertyEnum property) {
        return this.getByProperty(property).orElse(null);
    }

    @NonNull
    default public Object getByPropertyOfNonNull(@NonNull PropertyEnum property) {
        Assert.notNull((Object)property, (String)"Blog property must not be null");
        return this.getByKeyOfNonNull((String)property.getValue());
    }

    @NonNull
    default public Optional<Object> getByProperty(@NonNull PropertyEnum property) {
        Assert.notNull((Object)property, (String)"Blog property must not be null");
        return this.getByKey((String)property.getValue());
    }

    default public <T> Optional<T> getByProperty(@NonNull PropertyEnum property, @NonNull Class<T> propertyType) {
        return this.getByProperty(property).map(propertyValue -> PropertyEnum.convertTo((String)propertyValue.toString(), (Class)propertyType));
    }

    default public <T> T getByPropertyOrDefault(@NonNull PropertyEnum property, @NonNull Class<T> propertyType, T defaultValue) {
        Assert.notNull((Object)property, (String)"Blog property must not be null");
        return this.getByProperty(property, propertyType).orElse(defaultValue);
    }

    default public <T> T getByPropertyOrDefault(@NonNull PropertyEnum property, @NonNull Class<T> propertyType) {
        return (T)this.getByProperty(property, propertyType).orElse(property.defaultValue(propertyType));
    }

    default public <T> T getByKeyOrDefault(@NonNull String key, @NonNull Class<T> valueType, T defaultValue) {
        return this.getByKey(key, valueType).orElse(defaultValue);
    }

    @NonNull
    default public <T extends Enum<T>> Optional<T> getEnumByProperty(@NonNull PropertyEnum property, @NonNull Class<T> valueType) {
        return this.getByProperty(property).map(value -> PropertyEnum.convertToEnum((String)value.toString(), (Class)valueType));
    }

    @Nullable
    default public <T extends Enum<T>> T getEnumByPropertyOrDefault(@NonNull PropertyEnum property, @NonNull Class<T> valueType, @Nullable T defaultValue) {
        return this.getEnumByProperty(property, valueType).orElse(defaultValue);
    }

    @NonNull
    default public <V, E extends Enum<E>> Optional<E> getValueEnumByProperty(@NonNull PropertyEnum property, @NonNull Class<V> valueType, @NonNull Class<E> enumType) {
        return this.getByProperty(property).map(value -> ValueEnum.valueToEnum((Class)enumType, (Object)PropertyEnum.convertTo((String)value.toString(), (Class)valueType)));
    }

    @Nullable
    default public <V, E extends Enum<E>> E getValueEnumByPropertyOrDefault(@NonNull PropertyEnum property, @NonNull Class<V> valueType, @NonNull Class<E> enumType, @Nullable E defaultValue) {
        return this.getValueEnumByProperty(property, valueType, enumType).orElse(defaultValue);
    }

    public int getPostPageSize();

    public int getArchivesPageSize();

    public int getCommentPageSize();

    public int getRssPageSize();

    @NonNull
    @Deprecated
    default public Zone getQnYunZone() {
        return this.getByProperty((PropertyEnum)QiniuOssProperties.OSS_ZONE).map(qiniuZone -> {
            Zone zone;
            switch (qiniuZone.toString()) {
                case "z0": {
                    zone = Zone.zone0();
                    break;
                }
                case "z1": {
                    zone = Zone.zone1();
                    break;
                }
                case "z2": {
                    zone = Zone.zone2();
                    break;
                }
                case "na0": {
                    zone = Zone.zoneNa0();
                    break;
                }
                case "as0": {
                    zone = Zone.zoneAs0();
                    break;
                }
                default: {
                    zone = Zone.autoZone();
                }
            }
            return zone;
        }).orElseGet(Zone::autoZone);
    }

    @NonNull
    public Region getQiniuRegion();

    @NonNull
    public Locale getLocale();

    @NonNull
    public String getBlogBaseUrl();

    @NonNull
    default public String getBlogTitle() {
        return this.getByProperty((PropertyEnum)BlogProperties.BLOG_TITLE).orElse("").toString();
    }

    default public String getSeoKeywords() {
        return this.getByProperty((PropertyEnum)SeoProperties.KEYWORDS).orElse("").toString();
    }

    default public String getSeoDescription() {
        return this.getByProperty((PropertyEnum)SeoProperties.DESCRIPTION).orElse("").toString();
    }

    public long getBirthday();

    default public PostPermalinkType getPostPermalinkType() {
        return (PostPermalinkType)this.getEnumByPropertyOrDefault((PropertyEnum)PermalinkProperties.POST_PERMALINK_TYPE, PostPermalinkType.class, (Enum)PostPermalinkType.DEFAULT);
    }

    default public SheetPermalinkType getSheetPermalinkType() {
        return (SheetPermalinkType)this.getEnumByPropertyOrDefault((PropertyEnum)PermalinkProperties.SHEET_PERMALINK_TYPE, SheetPermalinkType.class, (Enum)SheetPermalinkType.SECONDARY);
    }

    default public String getSheetPrefix() {
        return (String)this.getByPropertyOrDefault((PropertyEnum)PermalinkProperties.SHEET_PREFIX, String.class, (Object)PermalinkProperties.SHEET_PREFIX.defaultValue());
    }

    default public String getLinksPrefix() {
        return (String)this.getByPropertyOrDefault((PropertyEnum)PermalinkProperties.LINKS_PREFIX, String.class, (Object)PermalinkProperties.LINKS_PREFIX.defaultValue());
    }

    default public String getPhotosPrefix() {
        return (String)this.getByPropertyOrDefault((PropertyEnum)PermalinkProperties.PHOTOS_PREFIX, String.class, (Object)PermalinkProperties.PHOTOS_PREFIX.defaultValue());
    }

    default public String getJournalsPrefix() {
        return (String)this.getByPropertyOrDefault((PropertyEnum)PermalinkProperties.JOURNALS_PREFIX, String.class, (Object)PermalinkProperties.JOURNALS_PREFIX.defaultValue());
    }

    default public String getArchivesPrefix() {
        return (String)this.getByPropertyOrDefault((PropertyEnum)PermalinkProperties.ARCHIVES_PREFIX, String.class, (Object)PermalinkProperties.ARCHIVES_PREFIX.defaultValue());
    }

    default public String getCategoriesPrefix() {
        return (String)this.getByPropertyOrDefault((PropertyEnum)PermalinkProperties.CATEGORIES_PREFIX, String.class, (Object)PermalinkProperties.CATEGORIES_PREFIX.defaultValue());
    }

    default public String getTagsPrefix() {
        return (String)this.getByPropertyOrDefault((PropertyEnum)PermalinkProperties.TAGS_PREFIX, String.class, (Object)PermalinkProperties.TAGS_PREFIX.defaultValue());
    }

    default public String getPathSuffix() {
        return (String)this.getByPropertyOrDefault((PropertyEnum)PermalinkProperties.PATH_SUFFIX, String.class, (Object)PermalinkProperties.PATH_SUFFIX.defaultValue());
    }

    default public Boolean isEnabledAbsolutePath() {
        return (Boolean)this.getByPropertyOrDefault((PropertyEnum)OtherProperties.GLOBAL_ABSOLUTE_PATH_ENABLED, Boolean.class, (Object)true);
    }
}

