/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.handler.theme.config.support.Group;
import run.halo.app.handler.theme.config.support.Item;
import run.halo.app.handler.theme.config.support.ThemeProperty;
import run.halo.app.model.support.ThemeFile;

public interface ThemeService {
    public static final String[] SETTINGS_NAMES = new String[]{"settings.yaml", "settings.yml"};
    public static final String[] CAN_EDIT_SUFFIX = new String[]{".ftl", ".css", ".js", ".yaml", ".yml", ".properties"};
    public static final String THEME_FOLDER = "templates/themes";
    public static final String THEMES_CACHE_KEY = "themes";
    public static final String CUSTOM_SHEET_PREFIX = "sheet_";
    public static final String CUSTOM_POST_PREFIX = "post_";

    @NonNull
    public ThemeProperty getThemeOfNonNullBy(@NonNull String var1);

    @NonNull
    public Optional<ThemeProperty> fetchThemePropertyBy(@Nullable String var1);

    @NonNull
    public List<ThemeProperty> getThemes();

    @NonNull
    public List<ThemeFile> listThemeFolderBy(@NonNull String var1);

    @NonNull
    public List<String> listCustomTemplates(@NonNull String var1, @NonNull String var2);

    public boolean templateExists(@Nullable String var1);

    public boolean themeExists(@Nullable String var1);

    public Path getBasePath();

    public String getTemplateContent(@NonNull String var1);

    public String getTemplateContent(@NonNull String var1, @NonNull String var2);

    public void saveTemplateContent(@NonNull String var1, @NonNull String var2);

    public void saveTemplateContent(@NonNull String var1, @NonNull String var2, @NonNull String var3);

    public void deleteTheme(@NonNull String var1, @NonNull Boolean var2);

    @NonNull
    public List<Group> fetchConfig(@NonNull String var1);

    public Set<Item> fetchConfigItemsBy(@NonNull String var1, String var2);

    @NonNull
    public String render(@NonNull String var1);

    @NonNull
    public String renderWithSuffix(@NonNull String var1);

    @NonNull
    public String getActivatedThemeId();

    @NonNull
    public ThemeProperty getActivatedTheme();

    @NonNull
    public Optional<ThemeProperty> fetchActivatedTheme();

    @NonNull
    public ThemeProperty activateTheme(@NonNull String var1);

    @NonNull
    public ThemeProperty upload(@NonNull MultipartFile var1);

    @NonNull
    public ThemeProperty fetch(@NonNull String var1);

    public void reload();

    @NonNull
    public ThemeProperty update(@NonNull String var1);

    public ThemeProperty update(@NonNull String var1, @NonNull MultipartFile var2);
}

