/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service;

import java.util.Optional;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import run.halo.app.model.entity.User;
import run.halo.app.model.enums.MFAType;
import run.halo.app.model.params.UserParam;
import run.halo.app.service.base.CrudService;

public interface UserService
extends CrudService<User, Integer> {
    public static final String LOGIN_FAILURE_COUNT_KEY = "login.failure.count";
    public static final int MAX_LOGIN_TRY = 5;
    public static final int LOCK_MINUTES = 10;

    @NonNull
    public Optional<User> getCurrentUser();

    @NonNull
    public Optional<User> getByUsername(@NonNull String var1);

    @NonNull
    public User getByUsernameOfNonNull(@NonNull String var1);

    @NonNull
    public Optional<User> getByEmail(@NonNull String var1);

    @NonNull
    public User getByEmailOfNonNull(@NonNull String var1);

    @NonNull
    public User updatePassword(@NonNull String var1, @NonNull String var2, @NonNull Integer var3);

    @NonNull
    public User createBy(@NonNull UserParam var1);

    public void mustNotExpire(@NonNull User var1);

    public boolean passwordMatch(@NonNull User var1, @Nullable String var2);

    public void setPassword(@NonNull User var1, @NonNull String var2);

    public boolean verifyUser(@NonNull String var1, @NonNull String var2);

    @NonNull
    public User updateMFA(@NonNull MFAType var1, String var2, @NonNull Integer var3);
}

