/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.assembler;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.model.dto.post.BasePostDetailDTO;
import run.halo.app.model.dto.post.BasePostMinimalDTO;
import run.halo.app.model.dto.post.BasePostSimpleDTO;
import run.halo.app.model.entity.BasePost;
import run.halo.app.model.entity.Content;
import run.halo.app.model.properties.PostProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.service.ContentService;
import run.halo.app.service.OptionService;
import run.halo.app.utils.HaloUtils;

public class BasePostAssembler<POST extends BasePost> {
    private static final Pattern summaryPattern = Pattern.compile("\t|\r|\n");
    private final ContentService contentService;
    private final OptionService optionService;

    public BasePostAssembler(ContentService contentService, OptionService optionService) {
        this.contentService = contentService;
        this.optionService = optionService;
    }

    public BasePostMinimalDTO convertToMinimal(POST post) {
        Assert.notNull(post, (String)"Post must not be null");
        return (BasePostMinimalDTO)new BasePostMinimalDTO().convertFrom(post);
    }

    @NonNull
    public List<BasePostMinimalDTO> convertToMinimal(List<POST> posts) {
        if (CollectionUtils.isEmpty(posts)) {
            return Collections.emptyList();
        }
        return posts.stream().map(arg_0 -> this.convertToMinimal(arg_0)).collect(Collectors.toList());
    }

    @NonNull
    public Page<BasePostMinimalDTO> convertToMinimal(Page<POST> postPage) {
        Assert.notNull(postPage, (String)"Post page must not be null");
        return postPage.map(arg_0 -> this.convertToMinimal(arg_0));
    }

    @NonNull
    public BasePostSimpleDTO convertToSimple(POST post) {
        Assert.notNull(post, (String)"Post must not be null");
        BasePostSimpleDTO basePostSimpleDTO = (BasePostSimpleDTO)new BasePostSimpleDTO().convertFrom(post);
        this.generateAndSetSummaryIfAbsent(post, basePostSimpleDTO);
        Boolean isInProcess = this.contentService.draftingInProgress(post.getId());
        basePostSimpleDTO.setInProgress(isInProcess);
        return basePostSimpleDTO;
    }

    @NonNull
    public List<BasePostSimpleDTO> convertToSimple(List<POST> posts) {
        if (CollectionUtils.isEmpty(posts)) {
            return Collections.emptyList();
        }
        return posts.stream().map(arg_0 -> this.convertToSimple(arg_0)).collect(Collectors.toList());
    }

    @NonNull
    public Page<BasePostSimpleDTO> convertToSimple(Page<POST> postPage) {
        Assert.notNull(postPage, (String)"Post page must not be null");
        return postPage.map(arg_0 -> this.convertToSimple(arg_0));
    }

    @NonNull
    public BasePostDetailDTO convertToDetail(POST post) {
        Assert.notNull(post, (String)"Post must not be null");
        BasePostDetailDTO postDetail = (BasePostDetailDTO)new BasePostDetailDTO().convertFrom(post);
        Boolean isInProcess = this.contentService.draftingInProgress(post.getId());
        postDetail.setInProgress(isInProcess);
        return postDetail;
    }

    @NonNull
    protected String generateSummary(@Nullable String htmlContent) {
        if (StringUtils.isBlank((CharSequence)htmlContent)) {
            return "";
        }
        String text = HaloUtils.cleanHtmlTag((String)htmlContent);
        Matcher matcher = summaryPattern.matcher(text);
        text = matcher.replaceAll("");
        Integer summaryLength = (Integer)this.optionService.getByPropertyOrDefault((PropertyEnum)PostProperties.SUMMARY_LENGTH, Integer.class, (Object)150);
        return StringUtils.substring((String)text, (int)0, (int)summaryLength);
    }

    protected <T extends BasePostSimpleDTO> void generateAndSetSummaryIfAbsent(POST post, T postVo) {
        Assert.notNull(post, (String)"The post must not be null.");
        if (StringUtils.isNotBlank((CharSequence)postVo.getSummary())) {
            return;
        }
        Content.PatchedContent patchedContent = post.getContentOfNullable();
        if (patchedContent == null) {
            Content postContent = (Content)this.contentService.getByIdOfNullable((Object)post.getId());
            if (postContent != null) {
                postVo.setSummary(this.generateSummary(postContent.getContent()));
            } else {
                postVo.setSummary("");
            }
        } else {
            postVo.setSummary(this.generateSummary(patchedContent.getContent()));
        }
    }
}

