/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.assembler;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.model.dto.post.BasePostMinimalDTO;
import run.halo.app.model.dto.post.BasePostSimpleDTO;
import run.halo.app.model.entity.BaseMeta;
import run.halo.app.model.entity.BasePost;
import run.halo.app.model.entity.Category;
import run.halo.app.model.entity.Content;
import run.halo.app.model.entity.Post;
import run.halo.app.model.entity.PostMeta;
import run.halo.app.model.entity.Tag;
import run.halo.app.model.enums.CommentStatus;
import run.halo.app.model.enums.PostPermalinkType;
import run.halo.app.model.vo.ArchiveMonthVO;
import run.halo.app.model.vo.ArchiveYearVO;
import run.halo.app.model.vo.PostDetailVO;
import run.halo.app.model.vo.PostListVO;
import run.halo.app.service.CategoryService;
import run.halo.app.service.ContentService;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostCategoryService;
import run.halo.app.service.PostCommentService;
import run.halo.app.service.PostMetaService;
import run.halo.app.service.PostTagService;
import run.halo.app.service.TagService;
import run.halo.app.service.assembler.BasePostAssembler;
import run.halo.app.utils.DateUtils;
import run.halo.app.utils.ServiceUtils;

@Component
public class PostAssembler
extends BasePostAssembler<Post> {
    private final PostTagService postTagService;
    private final PostCategoryService postCategoryService;
    private final PostMetaService postMetaService;
    private final PostCommentService postCommentService;
    private final TagService tagService;
    private final CategoryService categoryService;
    private final ContentService contentService;
    private final OptionService optionService;

    public PostAssembler(ContentService contentService, OptionService optionService, PostTagService postTagService, PostCategoryService postCategoryService, PostMetaService postMetaService, PostCommentService postCommentService, TagService tagService, CategoryService categoryService) {
        super(contentService, optionService);
        this.postTagService = postTagService;
        this.postCategoryService = postCategoryService;
        this.postMetaService = postMetaService;
        this.postCommentService = postCommentService;
        this.tagService = tagService;
        this.categoryService = categoryService;
        this.contentService = contentService;
        this.optionService = optionService;
    }

    public BasePostMinimalDTO convertToMinimal(Post post) {
        Assert.notNull((Object)post, (String)"Post must not be null");
        BasePostMinimalDTO basePostMinimalDTO = (BasePostMinimalDTO)new BasePostMinimalDTO().convertFrom((Object)post);
        basePostMinimalDTO.setFullPath(this.buildFullPath(post));
        return basePostMinimalDTO;
    }

    public List<BasePostMinimalDTO> convertToMinimal(List<Post> posts) {
        if (CollectionUtils.isEmpty(posts)) {
            return Collections.emptyList();
        }
        return posts.stream().map(arg_0 -> this.convertToMinimal(arg_0)).collect(Collectors.toList());
    }

    @NonNull
    public PostDetailVO convertToDetailVo(Post post) {
        List tags = this.postTagService.listTagsBy(post.getId());
        List categories = this.postCategoryService.listCategoriesBy(post.getId());
        List metas = this.postMetaService.listBy(post.getId());
        return this.convertTo(post, tags, categories, metas);
    }

    public Page<PostDetailVO> convertToDetailVo(Page<Post> postPage) {
        Assert.notNull(postPage, (String)"Post page must not be null");
        return postPage.map(arg_0 -> this.convertToDetailVo(arg_0));
    }

    @NonNull
    public Page<PostListVO> convertToListVo(Page<Post> postPage) {
        Assert.notNull(postPage, (String)"Post page must not be null");
        List posts = postPage.getContent();
        Set postIds = ServiceUtils.fetchProperty((Collection)posts, BasePost::getId);
        Map tagListMap = this.postTagService.listTagListMapBy((Collection)postIds);
        Map categoryListMap = this.postCategoryService.listCategoryListMap((Collection)postIds);
        Map commentCountMap = this.postCommentService.countByStatusAndPostIds(CommentStatus.PUBLISHED, (Collection)postIds);
        Map postMetaListMap = this.postMetaService.listPostMetaAsMap(postIds);
        return postPage.map(post -> {
            PostListVO postListVO = (PostListVO)new PostListVO().convertFrom(post);
            this.generateAndSetSummaryIfAbsent((BasePost)post, (BasePostSimpleDTO)postListVO);
            Optional.ofNullable((List)tagListMap.get(post.getId())).orElseGet(LinkedList::new);
            postListVO.setTags(Optional.ofNullable((List)tagListMap.get(post.getId())).orElseGet(LinkedList::new).stream().filter(Objects::nonNull).map(arg_0 -> ((TagService)this.tagService).convertTo(arg_0)).collect(Collectors.toList()));
            postListVO.setCategories(Optional.ofNullable((List)categoryListMap.get(post.getId())).orElseGet(LinkedList::new).stream().filter(Objects::nonNull).map(arg_0 -> ((CategoryService)this.categoryService).convertTo(arg_0)).collect(Collectors.toList()));
            List metas = Optional.ofNullable((List)postMetaListMap.get(post.getId())).orElseGet(LinkedList::new);
            postListVO.setMetas(this.postMetaService.convertToMap(metas));
            postListVO.setCommentCount(commentCountMap.getOrDefault(post.getId(), 0L));
            postListVO.setFullPath(this.buildFullPath(post));
            Boolean isInProcess = this.contentService.draftingInProgress(post.getId());
            postListVO.setInProgress(isInProcess);
            return postListVO;
        });
    }

    public List<PostListVO> convertToListVo(List<Post> posts) {
        Assert.notNull(posts, (String)"Post page must not be null");
        Set postIds = ServiceUtils.fetchProperty(posts, BasePost::getId);
        Map tagListMap = this.postTagService.listTagListMapBy((Collection)postIds);
        Map categoryListMap = this.postCategoryService.listCategoryListMap((Collection)postIds);
        Map commentCountMap = this.postCommentService.countByStatusAndPostIds(CommentStatus.PUBLISHED, (Collection)postIds);
        Map postMetaListMap = this.postMetaService.listPostMetaAsMap(postIds);
        return posts.stream().map(post -> {
            PostListVO postListVO = (PostListVO)new PostListVO().convertFrom(post);
            this.generateAndSetSummaryIfAbsent((BasePost)post, (BasePostSimpleDTO)postListVO);
            Optional.ofNullable((List)tagListMap.get(post.getId())).orElseGet(LinkedList::new);
            postListVO.setTags(Optional.ofNullable((List)tagListMap.get(post.getId())).orElseGet(LinkedList::new).stream().filter(Objects::nonNull).map(arg_0 -> ((TagService)this.tagService).convertTo(arg_0)).collect(Collectors.toList()));
            postListVO.setCategories(Optional.ofNullable((List)categoryListMap.get(post.getId())).orElseGet(LinkedList::new).stream().filter(Objects::nonNull).map(arg_0 -> ((CategoryService)this.categoryService).convertTo(arg_0)).collect(Collectors.toList()));
            List metas = Optional.ofNullable((List)postMetaListMap.get(post.getId())).orElseGet(LinkedList::new);
            postListVO.setMetas(this.postMetaService.convertToMap(metas));
            postListVO.setCommentCount(commentCountMap.getOrDefault(post.getId(), 0L));
            postListVO.setFullPath(this.buildFullPath(post));
            return postListVO;
        }).collect(Collectors.toList());
    }

    @NonNull
    public PostDetailVO convertTo(@NonNull Post post, @Nullable List<Tag> tags, @Nullable List<Category> categories, List<PostMeta> postMetaList) {
        Assert.notNull((Object)post, (String)"Post must not be null");
        PostDetailVO postDetailVO = (PostDetailVO)new PostDetailVO().convertFrom((BasePost)post);
        this.generateAndSetSummaryIfAbsent((BasePost)post, (BasePostSimpleDTO)postDetailVO);
        Set tagIds = ServiceUtils.fetchProperty(tags, Tag::getId);
        Set categoryIds = ServiceUtils.fetchProperty(categories, Category::getId);
        Set metaIds = ServiceUtils.fetchProperty(postMetaList, BaseMeta::getId);
        postDetailVO.setTagIds(tagIds);
        postDetailVO.setTags(this.tagService.convertTo(tags));
        postDetailVO.setCategoryIds(categoryIds);
        postDetailVO.setCategories(this.categoryService.convertTo(categories));
        postDetailVO.setMetaIds(metaIds);
        postDetailVO.setMetas(this.postMetaService.convertTo(postMetaList));
        postDetailVO.setCommentCount(Long.valueOf(this.postCommentService.countByStatusAndPostId(CommentStatus.PUBLISHED, post.getId())));
        postDetailVO.setFullPath(this.buildFullPath(post));
        Content.PatchedContent postContent = post.getContent();
        postDetailVO.setContent(postContent.getContent());
        postDetailVO.setOriginalContent(postContent.getOriginalContent());
        Boolean inProgress = this.contentService.draftingInProgress(post.getId());
        postDetailVO.setInProgress(inProgress);
        return postDetailVO;
    }

    public List<ArchiveYearVO> convertToYearArchives(List<Post> posts) {
        HashMap<Integer, List> yearPostMap = new HashMap<Integer, List>(8);
        posts.forEach(post -> {
            Calendar calendar = DateUtils.convertTo((Date)post.getCreateTime());
            yearPostMap.computeIfAbsent(calendar.get(1), year -> new LinkedList()).add(post);
        });
        LinkedList<ArchiveYearVO> archives = new LinkedList<ArchiveYearVO>();
        yearPostMap.forEach((year, postList) -> {
            ArchiveYearVO archive = new ArchiveYearVO();
            archive.setYear(year);
            archive.setPosts(this.convertToListVo(postList));
            archives.add(archive);
        });
        archives.sort((Comparator<ArchiveYearVO>)new ArchiveYearVO.ArchiveComparator());
        return archives;
    }

    public List<ArchiveMonthVO> convertToMonthArchives(List<Post> posts) {
        HashMap<Integer, Map> yearMonthPostMap = new HashMap<Integer, Map>(8);
        posts.forEach(post -> {
            Calendar calendar = DateUtils.convertTo((Date)post.getCreateTime());
            yearMonthPostMap.computeIfAbsent(calendar.get(1), year -> new HashMap()).computeIfAbsent(calendar.get(2) + 1, month -> new LinkedList()).add(post);
        });
        LinkedList<ArchiveMonthVO> archives = new LinkedList<ArchiveMonthVO>();
        yearMonthPostMap.forEach((year, monthPostMap) -> monthPostMap.forEach((month, postList) -> {
            ArchiveMonthVO archive = new ArchiveMonthVO();
            archive.setYear(year);
            archive.setMonth(month);
            archive.setPosts(this.convertToListVo(postList));
            archives.add(archive);
        }));
        archives.sort((Comparator<ArchiveMonthVO>)new ArchiveMonthVO.ArchiveComparator());
        return archives;
    }

    public String buildFullPath(Post post) {
        PostPermalinkType permalinkType = this.optionService.getPostPermalinkType();
        String pathSuffix = this.optionService.getPathSuffix();
        String archivesPrefix = this.optionService.getArchivesPrefix();
        int month = DateUtils.month((Date)post.getCreateTime()) + 1;
        Object monthString = month < 10 ? "0" + month : String.valueOf(month);
        int day = DateUtils.dayOfMonth((Date)post.getCreateTime());
        Object dayString = day < 10 ? "0" + day : String.valueOf(day);
        StringBuilder fullPath = new StringBuilder();
        if (this.optionService.isEnabledAbsolutePath().booleanValue()) {
            fullPath.append(this.optionService.getBlogBaseUrl());
        }
        fullPath.append("/");
        if (permalinkType.equals((Object)PostPermalinkType.DEFAULT)) {
            fullPath.append(archivesPrefix).append("/").append(post.getSlug()).append(pathSuffix);
        } else if (permalinkType.equals((Object)PostPermalinkType.ID)) {
            fullPath.append("?p=").append(post.getId());
        } else if (permalinkType.equals((Object)PostPermalinkType.DATE)) {
            fullPath.append(DateUtils.year((Date)post.getCreateTime())).append("/").append((String)monthString).append("/").append(post.getSlug()).append(pathSuffix);
        } else if (permalinkType.equals((Object)PostPermalinkType.DAY)) {
            fullPath.append(DateUtils.year((Date)post.getCreateTime())).append("/").append((String)monthString).append("/").append((String)dayString).append("/").append(post.getSlug()).append(pathSuffix);
        } else if (permalinkType.equals((Object)PostPermalinkType.YEAR)) {
            fullPath.append(DateUtils.year((Date)post.getCreateTime())).append("/").append(post.getSlug()).append(pathSuffix);
        } else if (permalinkType.equals((Object)PostPermalinkType.ID_SLUG)) {
            fullPath.append(archivesPrefix).append("/").append(post.getId()).append(pathSuffix);
        }
        return fullPath.toString();
    }
}

