/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.assembler;

import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import run.halo.app.model.entity.Content;
import run.halo.app.model.entity.Post;
import run.halo.app.model.vo.PostDetailVO;
import run.halo.app.service.CategoryService;
import run.halo.app.service.ContentPatchLogService;
import run.halo.app.service.ContentService;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostCategoryService;
import run.halo.app.service.PostCommentService;
import run.halo.app.service.PostMetaService;
import run.halo.app.service.PostTagService;
import run.halo.app.service.TagService;
import run.halo.app.service.assembler.PostAssembler;

@Component
public class PostRenderAssembler
extends PostAssembler {
    private final ContentService contentService;
    private final ContentPatchLogService contentPatchLogService;

    public PostRenderAssembler(ContentService contentService, OptionService optionService, PostTagService postTagService, PostCategoryService postCategoryService, PostMetaService postMetaService, PostCommentService postCommentService, TagService tagService, CategoryService categoryService, ContentPatchLogService contentPatchLogService) {
        super(contentService, optionService, postTagService, postCategoryService, postMetaService, postCommentService, tagService, categoryService);
        this.contentService = contentService;
        this.contentPatchLogService = contentPatchLogService;
    }

    public Page<PostDetailVO> convertToDetailVo(Page<Post> postPage) {
        Assert.notNull(postPage, (String)"Post page must not be null");
        postPage.getContent().forEach(post -> {
            Content postContent = (Content)this.contentService.getById((Object)post.getId());
            post.setContent(Content.PatchedContent.of((Content)postContent));
        });
        return postPage.map(arg_0 -> this.convertToDetailVo(arg_0));
    }

    public PostDetailVO convertToDetailVo(Post post) {
        Assert.notNull((Object)post, (String)"The post must not be null.");
        post.setContent(Content.PatchedContent.of((Content)((Content)this.contentService.getById((Object)post.getId()))));
        return super.convertToDetailVo(post);
    }

    public PostDetailVO convertToPreviewDetailVo(Post post) {
        Assert.notNull((Object)post, (String)"The post must not be null.");
        post.setContent(this.getLatestContentBy(post.getId()));
        return super.convertToDetailVo(post);
    }

    private Content.PatchedContent getLatestContentBy(Integer postId) {
        Content postContent = (Content)this.contentService.getById((Object)postId);
        return this.contentPatchLogService.getPatchedContentById(postContent.getHeadPatchLogId());
    }
}

