/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.assembler;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.model.dto.post.BasePostMinimalDTO;
import run.halo.app.model.dto.post.BasePostSimpleDTO;
import run.halo.app.model.entity.BaseMeta;
import run.halo.app.model.entity.BasePost;
import run.halo.app.model.entity.Content;
import run.halo.app.model.entity.Sheet;
import run.halo.app.model.entity.SheetMeta;
import run.halo.app.model.enums.CommentStatus;
import run.halo.app.model.enums.SheetPermalinkType;
import run.halo.app.model.vo.SheetDetailVO;
import run.halo.app.model.vo.SheetListVO;
import run.halo.app.service.ContentService;
import run.halo.app.service.OptionService;
import run.halo.app.service.SheetCommentService;
import run.halo.app.service.SheetMetaService;
import run.halo.app.service.assembler.BasePostAssembler;
import run.halo.app.utils.ServiceUtils;

@Component
public class SheetAssembler
extends BasePostAssembler<Sheet> {
    private final SheetCommentService sheetCommentService;
    private final ContentService contentService;
    private final SheetMetaService sheetMetaService;
    private final OptionService optionService;

    public SheetAssembler(SheetCommentService sheetCommentService, ContentService contentService, SheetMetaService sheetMetaService, OptionService optionService) {
        super(contentService, optionService);
        this.sheetCommentService = sheetCommentService;
        this.contentService = contentService;
        this.sheetMetaService = sheetMetaService;
        this.optionService = optionService;
    }

    @NonNull
    public Page<SheetListVO> convertToListVo(Page<Sheet> sheetPage) {
        Assert.notNull(sheetPage, (String)"Sheet page must not be null");
        List sheets = sheetPage.getContent();
        Set sheetIds = ServiceUtils.fetchProperty((Collection)sheets, BasePost::getId);
        Map sheetCommentCountMap = this.sheetCommentService.countByStatusAndPostIds(CommentStatus.PUBLISHED, (Collection)sheetIds);
        return sheetPage.map(sheet -> {
            SheetListVO sheetListVO = (SheetListVO)new SheetListVO().convertFrom(sheet);
            sheetListVO.setCommentCount(sheetCommentCountMap.getOrDefault(sheet.getId(), 0L));
            sheetListVO.setFullPath(this.buildFullPath(sheet));
            Boolean isInProcess = this.contentService.draftingInProgress(sheet.getId());
            sheetListVO.setInProgress(isInProcess);
            return sheetListVO;
        });
    }

    @NonNull
    public SheetDetailVO convertToDetailVo(Sheet sheet) {
        List metas = this.sheetMetaService.listBy(sheet.getId());
        return this.convertTo(sheet, metas);
    }

    public BasePostMinimalDTO convertToMinimal(Sheet sheet) {
        Assert.notNull((Object)sheet, (String)"Sheet must not be null");
        BasePostMinimalDTO basePostMinimalDTO = (BasePostMinimalDTO)new BasePostMinimalDTO().convertFrom((Object)sheet);
        basePostMinimalDTO.setFullPath(this.buildFullPath(sheet));
        return basePostMinimalDTO;
    }

    public List<BasePostMinimalDTO> convertToMinimal(List<Sheet> sheets) {
        if (CollectionUtils.isEmpty(sheets)) {
            return Collections.emptyList();
        }
        return sheets.stream().map(arg_0 -> this.convertToMinimal(arg_0)).collect(Collectors.toList());
    }

    @NonNull
    public SheetDetailVO convertTo(@NonNull Sheet sheet, List<SheetMeta> metas) {
        Assert.notNull((Object)sheet, (String)"Sheet must not be null");
        SheetDetailVO sheetDetailVO = (SheetDetailVO)new SheetDetailVO().convertFrom((BasePost)sheet);
        Set metaIds = ServiceUtils.fetchProperty(metas, BaseMeta::getId);
        sheetDetailVO.setMetaIds(metaIds);
        sheetDetailVO.setMetas(this.sheetMetaService.convertTo(metas));
        this.generateAndSetSummaryIfAbsent((BasePost)sheet, (BasePostSimpleDTO)sheetDetailVO);
        sheetDetailVO.setCommentCount(Long.valueOf(this.sheetCommentService.countByStatusAndPostId(CommentStatus.PUBLISHED, sheet.getId())));
        sheetDetailVO.setFullPath(this.buildFullPath(sheet));
        Content.PatchedContent sheetContent = sheet.getContent();
        sheetDetailVO.setContent(sheetContent.getContent());
        sheetDetailVO.setOriginalContent(sheetContent.getOriginalContent());
        Boolean inProgress = this.contentService.draftingInProgress(sheet.getId());
        sheetDetailVO.setInProgress(inProgress);
        return sheetDetailVO;
    }

    private String buildFullPath(Sheet sheet) {
        StringBuilder fullPath = new StringBuilder();
        SheetPermalinkType permalinkType = this.optionService.getSheetPermalinkType();
        if (this.optionService.isEnabledAbsolutePath().booleanValue()) {
            fullPath.append(this.optionService.getBlogBaseUrl());
        }
        if (permalinkType.equals((Object)SheetPermalinkType.SECONDARY)) {
            fullPath.append("/").append(this.optionService.getSheetPrefix()).append("/").append(sheet.getSlug()).append(this.optionService.getPathSuffix());
        } else if (permalinkType.equals((Object)SheetPermalinkType.ROOT)) {
            fullPath.append("/").append(sheet.getSlug()).append(this.optionService.getPathSuffix());
        }
        return fullPath.toString();
    }
}

