/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.assembler;

import java.util.List;
import org.springframework.stereotype.Component;
import run.halo.app.model.entity.Content;
import run.halo.app.model.entity.Sheet;
import run.halo.app.model.vo.SheetDetailVO;
import run.halo.app.service.ContentPatchLogService;
import run.halo.app.service.ContentService;
import run.halo.app.service.OptionService;
import run.halo.app.service.SheetCommentService;
import run.halo.app.service.SheetMetaService;
import run.halo.app.service.assembler.SheetAssembler;

@Component
public class SheetRenderAssembler
extends SheetAssembler {
    private final SheetMetaService sheetMetaService;
    private final ContentService contentService;
    private final ContentPatchLogService contentPatchLogService;

    public SheetRenderAssembler(SheetCommentService sheetCommentService, ContentService contentService, SheetMetaService sheetMetaService, OptionService optionService, ContentPatchLogService contentPatchLogService) {
        super(sheetCommentService, contentService, sheetMetaService, optionService);
        this.sheetMetaService = sheetMetaService;
        this.contentService = contentService;
        this.contentPatchLogService = contentPatchLogService;
    }

    public SheetDetailVO convertToDetailVo(Sheet sheet) {
        sheet.setContent(Content.PatchedContent.of((Content)((Content)this.contentService.getById((Object)sheet.getId()))));
        List metas = this.sheetMetaService.listBy(sheet.getId());
        return super.convertTo(sheet, metas);
    }

    public SheetDetailVO convertToPreviewDetailVo(Sheet sheet) {
        sheet.setContent(this.getLatestContentBy(sheet.getId()));
        List metas = this.sheetMetaService.listBy(sheet.getId());
        return super.convertTo(sheet, metas);
    }

    private Content.PatchedContent getLatestContentBy(Integer postId) {
        Content postContent = (Content)this.contentService.getById((Object)postId);
        return this.contentPatchLogService.getPatchedContentById(postContent.getHeadPatchLogId());
    }
}

