/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.assembler.comment;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.model.dto.BaseCommentDTO;
import run.halo.app.model.entity.BaseComment;
import run.halo.app.model.properties.CommentProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.support.CommentPage;
import run.halo.app.model.vo.BaseCommentVO;
import run.halo.app.model.vo.BaseCommentWithParentVO;
import run.halo.app.service.OptionService;

public abstract class BaseCommentAssembler<COMMENT extends BaseComment> {
    private static final Logger log = LoggerFactory.getLogger(BaseCommentAssembler.class);
    private final OptionService optionService;

    public BaseCommentAssembler(OptionService optionService) {
        this.optionService = optionService;
    }

    @NonNull
    public BaseCommentDTO convertTo(@NonNull COMMENT comment) {
        Assert.notNull(comment, (String)"Comment must not be null");
        BaseCommentDTO baseCommentDto = (BaseCommentDTO)new BaseCommentDTO().convertFrom(comment);
        baseCommentDto.setAvatar(this.buildAvatarUrl(comment.getGravatarMd5()));
        return baseCommentDto;
    }

    @NonNull
    public List<BaseCommentDTO> convertTo(@NonNull List<COMMENT> comments) {
        if (CollectionUtils.isEmpty(comments)) {
            return Collections.emptyList();
        }
        return comments.stream().map(arg_0 -> this.convertTo(arg_0)).collect(Collectors.toList());
    }

    @NonNull
    public Page<BaseCommentDTO> convertTo(@NonNull Page<COMMENT> commentPage) {
        Assert.notNull(commentPage, (String)"Comment page must not be null");
        return commentPage.map(arg_0 -> this.convertTo(arg_0));
    }

    public List<BaseCommentVO> convertToVo(@Nullable List<COMMENT> comments, @Nullable Comparator<BaseCommentVO> comparator) {
        if (CollectionUtils.isEmpty(comments)) {
            return Collections.emptyList();
        }
        BaseCommentVO topVirtualComment = new BaseCommentVO();
        topVirtualComment.setId(Long.valueOf(0L));
        topVirtualComment.setChildren(new LinkedList());
        this.concreteTree(topVirtualComment, new LinkedList<COMMENT>(comments), comparator);
        return topVirtualComment.getChildren();
    }

    @NonNull
    public Page<BaseCommentVO> pageVosBy(@NonNull List<COMMENT> comments, @NonNull Pageable pageable) {
        List<Object> pageContent;
        Assert.notNull(comments, (String)"Comments must not be null");
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        Comparator commentComparator = this.buildCommentComparator(pageable.getSortOr(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"})));
        List topComments = this.convertToVo(comments, commentComparator);
        int startIndex = pageable.getPageNumber() * pageable.getPageSize();
        if (startIndex >= topComments.size() || startIndex < 0) {
            pageContent = Collections.emptyList();
        } else {
            int endIndex = startIndex + pageable.getPageSize();
            if (endIndex > topComments.size()) {
                endIndex = topComments.size();
            }
            log.debug("Top comments size: [{}]", (Object)topComments.size());
            log.debug("Start index: [{}]", (Object)startIndex);
            log.debug("End index: [{}]", (Object)endIndex);
            pageContent = topComments.subList(startIndex, endIndex);
        }
        return new CommentPage(pageContent, pageable, (long)topComments.size(), (long)comments.size());
    }

    public void concreteTree(@NonNull BaseCommentVO parentComment, @Nullable Collection<COMMENT> comments, @Nullable Comparator<BaseCommentVO> commentComparator) {
        Assert.notNull((Object)parentComment, (String)"Parent comment must not be null");
        if (CollectionUtils.isEmpty(comments)) {
            return;
        }
        List<BaseComment> children = comments.stream().filter(comment -> Objects.equals(parentComment.getId(), comment.getParentId())).collect(Collectors.toList());
        children.forEach(comment -> {
            BaseCommentVO commentVo = (BaseCommentVO)new BaseCommentVO().convertFrom(comment);
            commentVo.setAvatar(this.buildAvatarUrl(commentVo.getGravatarMd5()));
            if (parentComment.getChildren() == null) {
                parentComment.setChildren(new LinkedList());
            }
            parentComment.getChildren().add(commentVo);
        });
        comments.removeAll(children);
        if (!CollectionUtils.isEmpty((Collection)parentComment.getChildren())) {
            parentComment.getChildren().forEach(childComment -> this.concreteTree(childComment, comments, commentComparator));
            if (commentComparator != null) {
                parentComment.getChildren().sort(commentComparator);
            }
        }
    }

    public String buildAvatarUrl(String gravatarMd5) {
        String gravatarSource = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)CommentProperties.GRAVATAR_SOURCE, String.class);
        String gravatarDefault = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)CommentProperties.GRAVATAR_DEFAULT, String.class);
        return gravatarSource + gravatarMd5 + "?s=256&d=" + gravatarDefault;
    }

    protected Comparator<BaseCommentVO> buildCommentComparator(Sort sort) {
        return (currentComment, toCompareComment) -> {
            Assert.notNull((Object)currentComment, (String)"Current comment must not be null");
            Assert.notNull((Object)toCompareComment, (String)"Comment to compare must not be null");
            Sort.Order order = sort.filter(anOrder -> "id".equals(anOrder.getProperty())).get().findFirst().orElseGet(() -> Sort.Order.desc((String)"id"));
            int sign = order.getDirection().isAscending() ? 1 : -1;
            return sign * currentComment.getId().compareTo(toCompareComment.getId());
        };
    }

    public void clearSensitiveField(@Nullable COMMENT comment) {
        if (comment == null) {
            return;
        }
        comment.setIpAddress(null);
        comment.setEmail(null);
    }

    public void clearSensitiveField(@Nullable BaseCommentDTO comment) {
        if (comment == null) {
            return;
        }
        comment.setIpAddress(null);
        comment.setEmail(null);
    }

    public void clearSensitiveField(@Nullable BaseCommentVO commentTree) {
        if (commentTree == null) {
            return;
        }
        ArrayDeque<BaseCommentVO> queue = new ArrayDeque<BaseCommentVO>();
        queue.add(commentTree);
        while (!queue.isEmpty()) {
            BaseCommentVO comment = (BaseCommentVO)queue.poll();
            comment.setIpAddress(null);
            comment.setEmail(null);
            if (CollectionUtils.isEmpty((Collection)comment.getChildren())) continue;
            queue.addAll(comment.getChildren());
        }
    }

    public void clearSensitiveField(@Nullable BaseCommentWithParentVO comment) {
        if (comment == null) {
            return;
        }
        BaseCommentWithParentVO parent = comment.getParent();
        if (parent != null) {
            parent.setIpAddress(null);
            parent.setEmail(null);
        }
        comment.setIpAddress(null);
        comment.setEmail(null);
    }
}

