/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.assembler.comment;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.model.dto.post.BasePostMinimalDTO;
import run.halo.app.model.entity.BaseComment;
import run.halo.app.model.entity.BasePost;
import run.halo.app.model.entity.PostComment;
import run.halo.app.model.enums.PostPermalinkType;
import run.halo.app.model.vo.PostCommentWithPostVO;
import run.halo.app.repository.PostRepository;
import run.halo.app.service.OptionService;
import run.halo.app.service.assembler.comment.BaseCommentAssembler;
import run.halo.app.utils.DateUtils;
import run.halo.app.utils.ServiceUtils;

@Component
public class PostCommentAssembler
extends BaseCommentAssembler<PostComment> {
    private final OptionService optionService;
    private final PostRepository postRepository;

    public PostCommentAssembler(OptionService optionService, PostRepository postRepository) {
        super(optionService);
        this.postRepository = postRepository;
        this.optionService = optionService;
    }

    @NonNull
    public Page<PostCommentWithPostVO> convertToWithPostVo(@NonNull Page<PostComment> commentPage) {
        Assert.notNull(commentPage, (String)"PostComment page must not be null");
        return new PageImpl(this.convertToWithPostVo(commentPage.getContent()), commentPage.getPageable(), commentPage.getTotalElements());
    }

    @NonNull
    public PostCommentWithPostVO convertToWithPostVo(@NonNull PostComment comment) {
        Assert.notNull((Object)comment, (String)"PostComment must not be null");
        PostCommentWithPostVO postCommentWithPostVo = (PostCommentWithPostVO)new PostCommentWithPostVO().convertFrom((Object)comment);
        BasePostMinimalDTO basePostMinimalDto = (BasePostMinimalDTO)new BasePostMinimalDTO().convertFrom((Object)((BasePost)this.postRepository.getById((Object)comment.getPostId())));
        postCommentWithPostVo.setPost(this.buildPostFullPath(basePostMinimalDto));
        postCommentWithPostVo.setAvatar(this.buildAvatarUrl(comment.getGravatarMd5()));
        return postCommentWithPostVo;
    }

    @NonNull
    public List<PostCommentWithPostVO> convertToWithPostVo(List<PostComment> postComments) {
        if (CollectionUtils.isEmpty(postComments)) {
            return Collections.emptyList();
        }
        Set postIds = ServiceUtils.fetchProperty(postComments, BaseComment::getPostId);
        Map postMap = ServiceUtils.convertToMap((Collection)this.postRepository.findAllById((Iterable)postIds), BasePost::getId);
        return postComments.stream().filter(comment -> postMap.containsKey(comment.getPostId())).map(comment -> {
            PostCommentWithPostVO postCommentWithPostVo = (PostCommentWithPostVO)new PostCommentWithPostVO().convertFrom(comment);
            BasePostMinimalDTO basePostMinimalDto = (BasePostMinimalDTO)new BasePostMinimalDTO().convertFrom((Object)((BasePost)postMap.get(comment.getPostId())));
            postCommentWithPostVo.setPost(this.buildPostFullPath(basePostMinimalDto));
            postCommentWithPostVo.setAvatar(this.buildAvatarUrl(comment.getGravatarMd5()));
            return postCommentWithPostVo;
        }).collect(Collectors.toList());
    }

    private BasePostMinimalDTO buildPostFullPath(BasePostMinimalDTO post) {
        PostPermalinkType permalinkType = this.optionService.getPostPermalinkType();
        String pathSuffix = this.optionService.getPathSuffix();
        String archivesPrefix = this.optionService.getArchivesPrefix();
        int month = DateUtils.month((Date)post.getCreateTime()) + 1;
        Object monthString = month < 10 ? "0" + month : String.valueOf(month);
        int day = DateUtils.dayOfMonth((Date)post.getCreateTime());
        Object dayString = day < 10 ? "0" + day : String.valueOf(day);
        StringBuilder fullPath = new StringBuilder();
        if (this.optionService.isEnabledAbsolutePath().booleanValue()) {
            fullPath.append(this.optionService.getBlogBaseUrl());
        }
        fullPath.append("/");
        if (permalinkType.equals((Object)PostPermalinkType.DEFAULT)) {
            fullPath.append(archivesPrefix).append("/").append(post.getSlug()).append(pathSuffix);
        } else if (permalinkType.equals((Object)PostPermalinkType.ID)) {
            fullPath.append("?p=").append(post.getId());
        } else if (permalinkType.equals((Object)PostPermalinkType.DATE)) {
            fullPath.append(DateUtils.year((Date)post.getCreateTime())).append("/").append((String)monthString).append("/").append(post.getSlug()).append(pathSuffix);
        } else if (permalinkType.equals((Object)PostPermalinkType.DAY)) {
            fullPath.append(DateUtils.year((Date)post.getCreateTime())).append("/").append((String)monthString).append("/").append((String)dayString).append("/").append(post.getSlug()).append(pathSuffix);
        } else if (permalinkType.equals((Object)PostPermalinkType.YEAR)) {
            fullPath.append(DateUtils.year((Date)post.getCreateTime())).append("/").append(post.getSlug()).append(pathSuffix);
        } else if (permalinkType.equals((Object)PostPermalinkType.ID_SLUG)) {
            fullPath.append(archivesPrefix).append("/").append(post.getId()).append(pathSuffix);
        }
        post.setFullPath(fullPath.toString());
        return post;
    }
}

