/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.assembler.comment;

import java.util.Comparator;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import run.halo.app.model.dto.BaseCommentDTO;
import run.halo.app.model.entity.BaseComment;
import run.halo.app.model.entity.PostComment;
import run.halo.app.model.vo.BaseCommentVO;
import run.halo.app.model.vo.PostCommentWithPostVO;
import run.halo.app.repository.PostRepository;
import run.halo.app.service.OptionService;
import run.halo.app.service.assembler.comment.PostCommentAssembler;

@Component
public class PostCommentRenderAssembler
extends PostCommentAssembler {
    public PostCommentRenderAssembler(OptionService optionService, PostRepository postRepository) {
        super(optionService, postRepository);
    }

    @NonNull
    public BaseCommentDTO convertTo(@NonNull PostComment comment) {
        this.clearSensitiveField((BaseComment)comment);
        return super.convertTo((BaseComment)comment);
    }

    @NonNull
    public List<BaseCommentDTO> convertTo(@NonNull List<PostComment> postComments) {
        postComments.forEach(arg_0 -> ((PostCommentRenderAssembler)this).clearSensitiveField(arg_0));
        return super.convertTo(postComments);
    }

    @NonNull
    public Page<BaseCommentDTO> convertTo(@NonNull Page<PostComment> postComments) {
        postComments.forEach(arg_0 -> ((PostCommentRenderAssembler)this).clearSensitiveField(arg_0));
        return super.convertTo(postComments);
    }

    public List<BaseCommentVO> convertToVo(List<PostComment> postComments, Comparator<BaseCommentVO> comparator) {
        if (!CollectionUtils.isEmpty(postComments)) {
            postComments.forEach(arg_0 -> ((PostCommentRenderAssembler)this).clearSensitiveField(arg_0));
        }
        return super.convertToVo(postComments, comparator);
    }

    @NonNull
    public Page<PostCommentWithPostVO> convertToWithPostVo(@NonNull Page<PostComment> commentPage) {
        commentPage.getContent().forEach(arg_0 -> ((PostCommentRenderAssembler)this).clearSensitiveField(arg_0));
        return super.convertToWithPostVo(commentPage);
    }

    @NonNull
    public PostCommentWithPostVO convertToWithPostVo(@NonNull PostComment comment) {
        this.clearSensitiveField((BaseComment)comment);
        return super.convertToWithPostVo(comment);
    }

    @NonNull
    public List<PostCommentWithPostVO> convertToWithPostVo(List<PostComment> postComments) {
        if (!CollectionUtils.isEmpty(postComments)) {
            postComments.forEach(arg_0 -> ((PostCommentRenderAssembler)this).clearSensitiveField(arg_0));
        }
        return super.convertToWithPostVo(postComments);
    }

    @NonNull
    public Page<BaseCommentVO> pageVosBy(@NonNull List<PostComment> postComments, @NonNull Pageable pageable) {
        postComments.forEach(arg_0 -> ((PostCommentRenderAssembler)this).clearSensitiveField(arg_0));
        return super.pageVosBy(postComments, pageable);
    }
}

