/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.assembler.comment;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.model.dto.post.BasePostMinimalDTO;
import run.halo.app.model.entity.BaseComment;
import run.halo.app.model.entity.BasePost;
import run.halo.app.model.entity.SheetComment;
import run.halo.app.model.enums.SheetPermalinkType;
import run.halo.app.model.vo.SheetCommentWithSheetVO;
import run.halo.app.repository.SheetRepository;
import run.halo.app.service.OptionService;
import run.halo.app.service.assembler.comment.BaseCommentAssembler;
import run.halo.app.utils.ServiceUtils;

@Component
public class SheetCommentAssembler
extends BaseCommentAssembler<SheetComment> {
    private final SheetRepository sheetRepository;
    private final OptionService optionService;

    public SheetCommentAssembler(OptionService optionService, SheetRepository sheetRepository) {
        super(optionService);
        this.sheetRepository = sheetRepository;
        this.optionService = optionService;
    }

    @NonNull
    public SheetCommentWithSheetVO convertToWithSheetVo(@NonNull SheetComment comment) {
        Assert.notNull((Object)comment, (String)"SheetComment must not be null");
        SheetCommentWithSheetVO sheetCommentWithSheetVo = (SheetCommentWithSheetVO)new SheetCommentWithSheetVO().convertFrom((Object)comment);
        BasePostMinimalDTO basePostMinimalDto = (BasePostMinimalDTO)new BasePostMinimalDTO().convertFrom((Object)((BasePost)this.sheetRepository.getOne((Object)comment.getPostId())));
        sheetCommentWithSheetVo.setSheet(this.buildSheetFullPath(basePostMinimalDto));
        sheetCommentWithSheetVo.setAvatar(this.buildAvatarUrl(comment.getGravatarMd5()));
        return sheetCommentWithSheetVo;
    }

    @NonNull
    public List<SheetCommentWithSheetVO> convertToWithSheetVo(List<SheetComment> sheetComments) {
        if (CollectionUtils.isEmpty(sheetComments)) {
            return Collections.emptyList();
        }
        Set sheetIds = ServiceUtils.fetchProperty(sheetComments, BaseComment::getPostId);
        Map sheetMap = ServiceUtils.convertToMap((Collection)this.sheetRepository.findAllById((Iterable)sheetIds), BasePost::getId);
        return sheetComments.stream().filter(comment -> sheetMap.containsKey(comment.getPostId())).map(comment -> {
            SheetCommentWithSheetVO sheetCmtWithPostVo = (SheetCommentWithSheetVO)new SheetCommentWithSheetVO().convertFrom(comment);
            BasePostMinimalDTO postMinimalDto = (BasePostMinimalDTO)new BasePostMinimalDTO().convertFrom((Object)((BasePost)sheetMap.get(comment.getPostId())));
            sheetCmtWithPostVo.setSheet(this.buildSheetFullPath(postMinimalDto));
            sheetCmtWithPostVo.setAvatar(this.buildAvatarUrl(comment.getGravatarMd5()));
            return sheetCmtWithPostVo;
        }).collect(Collectors.toList());
    }

    @NonNull
    public Page<SheetCommentWithSheetVO> convertToWithSheetVo(@NonNull Page<SheetComment> sheetCommentPage) {
        Assert.notNull(sheetCommentPage, (String)"Sheet comment page must not be null");
        return new PageImpl(this.convertToWithSheetVo(sheetCommentPage.getContent()), sheetCommentPage.getPageable(), sheetCommentPage.getTotalElements());
    }

    private BasePostMinimalDTO buildSheetFullPath(BasePostMinimalDTO basePostMinimalDto) {
        StringBuilder fullPath = new StringBuilder();
        SheetPermalinkType permalinkType = this.optionService.getSheetPermalinkType();
        if (this.optionService.isEnabledAbsolutePath().booleanValue()) {
            fullPath.append(this.optionService.getBlogBaseUrl());
        }
        if (permalinkType.equals((Object)SheetPermalinkType.SECONDARY)) {
            fullPath.append("/").append(this.optionService.getSheetPrefix()).append("/").append(basePostMinimalDto.getSlug()).append(this.optionService.getPathSuffix());
        } else if (permalinkType.equals((Object)SheetPermalinkType.ROOT)) {
            fullPath.append("/").append(basePostMinimalDto.getSlug()).append(this.optionService.getPathSuffix());
        }
        basePostMinimalDto.setFullPath(fullPath.toString());
        return basePostMinimalDto;
    }
}

