/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.base;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.exception.NotFoundException;
import run.halo.app.repository.base.BaseRepository;
import run.halo.app.service.base.CrudService;

public abstract class AbstractCrudService<DOMAIN, ID>
implements CrudService<DOMAIN, ID> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCrudService.class);
    private final String domainName;
    private final BaseRepository<DOMAIN, ID> repository;

    protected AbstractCrudService(BaseRepository<DOMAIN, ID> repository) {
        this.repository = repository;
        Class domainClass = (Class)this.fetchType(0);
        this.domainName = domainClass.getSimpleName();
    }

    private Type fetchType(int index) {
        Assert.isTrue((index >= 0 && index <= 1 ? 1 : 0) != 0, (String)"type index must be between 0 to 1");
        return ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[index];
    }

    public List<DOMAIN> listAll() {
        return this.repository.findAll();
    }

    public List<DOMAIN> listAll(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort info must not be null");
        return this.repository.findAll(sort);
    }

    public Page<DOMAIN> listAll(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable info must not be null");
        return this.repository.findAll(pageable);
    }

    public List<DOMAIN> listAllByIds(Collection<ID> ids) {
        return CollectionUtils.isEmpty(ids) ? Collections.emptyList() : this.repository.findAllById(ids);
    }

    public List<DOMAIN> listAllByIds(Collection<ID> ids, Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort info must not be null");
        return CollectionUtils.isEmpty(ids) ? Collections.emptyList() : this.repository.findAllByIdIn(ids, sort);
    }

    public Optional<DOMAIN> fetchById(ID id) {
        Assert.notNull(id, (String)(this.domainName + " id must not be null"));
        return this.repository.findById(id);
    }

    public DOMAIN getById(ID id) {
        return (DOMAIN)this.fetchById(id).orElseThrow(() -> new NotFoundException(this.domainName + " was not found or has been deleted"));
    }

    public DOMAIN getByIdOfNullable(ID id) {
        return this.fetchById(id).orElse(null);
    }

    public boolean existsById(ID id) {
        Assert.notNull(id, (String)(this.domainName + " id must not be null"));
        return this.repository.existsById(id);
    }

    public void mustExistById(ID id) {
        if (!this.existsById(id)) {
            throw new NotFoundException(this.domainName + " was not exist");
        }
    }

    public long count() {
        return this.repository.count();
    }

    public DOMAIN create(DOMAIN domain) {
        Assert.notNull(domain, (String)(this.domainName + " data must not be null"));
        return (DOMAIN)this.repository.save(domain);
    }

    public List<DOMAIN> createInBatch(Collection<DOMAIN> domains) {
        return CollectionUtils.isEmpty(domains) ? Collections.emptyList() : this.repository.saveAll(domains);
    }

    public DOMAIN update(DOMAIN domain) {
        Assert.notNull(domain, (String)(this.domainName + " data must not be null"));
        return (DOMAIN)this.repository.saveAndFlush(domain);
    }

    public void flush() {
        this.repository.flush();
    }

    public List<DOMAIN> updateInBatch(Collection<DOMAIN> domains) {
        return CollectionUtils.isEmpty(domains) ? Collections.emptyList() : this.repository.saveAll(domains);
    }

    public DOMAIN removeById(ID id) {
        Object domain = this.getById(id);
        this.remove(domain);
        return (DOMAIN)domain;
    }

    public DOMAIN removeByIdOfNullable(ID id) {
        return this.fetchById(id).map(domain -> {
            this.remove(domain);
            return domain;
        }).orElse(null);
    }

    public void remove(DOMAIN domain) {
        Assert.notNull(domain, (String)(this.domainName + " data must not be null"));
        this.repository.delete(domain);
    }

    public void removeInBatch(Collection<ID> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            log.debug(this.domainName + " id collection is empty");
            return;
        }
        this.repository.deleteByIdIn(ids);
    }

    public void removeAll(Collection<DOMAIN> domains) {
        if (CollectionUtils.isEmpty(domains)) {
            log.debug(this.domainName + " collection is empty");
            return;
        }
        this.repository.deleteInBatch(domains);
    }

    public void removeAll() {
        this.repository.deleteAll();
    }
}

