/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.base;

import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import run.halo.app.model.entity.BasePost;
import run.halo.app.model.entity.Content;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.service.base.CrudService;

public interface BasePostService<POST extends BasePost>
extends CrudService<POST, Integer> {
    public long countVisit();

    public long countLike();

    public long countByStatus(PostStatus var1);

    @NonNull
    public POST getBySlug(@NonNull String var1);

    public POST getWithLatestContentById(Integer var1);

    @NonNull
    public POST getBy(@NonNull PostStatus var1, @NonNull String var2);

    @NonNull
    public POST getBy(@NonNull PostStatus var1, @NonNull Integer var2);

    public Content getContentById(Integer var1);

    public Content.PatchedContent getLatestContentById(Integer var1);

    @NonNull
    public List<POST> listAllBy(@NonNull PostStatus var1);

    @NonNull
    public List<POST> listPrevPosts(@NonNull POST var1, int var2);

    @NonNull
    public List<POST> listNextPosts(@NonNull POST var1, int var2);

    @NonNull
    public Optional<POST> getPrevPost(@NonNull POST var1);

    @NonNull
    public Optional<POST> getNextPost(@NonNull POST var1);

    @NonNull
    public Page<POST> pageLatest(int var1);

    @NonNull
    public List<POST> listLatest(int var1);

    @NonNull
    public Page<POST> pageBy(@NonNull Pageable var1);

    @NonNull
    public Page<POST> pageBy(@NonNull PostStatus var1, @NonNull Pageable var2);

    public void increaseVisit(long var1, @NonNull Integer var3);

    public void increaseVisit(@NonNull Integer var1);

    public void increaseLike(long var1, @NonNull Integer var3);

    public void increaseLike(@NonNull Integer var1);

    @NonNull
    public POST createOrUpdateBy(@NonNull POST var1);

    @NonNull
    public POST updateDraftContent(@Nullable String var1, String var2, @NonNull Integer var3);

    @NonNull
    public POST updateStatus(@NonNull PostStatus var1, @NonNull Integer var2);

    @NonNull
    public List<POST> updateStatusByIds(@NonNull List<Integer> var1, @NonNull PostStatus var2);

    public String generateDescription(@Nullable String var1);
}

