/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.base;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.transaction.annotation.Transactional;

public interface CrudService<D, I> {
    @NonNull
    public List<D> listAll();

    @NonNull
    public List<D> listAll(@NonNull Sort var1);

    @NonNull
    public Page<D> listAll(@NonNull Pageable var1);

    @NonNull
    public List<D> listAllByIds(@Nullable Collection<I> var1);

    @NonNull
    public List<D> listAllByIds(@Nullable Collection<I> var1, @NonNull Sort var2);

    @NonNull
    public Optional<D> fetchById(@NonNull I var1);

    @NonNull
    public D getById(@NonNull I var1);

    @Nullable
    public D getByIdOfNullable(@NonNull I var1);

    public boolean existsById(@NonNull I var1);

    public void mustExistById(@NonNull I var1);

    public long count();

    @NonNull
    @Transactional
    public D create(@NonNull D var1);

    @NonNull
    @Transactional
    public List<D> createInBatch(@NonNull Collection<D> var1);

    @NonNull
    @Transactional
    public D update(@NonNull D var1);

    public void flush();

    @NonNull
    @Transactional
    public List<D> updateInBatch(@NonNull Collection<D> var1);

    @NonNull
    @Transactional
    public D removeById(@NonNull I var1);

    @Nullable
    @Transactional
    public D removeByIdOfNullable(@NonNull I var1);

    @Transactional
    public void remove(@NonNull D var1);

    @Transactional
    public void removeInBatch(@NonNull Collection<I> var1);

    @Transactional
    public void removeAll(@NonNull Collection<D> var1);

    @Transactional
    public void removeAll();
}

