/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import run.halo.app.cache.AbstractStringCacheStore;
import run.halo.app.config.properties.HaloProperties;
import run.halo.app.event.logger.LogEvent;
import run.halo.app.exception.BadRequestException;
import run.halo.app.exception.NotFoundException;
import run.halo.app.exception.ServiceException;
import run.halo.app.mail.MailService;
import run.halo.app.model.dto.EnvironmentDTO;
import run.halo.app.model.dto.LoginPreCheckDTO;
import run.halo.app.model.entity.User;
import run.halo.app.model.enums.LogType;
import run.halo.app.model.enums.MFAType;
import run.halo.app.model.params.LoginParam;
import run.halo.app.model.params.ResetPasswordParam;
import run.halo.app.model.params.ResetPasswordSendCodeParam;
import run.halo.app.model.properties.EmailProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.support.HaloConst;
import run.halo.app.security.authentication.Authentication;
import run.halo.app.security.context.SecurityContextHolder;
import run.halo.app.security.token.AuthToken;
import run.halo.app.security.util.SecurityUtils;
import run.halo.app.service.AdminService;
import run.halo.app.service.OptionService;
import run.halo.app.service.UserService;
import run.halo.app.utils.HaloUtils;
import run.halo.app.utils.TwoFactorAuthUtils;
import run.halo.app.utils.ValidationUtils;

@Service
public class AdminServiceImpl
implements AdminService {
    private static final Logger log = LoggerFactory.getLogger(AdminServiceImpl.class);
    private final OptionService optionService;
    private final UserService userService;
    private final MailService mailService;
    private final AbstractStringCacheStore cacheStore;
    private final HaloProperties haloProperties;
    private final ApplicationEventPublisher eventPublisher;

    public AdminServiceImpl(OptionService optionService, UserService userService, MailService mailService, AbstractStringCacheStore cacheStore, HaloProperties haloProperties, ApplicationEventPublisher eventPublisher) {
        this.optionService = optionService;
        this.userService = userService;
        this.mailService = mailService;
        this.cacheStore = cacheStore;
        this.haloProperties = haloProperties;
        this.eventPublisher = eventPublisher;
    }

    @NonNull
    public User authenticate(@NonNull LoginParam loginParam) {
        User user;
        Assert.notNull((Object)loginParam, (String)"Login param must not be null");
        String username = loginParam.getUsername();
        String mismatchTip = "\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u4e0d\u6b63\u786e";
        try {
            user = ValidationUtils.isEmail((String)username) ? this.userService.getByEmailOfNonNull(username) : this.userService.getByUsernameOfNonNull(username);
        }
        catch (NotFoundException e) {
            log.error("Failed to find user by name: " + username);
            this.eventPublisher.publishEvent((ApplicationEvent)new LogEvent((Object)this, loginParam.getUsername(), LogType.LOGIN_FAILED, loginParam.getUsername()));
            throw new BadRequestException(mismatchTip);
        }
        this.userService.mustNotExpire(user);
        if (!this.userService.passwordMatch(user, loginParam.getPassword())) {
            this.eventPublisher.publishEvent((ApplicationEvent)new LogEvent((Object)this, loginParam.getUsername(), LogType.LOGIN_FAILED, loginParam.getUsername()));
            throw new BadRequestException(mismatchTip);
        }
        return user;
    }

    @NonNull
    public AuthToken authCodeCheck(@NonNull LoginParam loginParam) {
        User user = this.authenticate(loginParam);
        if (MFAType.useMFA((MFAType)user.getMfaType())) {
            if (StringUtils.isBlank((CharSequence)loginParam.getAuthcode())) {
                throw new BadRequestException("\u8bf7\u8f93\u5165\u4e24\u6b65\u9a8c\u8bc1\u7801");
            }
            TwoFactorAuthUtils.validateTFACode((String)user.getMfaKey(), (String)loginParam.getAuthcode());
        }
        if (SecurityContextHolder.getContext().isAuthenticated()) {
            throw new BadRequestException("\u60a8\u5df2\u767b\u5f55\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u767b\u5f55");
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new LogEvent((Object)this, user.getUsername(), LogType.LOGGED_IN, user.getNickname()));
        return this.buildAuthToken(user);
    }

    public void clearToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new BadRequestException("\u60a8\u5c1a\u672a\u767b\u5f55\uff0c\u56e0\u6b64\u65e0\u6cd5\u6ce8\u9500");
        }
        User user = authentication.getDetail().getUser();
        this.cacheStore.getAny(SecurityUtils.buildAccessTokenKey((User)user), String.class).ifPresent(accessToken -> {
            this.cacheStore.delete((Object)SecurityUtils.buildTokenAccessKey((String)accessToken));
            this.cacheStore.delete((Object)SecurityUtils.buildAccessTokenKey((User)user));
        });
        this.cacheStore.getAny(SecurityUtils.buildRefreshTokenKey((User)user), String.class).ifPresent(refreshToken -> {
            this.cacheStore.delete((Object)SecurityUtils.buildTokenRefreshKey((String)refreshToken));
            this.cacheStore.delete((Object)SecurityUtils.buildRefreshTokenKey((User)user));
        });
        this.eventPublisher.publishEvent((ApplicationEvent)new LogEvent((Object)this, user.getUsername(), LogType.LOGGED_OUT, user.getNickname()));
        log.info("You have been logged out, looking forward to your next visit!");
    }

    public void sendResetPasswordCode(ResetPasswordSendCodeParam param) {
        this.cacheStore.getAny("code", String.class).ifPresent(code -> {
            throw new ServiceException("\u5df2\u7ecf\u83b7\u53d6\u8fc7\u9a8c\u8bc1\u7801\uff0c\u4e0d\u80fd\u91cd\u590d\u83b7\u53d6");
        });
        if (!this.userService.verifyUser(param.getUsername(), param.getEmail())) {
            throw new ServiceException("\u7528\u6237\u540d\u6216\u8005\u90ae\u7bb1\u9a8c\u8bc1\u9519\u8bef");
        }
        String code2 = RandomStringUtils.randomNumeric((int)6);
        log.info("Got reset password code:{}", (Object)code2);
        this.cacheStore.putAny("code", (Object)code2, 5L, TimeUnit.MINUTES);
        Boolean emailEnabled = (Boolean)this.optionService.getByPropertyOrDefault((PropertyEnum)EmailProperties.ENABLED, Boolean.class, (Object)false);
        if (!emailEnabled.booleanValue()) {
            throw new ServiceException("\u672a\u542f\u7528 SMTP \u670d\u52a1\uff0c\u65e0\u6cd5\u53d1\u9001\u90ae\u4ef6\uff0c\u4f46\u662f\u4f60\u53ef\u4ee5\u901a\u8fc7\u7cfb\u7edf\u65e5\u5fd7\u627e\u5230\u9a8c\u8bc1\u7801");
        }
        String content = "\u60a8\u6b63\u5728\u8fdb\u884c\u5bc6\u7801\u91cd\u7f6e\u64cd\u4f5c\uff0c\u5982\u4e0d\u662f\u672c\u4eba\u64cd\u4f5c\uff0c\u8bf7\u5c3d\u5feb\u505a\u597d\u76f8\u5e94\u63aa\u65bd\u3002\u5bc6\u7801\u91cd\u7f6e\u9a8c\u8bc1\u7801\u5982\u4e0b\uff08\u4e94\u5206\u949f\u6709\u6548\uff09\uff1a\n" + code2;
        this.mailService.sendTextMail(param.getEmail(), "\u627e\u56de\u5bc6\u7801\u9a8c\u8bc1\u7801", content);
    }

    public void resetPasswordByCode(ResetPasswordParam param) {
        if (StringUtils.isEmpty((CharSequence)param.getCode())) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)param.getPassword())) {
            throw new ServiceException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.userService.verifyUser(param.getUsername(), param.getEmail())) {
            throw new ServiceException("\u7528\u6237\u540d\u6216\u8005\u90ae\u7bb1\u9a8c\u8bc1\u9519\u8bef");
        }
        String code = (String)this.cacheStore.getAny("code", String.class).orElseThrow(() -> new ServiceException("\u672a\u83b7\u53d6\u8fc7\u9a8c\u8bc1\u7801"));
        if (!code.equals(param.getCode())) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
        User user = (User)this.userService.getCurrentUser().orElseThrow(() -> new ServiceException("\u672a\u67e5\u8be2\u5230\u535a\u4e3b\u4fe1\u606f"));
        this.userService.setPassword(user, param.getPassword());
        this.userService.update((Object)user);
        this.cacheStore.delete((Object)"code");
    }

    @NonNull
    public EnvironmentDTO getEnvironments() {
        EnvironmentDTO environmentDto = new EnvironmentDTO();
        environmentDto.setStartTime(Long.valueOf(ManagementFactory.getRuntimeMXBean().getStartTime()));
        environmentDto.setDatabase(HaloConst.DATABASE_PRODUCT_NAME);
        environmentDto.setVersion(HaloConst.HALO_VERSION);
        environmentDto.setMode(this.haloProperties.getMode());
        return environmentDto;
    }

    @NonNull
    public AuthToken refreshToken(@NonNull String refreshToken) {
        Assert.hasText((String)refreshToken, (String)"Refresh token must not be blank");
        Integer userId = (Integer)this.cacheStore.getAny(SecurityUtils.buildTokenRefreshKey((String)refreshToken), Integer.class).orElseThrow(() -> new BadRequestException("\u767b\u5f55\u72b6\u6001\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55").setErrorData((Object)refreshToken));
        User user = (User)this.userService.getById((Object)userId);
        this.cacheStore.getAny(SecurityUtils.buildAccessTokenKey((User)user), String.class).ifPresent(accessToken -> this.cacheStore.delete((Object)SecurityUtils.buildTokenAccessKey((String)accessToken)));
        this.cacheStore.delete((Object)SecurityUtils.buildTokenRefreshKey((String)refreshToken));
        this.cacheStore.delete((Object)SecurityUtils.buildAccessTokenKey((User)user));
        this.cacheStore.delete((Object)SecurityUtils.buildRefreshTokenKey((User)user));
        return this.buildAuthToken(user);
    }

    @NonNull
    private AuthToken buildAuthToken(@NonNull User user) {
        Assert.notNull((Object)user, (String)"User must not be null");
        AuthToken token = new AuthToken();
        token.setAccessToken(HaloUtils.randomUUIDWithoutDash());
        token.setExpiredIn(86400);
        token.setRefreshToken(HaloUtils.randomUUIDWithoutDash());
        this.cacheStore.putAny(SecurityUtils.buildAccessTokenKey((User)user), (Object)token.getAccessToken(), 86400L, TimeUnit.SECONDS);
        this.cacheStore.putAny(SecurityUtils.buildRefreshTokenKey((User)user), (Object)token.getRefreshToken(), 30L, TimeUnit.DAYS);
        this.cacheStore.putAny(SecurityUtils.buildTokenAccessKey((String)token.getAccessToken()), (Object)user.getId(), 86400L, TimeUnit.SECONDS);
        this.cacheStore.putAny(SecurityUtils.buildTokenRefreshKey((String)token.getRefreshToken()), (Object)user.getId(), 30L, TimeUnit.DAYS);
        return token;
    }

    public String getLogFiles(@NonNull Long lines) {
        Assert.notNull((Object)lines, (String)"Lines must not be null");
        File file = new File(this.haloProperties.getWorkDir(), "logs/spring.log");
        ArrayList<String> linesArray = new ArrayList<String>();
        StringBuilder result = new StringBuilder();
        if (!file.exists()) {
            return "";
        }
        long count = 0L;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            long length = randomAccessFile.length();
            if (length == 0L) {
                String string = "";
                return string;
            }
            long pos = length - 1L;
            while (pos > 0L) {
                randomAccessFile.seek(--pos);
                if (randomAccessFile.readByte() != 10) continue;
                String line2 = randomAccessFile.readLine();
                linesArray.add(new String(line2.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8));
                if (++count != lines) continue;
                break;
            }
            if (pos == 0L) {
                randomAccessFile.seek(0L);
                linesArray.add(new String(randomAccessFile.readLine().getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u8bfb\u53d6\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Collections.reverse(linesArray);
        linesArray.forEach(line -> result.append((String)line).append("\n"));
        return result.toString();
    }

    public LoginPreCheckDTO getUserEnv(@NonNull String username) {
        Assert.notNull((Object)username, (String)"username must not be null");
        boolean useMFA = true;
        try {
            User user = ValidationUtils.isEmail((String)username) ? this.userService.getByEmailOfNonNull(username) : this.userService.getByUsernameOfNonNull(username);
            useMFA = MFAType.useMFA((MFAType)user.getMfaType());
        }
        catch (NotFoundException e) {
            log.error("Failed to find user by name: " + username, (Throwable)e);
            this.eventPublisher.publishEvent((ApplicationEvent)new LogEvent((Object)this, username, LogType.LOGIN_FAILED, username));
        }
        return new LoginPreCheckDTO(useMFA);
    }
}

