/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.exception.AlreadyExistsException;
import run.halo.app.handler.file.FileHandlers;
import run.halo.app.model.dto.AttachmentDTO;
import run.halo.app.model.entity.Attachment;
import run.halo.app.model.enums.AttachmentType;
import run.halo.app.model.params.AttachmentQuery;
import run.halo.app.model.properties.AttachmentProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.support.UploadResult;
import run.halo.app.repository.AttachmentRepository;
import run.halo.app.repository.base.BaseRepository;
import run.halo.app.service.AttachmentService;
import run.halo.app.service.OptionService;
import run.halo.app.service.base.AbstractCrudService;
import run.halo.app.utils.HaloUtils;

@Service
public class AttachmentServiceImpl
extends AbstractCrudService<Attachment, Integer>
implements AttachmentService {
    private static final Logger log = LoggerFactory.getLogger(AttachmentServiceImpl.class);
    private final AttachmentRepository attachmentRepository;
    private final OptionService optionService;
    private final FileHandlers fileHandlers;

    public AttachmentServiceImpl(AttachmentRepository attachmentRepository, OptionService optionService, FileHandlers fileHandlers) {
        super((BaseRepository)attachmentRepository);
        this.attachmentRepository = attachmentRepository;
        this.optionService = optionService;
        this.fileHandlers = fileHandlers;
    }

    public Page<AttachmentDTO> pageDtosBy(@NonNull Pageable pageable, AttachmentQuery attachmentQuery) {
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        Page attachmentPage = this.attachmentRepository.findAll(this.buildSpecByQuery(attachmentQuery), pageable);
        return attachmentPage.map(arg_0 -> this.convertToDto(arg_0));
    }

    @NonNull
    private Specification<Attachment> buildSpecByQuery(@NonNull AttachmentQuery attachmentQuery) {
        Assert.notNull((Object)attachmentQuery, (String)"Attachment query must not be null");
        return (Specification & Serializable)(root, query, criteriaBuilder) -> {
            LinkedList<Predicate> predicates = new LinkedList<Predicate>();
            if (attachmentQuery.getMediaType() != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("mediaType"), (Object)attachmentQuery.getMediaType()));
            }
            if (attachmentQuery.getAttachmentType() != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("type"), (Object)attachmentQuery.getAttachmentType()));
            }
            if (attachmentQuery.getKeyword() != null) {
                String likeCondition = String.format("%%%s%%", StringUtils.strip((String)attachmentQuery.getKeyword()));
                Predicate nameLike = criteriaBuilder.like((Expression)root.get("name"), likeCondition);
                predicates.add(criteriaBuilder.or(new Predicate[]{nameLike}));
            }
            return query.where(predicates.toArray(new Predicate[0])).getRestriction();
        };
    }

    public Attachment upload(MultipartFile file) {
        Assert.notNull((Object)file, (String)"Multipart file must not be null");
        AttachmentType attachmentType = this.getAttachmentType();
        log.debug("Starting uploading... type: [{}], file: [{}]", (Object)attachmentType, (Object)file.getOriginalFilename());
        UploadResult uploadResult = this.fileHandlers.upload(file, attachmentType);
        log.debug("Attachment type: [{}]", (Object)attachmentType);
        log.debug("Upload result: [{}]", (Object)uploadResult);
        Attachment attachment = new Attachment();
        attachment.setName(uploadResult.getFilename());
        attachment.setPath(HaloUtils.changeFileSeparatorToUrlSeparator((String)uploadResult.getFilePath()));
        attachment.setFileKey(uploadResult.getKey());
        attachment.setThumbPath(uploadResult.getThumbPath());
        attachment.setMediaType(uploadResult.getMediaType().toString());
        attachment.setSuffix(uploadResult.getSuffix());
        attachment.setWidth(uploadResult.getWidth());
        attachment.setHeight(uploadResult.getHeight());
        attachment.setSize(uploadResult.getSize());
        attachment.setType(attachmentType);
        log.debug("Creating attachment: [{}]", (Object)attachment);
        return this.create(attachment);
    }

    public Attachment removePermanently(Integer id) {
        Attachment deletedAttachment = (Attachment)this.removeById((Object)id);
        this.fileHandlers.delete(deletedAttachment);
        log.debug("Deleted attachment: [{}]", (Object)deletedAttachment);
        return deletedAttachment;
    }

    public List<Attachment> removePermanently(@Nullable Collection<Integer> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return ids.stream().map(arg_0 -> this.removePermanently(arg_0)).collect(Collectors.toList());
    }

    public AttachmentDTO convertToDto(Attachment attachment) {
        Assert.notNull((Object)attachment, (String)"Attachment must not be null");
        String blogBaseUrl = this.optionService.getBlogBaseUrl();
        Boolean enabledAbsolutePath = this.optionService.isEnabledAbsolutePath();
        AttachmentDTO attachmentDTO = (AttachmentDTO)new AttachmentDTO().convertFrom((Object)attachment);
        if (Objects.equals(attachmentDTO.getType(), AttachmentType.LOCAL)) {
            String fullPath = StringUtils.join((Object[])new String[]{enabledAbsolutePath != false ? blogBaseUrl : "", "/", attachmentDTO.getPath()});
            String fullThumbPath = StringUtils.join((Object[])new String[]{enabledAbsolutePath != false ? blogBaseUrl : "", "/", attachmentDTO.getThumbPath()});
            attachmentDTO.setPath(fullPath);
            attachmentDTO.setThumbPath(fullThumbPath);
        }
        return attachmentDTO;
    }

    public List<String> listAllMediaType() {
        return this.attachmentRepository.findAllMediaType();
    }

    public List<AttachmentType> listAllType() {
        return this.attachmentRepository.findAllType();
    }

    public Attachment create(Attachment attachment) {
        Assert.notNull((Object)attachment, (String)"Attachment must not be null");
        this.pathMustNotExist(attachment);
        return (Attachment)super.create((Object)attachment);
    }

    private void pathMustNotExist(@NonNull Attachment attachment) {
        Assert.notNull((Object)attachment, (String)"Attachment must not be null");
        long pathCount = this.attachmentRepository.countByPath(attachment.getPath());
        if (pathCount > 0L) {
            throw new AlreadyExistsException("\u9644\u4ef6\u8def\u5f84\u4e3a " + attachment.getPath() + " \u5df2\u7ecf\u5b58\u5728");
        }
    }

    @NonNull
    private AttachmentType getAttachmentType() {
        return Objects.requireNonNull((AttachmentType)this.optionService.getEnumByPropertyOrDefault((PropertyEnum)AttachmentProperties.ATTACHMENT_TYPE, AttachmentType.class, (Enum)AttachmentType.LOCAL));
    }
}

