/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.config.properties.HaloProperties;
import run.halo.app.event.options.OptionUpdatedEvent;
import run.halo.app.event.theme.ThemeUpdatedEvent;
import run.halo.app.exception.BadRequestException;
import run.halo.app.exception.NotFoundException;
import run.halo.app.exception.ServiceException;
import run.halo.app.handler.file.FileHandler;
import run.halo.app.model.dto.BackupDTO;
import run.halo.app.model.dto.post.BasePostDetailDTO;
import run.halo.app.model.entity.Attachment;
import run.halo.app.model.entity.Category;
import run.halo.app.model.entity.CommentBlackList;
import run.halo.app.model.entity.Content;
import run.halo.app.model.entity.ContentPatchLog;
import run.halo.app.model.entity.Journal;
import run.halo.app.model.entity.JournalComment;
import run.halo.app.model.entity.Link;
import run.halo.app.model.entity.Log;
import run.halo.app.model.entity.Menu;
import run.halo.app.model.entity.Option;
import run.halo.app.model.entity.Photo;
import run.halo.app.model.entity.Post;
import run.halo.app.model.entity.PostCategory;
import run.halo.app.model.entity.PostComment;
import run.halo.app.model.entity.PostMeta;
import run.halo.app.model.entity.PostTag;
import run.halo.app.model.entity.Sheet;
import run.halo.app.model.entity.SheetComment;
import run.halo.app.model.entity.SheetMeta;
import run.halo.app.model.entity.Tag;
import run.halo.app.model.entity.ThemeSetting;
import run.halo.app.model.entity.User;
import run.halo.app.model.params.PostMarkdownParam;
import run.halo.app.model.support.HaloConst;
import run.halo.app.model.vo.PostMarkdownVO;
import run.halo.app.security.service.OneTimeTokenService;
import run.halo.app.service.AttachmentService;
import run.halo.app.service.BackupService;
import run.halo.app.service.CategoryService;
import run.halo.app.service.CommentBlackListService;
import run.halo.app.service.ContentPatchLogService;
import run.halo.app.service.ContentService;
import run.halo.app.service.JournalCommentService;
import run.halo.app.service.JournalService;
import run.halo.app.service.LinkService;
import run.halo.app.service.LogService;
import run.halo.app.service.MenuService;
import run.halo.app.service.OptionService;
import run.halo.app.service.PhotoService;
import run.halo.app.service.PostCategoryService;
import run.halo.app.service.PostCommentService;
import run.halo.app.service.PostMetaService;
import run.halo.app.service.PostService;
import run.halo.app.service.PostTagService;
import run.halo.app.service.SheetCommentService;
import run.halo.app.service.SheetMetaService;
import run.halo.app.service.SheetService;
import run.halo.app.service.TagService;
import run.halo.app.service.ThemeSettingService;
import run.halo.app.service.UserService;
import run.halo.app.service.impl.BackupServiceImpl;
import run.halo.app.utils.DateTimeUtils;
import run.halo.app.utils.DateUtils;
import run.halo.app.utils.FileUtils;
import run.halo.app.utils.HaloUtils;
import run.halo.app.utils.JsonUtils;
import run.halo.app.utils.VersionUtil;

@Service
public class BackupServiceImpl
implements BackupService {
    private static final Logger log = LoggerFactory.getLogger(BackupServiceImpl.class);
    private static final String BACKUP_RESOURCE_BASE_URI = "/api/admin/backups/work-dir";
    private static final String DATA_EXPORT_MARKDOWN_BASE_URI = "/api/admin/backups/markdown/export";
    private static final String DATA_EXPORT_BASE_URI = "/api/admin/backups/data";
    private static final String UPLOAD_SUB_DIR = "upload/";
    private final AttachmentService attachmentService;
    private final CategoryService categoryService;
    private final CommentBlackListService commentBlackListService;
    private final JournalService journalService;
    private final JournalCommentService journalCommentService;
    private final LinkService linkService;
    private final LogService logService;
    private final MenuService menuService;
    private final OptionService optionService;
    private final PhotoService photoService;
    private final PostService postService;
    private final ContentService contentService;
    private final ContentPatchLogService contentPatchLogService;
    private final PostCategoryService postCategoryService;
    private final PostCommentService postCommentService;
    private final PostMetaService postMetaService;
    private final PostTagService postTagService;
    private final SheetService sheetService;
    private final SheetCommentService sheetCommentService;
    private final SheetMetaService sheetMetaService;
    private final TagService tagService;
    private final ThemeSettingService themeSettingService;
    private final UserService userService;
    private final OneTimeTokenService oneTimeTokenService;
    private final HaloProperties haloProperties;
    private final ApplicationEventPublisher eventPublisher;

    public BackupServiceImpl(AttachmentService attachmentService, CategoryService categoryService, CommentBlackListService commentBlackListService, JournalService journalService, JournalCommentService journalCommentService, LinkService linkService, LogService logService, MenuService menuService, OptionService optionService, PhotoService photoService, PostService postService, ContentService contentService, ContentPatchLogService contentPatchLogService, PostCategoryService postCategoryService, PostCommentService postCommentService, PostMetaService postMetaService, PostTagService postTagService, SheetService sheetService, SheetCommentService sheetCommentService, SheetMetaService sheetMetaService, TagService tagService, ThemeSettingService themeSettingService, UserService userService, OneTimeTokenService oneTimeTokenService, HaloProperties haloProperties, ApplicationEventPublisher eventPublisher) {
        this.attachmentService = attachmentService;
        this.categoryService = categoryService;
        this.commentBlackListService = commentBlackListService;
        this.journalService = journalService;
        this.journalCommentService = journalCommentService;
        this.linkService = linkService;
        this.logService = logService;
        this.menuService = menuService;
        this.optionService = optionService;
        this.photoService = photoService;
        this.postService = postService;
        this.contentService = contentService;
        this.contentPatchLogService = contentPatchLogService;
        this.postCategoryService = postCategoryService;
        this.postCommentService = postCommentService;
        this.postMetaService = postMetaService;
        this.postTagService = postTagService;
        this.sheetService = sheetService;
        this.sheetCommentService = sheetCommentService;
        this.sheetMetaService = sheetMetaService;
        this.tagService = tagService;
        this.themeSettingService = themeSettingService;
        this.userService = userService;
        this.oneTimeTokenService = oneTimeTokenService;
        this.haloProperties = haloProperties;
        this.eventPublisher = eventPublisher;
    }

    public BasePostDetailDTO importMarkdown(MultipartFile file) throws IOException {
        String markdown = FileUtils.readString((InputStream)file.getInputStream());
        return this.postService.importMarkdown(markdown, file.getOriginalFilename());
    }

    public BackupDTO backupWorkDirectory(List<String> options) {
        if (CollectionUtils.isEmpty(options)) {
            throw new BadRequestException("The options parameter is missing, at least one.");
        }
        try {
            String haloZipFileName = "halo-backup-" + DateTimeUtils.format((LocalDateTime)LocalDateTime.now(), (DateTimeFormatter)DateTimeUtils.HORIZONTAL_LINE_DATETIME_FORMATTER) + HaloUtils.simpleUUID().hashCode() + ".zip";
            Path haloZipFilePath = Paths.get(this.haloProperties.getBackupDir(), haloZipFileName);
            if (!Files.exists(haloZipFilePath.getParent(), new LinkOption[0])) {
                Files.createDirectories(haloZipFilePath.getParent(), new FileAttribute[0]);
            }
            Path haloZipPath = Files.createFile(haloZipFilePath, new FileAttribute[0]);
            FileUtils.zip((Path)Paths.get(this.haloProperties.getWorkDir(), new String[0]), (Path)haloZipPath, path -> {
                for (String itemToBackup : options) {
                    Path backupItemPath = Paths.get(this.haloProperties.getWorkDir(), new String[0]).resolve(itemToBackup);
                    if (!path.startsWith(backupItemPath)) continue;
                    return true;
                }
                return false;
            });
            return this.buildBackupDto(BACKUP_RESOURCE_BASE_URI, haloZipPath);
        }
        catch (IOException e) {
            throw new ServiceException("Failed to backup halo", (Throwable)e);
        }
    }

    public List<BackupDTO> listWorkDirBackups() {
        List<BackupDTO> list;
        block9: {
            Path backupParentPath = Paths.get(this.haloProperties.getBackupDir(), new String[0]);
            if (Files.notExists(backupParentPath, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> subPathStream = Files.list(backupParentPath);
            try {
                list = subPathStream.filter(backupPath -> StringUtils.startsWithIgnoreCase((CharSequence)backupPath.getFileName().toString(), (CharSequence)"halo-backup-")).map(backupPath -> this.buildBackupDto(BACKUP_RESOURCE_BASE_URI, backupPath)).sorted(Comparator.comparingLong(BackupDTO::getUpdateTime).reversed()).collect(Collectors.toList());
                if (subPathStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (subPathStream != null) {
                        try {
                            subPathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ServiceException("Failed to fetch backups", (Throwable)e);
                }
            }
            subPathStream.close();
        }
        return list;
    }

    public Optional<BackupDTO> getBackup(@NonNull Path backupFilePath, @NonNull BackupService.BackupType type) {
        if (Files.notExists(backupFilePath, new LinkOption[0])) {
            return Optional.empty();
        }
        BackupDTO backupDto = this.buildBackupDto(type.getBaseUri(), backupFilePath);
        return Optional.of(backupDto);
    }

    public void deleteWorkDirBackup(String fileName) {
        Assert.hasText((String)fileName, (String)"File name must not be blank");
        Path backupRootPath = Paths.get(this.haloProperties.getBackupDir(), new String[0]);
        Path backupPath = backupRootPath.resolve(fileName);
        FileUtils.checkDirectoryTraversal((Path)backupRootPath, (Path)backupPath);
        try {
            Files.delete(backupPath);
        }
        catch (NoSuchFileException e) {
            throw new NotFoundException("The file " + fileName + " was not found", (Throwable)e);
        }
        catch (IOException e) {
            throw new ServiceException("Failed to delete backup", (Throwable)e);
        }
    }

    public Resource loadFileAsResource(String basePath, String fileName) {
        Assert.hasText((String)basePath, (String)"Base path must not be blank");
        Assert.hasText((String)fileName, (String)"Backup file name must not be blank");
        Path backupParentPath = Paths.get(basePath, new String[0]);
        try {
            if (Files.notExists(backupParentPath, new LinkOption[0])) {
                Files.createDirectories(backupParentPath, new FileAttribute[0]);
            }
            Path backupFilePath = Paths.get(basePath, fileName).normalize();
            FileUtils.checkDirectoryTraversal((Path)backupParentPath, (Path)backupFilePath);
            UrlResource backupResource = new UrlResource(backupFilePath.toUri());
            if (!backupResource.exists()) {
                throw new NotFoundException("The file " + fileName + " was not found");
            }
            return backupResource;
        }
        catch (MalformedURLException e) {
            throw new NotFoundException("The file " + fileName + " was not found", (Throwable)e);
        }
        catch (IOException e) {
            throw new ServiceException("Failed to create backup parent path: " + backupParentPath, (Throwable)e);
        }
    }

    public BackupDTO exportData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("version", HaloConst.HALO_VERSION);
        data.put("export_date", DateUtils.now());
        data.put("attachments", this.attachmentService.listAll());
        data.put("categories", this.categoryService.listAll());
        data.put("comment_black_list", this.commentBlackListService.listAll());
        data.put("journals", this.journalService.listAll());
        data.put("journal_comments", this.journalCommentService.listAll());
        data.put("links", this.linkService.listAll());
        data.put("logs", this.logService.listAll());
        data.put("menus", this.menuService.listAll());
        data.put("options", this.optionService.listAll());
        data.put("photos", this.photoService.listAll());
        data.put("posts", this.postService.listAll());
        data.put("contents", this.contentService.listAll());
        data.put("content_patch_logs", this.contentPatchLogService.listAll());
        data.put("post_categories", this.postCategoryService.listAll());
        data.put("post_comments", this.postCommentService.listAll());
        data.put("post_metas", this.postMetaService.listAll());
        data.put("post_tags", this.postTagService.listAll());
        data.put("sheets", this.sheetService.listAll());
        data.put("sheet_comments", this.sheetCommentService.listAll());
        data.put("sheet_metas", this.sheetMetaService.listAll());
        data.put("tags", this.tagService.listAll());
        data.put("theme_settings", this.themeSettingService.listAll());
        data.put("user", this.userService.listAll());
        try {
            String haloDataFileName = "halo-data-export-" + DateTimeUtils.format((LocalDateTime)LocalDateTime.now(), (DateTimeFormatter)DateTimeUtils.HORIZONTAL_LINE_DATETIME_FORMATTER) + HaloUtils.simpleUUID().hashCode() + ".json";
            Path haloDataFilePath = Paths.get(this.haloProperties.getDataExportDir(), haloDataFileName);
            if (!Files.exists(haloDataFilePath.getParent(), new LinkOption[0])) {
                Files.createDirectories(haloDataFilePath.getParent(), new FileAttribute[0]);
            }
            Path haloDataPath = Files.createFile(haloDataFilePath, new FileAttribute[0]);
            FileUtils.writeStringToFile((File)haloDataPath.toFile(), (String)JsonUtils.objectToJson(data));
            return this.buildBackupDto(DATA_EXPORT_BASE_URI, haloDataPath);
        }
        catch (IOException e) {
            throw new ServiceException("\u5bfc\u51fa\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    public List<BackupDTO> listExportedData() {
        List<BackupDTO> list;
        block9: {
            Path exportedDataParentPath = Paths.get(this.haloProperties.getDataExportDir(), new String[0]);
            if (Files.notExists(exportedDataParentPath, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> subPathStream = Files.list(exportedDataParentPath);
            try {
                list = subPathStream.filter(backupPath -> StringUtils.startsWithIgnoreCase((CharSequence)backupPath.getFileName().toString(), (CharSequence)"halo-data-export-")).map(backupPath -> this.buildBackupDto(DATA_EXPORT_BASE_URI, backupPath)).sorted(Comparator.comparingLong(BackupDTO::getUpdateTime).reversed()).collect(Collectors.toList());
                if (subPathStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (subPathStream != null) {
                        try {
                            subPathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ServiceException("Failed to fetch exported data", (Throwable)e);
                }
            }
            subPathStream.close();
        }
        return list;
    }

    public void deleteExportedData(String fileName) {
        Assert.hasText((String)fileName, (String)"File name must not be blank");
        Path dataExportRootPath = Paths.get(this.haloProperties.getDataExportDir(), new String[0]);
        Path backupPath = dataExportRootPath.resolve(fileName);
        FileUtils.checkDirectoryTraversal((Path)dataExportRootPath, (Path)backupPath);
        try {
            Files.delete(backupPath);
        }
        catch (NoSuchFileException e) {
            throw new NotFoundException("The file " + fileName + " was not found", (Throwable)e);
        }
        catch (IOException e) {
            throw new ServiceException("Failed to delete backup", (Throwable)e);
        }
    }

    public void importData(MultipartFile file) throws IOException {
        1 typeRef;
        String jsonContent = FileUtils.readString((InputStream)file.getInputStream());
        ObjectMapper mapper = JsonUtils.createDefaultJsonMapper();
        HashMap data = (HashMap)mapper.readValue(jsonContent, (TypeReference)(typeRef = new /* Unavailable Anonymous Inner Class!! */));
        String version = Objects.requireNonNullElse(data.get("version"), "");
        if (!VersionUtil.hasSameMajorAndMinorVersion((String)HaloConst.HALO_VERSION, (String)version)) {
            throw new BadRequestException("\u5bfc\u5165\u6570\u636e\u7684\u4e3b\u6b21\u7248\u672c\u53f7\u4e0e\u5f53\u524d\u7cfb\u7edf\u7248\u672c\u53f7\u4e0d\u5339\u914d\uff0c\u4e0d\u652f\u6301\u5bfc\u5165\uff01");
        }
        List<Attachment> attachments = Arrays.asList((Attachment[])mapper.readValue(mapper.writeValueAsString(data.get("attachments")), Attachment[].class));
        this.attachmentService.createInBatch(attachments);
        List<Category> categories = Arrays.asList((Category[])mapper.readValue(mapper.writeValueAsString(data.get("categories")), Category[].class));
        this.categoryService.createInBatch(categories);
        List<Tag> tags = Arrays.asList((Tag[])mapper.readValue(mapper.writeValueAsString(data.get("tags")), Tag[].class));
        this.tagService.createInBatch(tags);
        List<CommentBlackList> commentBlackList = Arrays.asList((CommentBlackList[])mapper.readValue(mapper.writeValueAsString(data.get("comment_black_list")), CommentBlackList[].class));
        this.commentBlackListService.createInBatch(commentBlackList);
        List<Journal> journals = Arrays.asList((Journal[])mapper.readValue(mapper.writeValueAsString(data.get("journals")), Journal[].class));
        this.journalService.createInBatch(journals);
        List<JournalComment> journalComments = Arrays.asList((JournalComment[])mapper.readValue(mapper.writeValueAsString(data.get("journal_comments")), JournalComment[].class));
        this.journalCommentService.createInBatch(journalComments);
        List<Link> links = Arrays.asList((Link[])mapper.readValue(mapper.writeValueAsString(data.get("links")), Link[].class));
        this.linkService.createInBatch(links);
        List<Log> logs = Arrays.asList((Log[])mapper.readValue(mapper.writeValueAsString(data.get("logs")), Log[].class));
        this.logService.createInBatch(logs);
        List<Menu> menus = Arrays.asList((Menu[])mapper.readValue(mapper.writeValueAsString(data.get("menus")), Menu[].class));
        this.menuService.createInBatch(menus);
        List<Option> options = Arrays.asList((Option[])mapper.readValue(mapper.writeValueAsString(data.get("options")), Option[].class));
        this.optionService.createInBatch(options);
        this.eventPublisher.publishEvent((ApplicationEvent)new OptionUpdatedEvent((Object)this));
        List<Photo> photos = Arrays.asList((Photo[])mapper.readValue(mapper.writeValueAsString(data.get("photos")), Photo[].class));
        this.photoService.createInBatch(photos);
        List<Post> posts = Arrays.asList((Post[])mapper.readValue(mapper.writeValueAsString(data.get("posts")), Post[].class));
        this.postService.createInBatch(posts);
        List<Content> contents = Arrays.asList((Content[])mapper.readValue(mapper.writeValueAsString(data.get("contents")), Content[].class));
        this.contentService.createInBatch(contents);
        List<ContentPatchLog> contentPatchLogs = Arrays.asList((ContentPatchLog[])mapper.readValue(mapper.writeValueAsString(data.get("content_patch_logs")), ContentPatchLog[].class));
        this.contentPatchLogService.createInBatch(contentPatchLogs);
        List<PostCategory> postCategories = Arrays.asList((PostCategory[])mapper.readValue(mapper.writeValueAsString(data.get("post_categories")), PostCategory[].class));
        this.postCategoryService.createInBatch(postCategories);
        List<PostComment> postComments = Arrays.asList((PostComment[])mapper.readValue(mapper.writeValueAsString(data.get("post_comments")), PostComment[].class));
        this.postCommentService.createInBatch(postComments);
        List<PostMeta> postMetas = Arrays.asList((PostMeta[])mapper.readValue(mapper.writeValueAsString(data.get("post_metas")), PostMeta[].class));
        this.postMetaService.createInBatch(postMetas);
        List<PostTag> postTags = Arrays.asList((PostTag[])mapper.readValue(mapper.writeValueAsString(data.get("post_tags")), PostTag[].class));
        this.postTagService.createInBatch(postTags);
        List<Sheet> sheets = Arrays.asList((Sheet[])mapper.readValue(mapper.writeValueAsString(data.get("sheets")), Sheet[].class));
        this.sheetService.createInBatch(sheets);
        List<SheetComment> sheetComments = Arrays.asList((SheetComment[])mapper.readValue(mapper.writeValueAsString(data.get("sheet_comments")), SheetComment[].class));
        this.sheetCommentService.createInBatch(sheetComments);
        List<SheetMeta> sheetMetas = Arrays.asList((SheetMeta[])mapper.readValue(mapper.writeValueAsString(data.get("sheet_metas")), SheetMeta[].class));
        this.sheetMetaService.createInBatch(sheetMetas);
        List<ThemeSetting> themeSettings = Arrays.asList((ThemeSetting[])mapper.readValue(mapper.writeValueAsString(data.get("theme_settings")), ThemeSetting[].class));
        this.themeSettingService.createInBatch(themeSettings);
        this.eventPublisher.publishEvent((ApplicationEvent)new ThemeUpdatedEvent((Object)this));
        List<User> users = Arrays.asList((User[])mapper.readValue(mapper.writeValueAsString(data.get("user")), User[].class));
        if (users.size() > 0) {
            this.userService.create((Object)users.get(0));
        }
    }

    public BackupDTO exportMarkdowns(PostMarkdownParam postMarkdownParam) throws IOException {
        BackupDTO backupDTO;
        List postMarkdownList = this.postService.listPostMarkdowns();
        Assert.notEmpty((Collection)postMarkdownList, (String)"\u5f53\u524d\u65e0\u6587\u7ae0\u53ef\u4ee5\u5bfc\u51fa");
        String markdownFileTempPathName = this.haloProperties.getBackupMarkdownDir() + HaloUtils.simpleUUID().hashCode();
        for (PostMarkdownVO postMarkdownVo : postMarkdownList) {
            StringBuilder content = new StringBuilder();
            Boolean needFrontMatter = Optional.ofNullable(postMarkdownParam.getNeedFrontMatter()).orElse(false);
            if (needFrontMatter.booleanValue()) {
                content.append(postMarkdownVo.getFrontMatter()).append("\n");
            }
            content.append(postMarkdownVo.getOriginalContent());
            try {
                String markdownFileName = postMarkdownVo.getTitle() + "-" + postMarkdownVo.getSlug() + ".md";
                Path markdownFilePath = Paths.get(markdownFileTempPathName, markdownFileName);
                if (!Files.exists(markdownFilePath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(markdownFilePath.getParent(), new FileAttribute[0]);
                }
                Path markdownDataPath = Files.createFile(markdownFilePath, new FileAttribute[0]);
                FileUtils.writeStringToFile((File)markdownDataPath.toFile(), (String)content.toString());
            }
            catch (IOException e) {
                throw new ServiceException("\u5bfc\u51fa\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
        }
        String markdownZipFileName = "halo-backup-markdown-" + DateTimeUtils.format((LocalDateTime)LocalDateTime.now(), (DateTimeFormatter)DateTimeUtils.HORIZONTAL_LINE_DATETIME_FORMATTER) + HaloUtils.simpleUUID().hashCode() + ".zip";
        Path markdownZipFilePath = Paths.get(this.haloProperties.getBackupMarkdownDir(), markdownZipFileName);
        if (!Files.exists(markdownZipFilePath.getParent(), new LinkOption[0])) {
            Files.createDirectories(markdownZipFilePath.getParent(), new FileAttribute[0]);
        }
        Path markdownZipPath = Files.createFile(markdownZipFilePath, new FileAttribute[0]);
        ZipOutputStream markdownZipOut = new ZipOutputStream(Files.newOutputStream(markdownZipPath, new OpenOption[0]));
        try {
            Path markdownFileTempPath = Paths.get(markdownFileTempPathName, new String[0]);
            FileUtils.zip((Path)markdownFileTempPath, (ZipOutputStream)markdownZipOut);
            String uploadPathName = FileHandler.normalizeDirectory((String)this.haloProperties.getWorkDir()) + UPLOAD_SUB_DIR;
            Path uploadPath = Paths.get(uploadPathName, new String[0]);
            if (Files.exists(uploadPath, new LinkOption[0])) {
                FileUtils.zip((Path)uploadPath, (ZipOutputStream)markdownZipOut);
            }
            FileUtils.deleteFolder((Path)markdownFileTempPath);
            backupDTO = this.buildBackupDto(DATA_EXPORT_MARKDOWN_BASE_URI, markdownZipPath);
        }
        catch (Throwable throwable) {
            try {
                try {
                    markdownZipOut.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ServiceException("Failed to export markdowns", (Throwable)e);
            }
        }
        markdownZipOut.close();
        return backupDTO;
    }

    public List<BackupDTO> listMarkdowns() {
        List<BackupDTO> list;
        block9: {
            Path backupParentPath = Paths.get(this.haloProperties.getBackupMarkdownDir(), new String[0]);
            if (Files.notExists(backupParentPath, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> subPathStream = Files.list(backupParentPath);
            try {
                list = subPathStream.filter(backupPath -> StringUtils.startsWithIgnoreCase((CharSequence)backupPath.getFileName().toString(), (CharSequence)"halo-backup-markdown-")).map(backupPath -> this.buildBackupDto(DATA_EXPORT_MARKDOWN_BASE_URI, backupPath)).sorted(Comparator.comparingLong(BackupDTO::getUpdateTime).reversed()).collect(Collectors.toList());
                if (subPathStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (subPathStream != null) {
                        try {
                            subPathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ServiceException("Failed to fetch backups", (Throwable)e);
                }
            }
            subPathStream.close();
        }
        return list;
    }

    public void deleteMarkdown(String filename) {
        Assert.hasText((String)filename, (String)"File name must not be blank");
        Path backupRootPath = Paths.get(this.haloProperties.getBackupMarkdownDir(), new String[0]);
        Path backupPath = backupRootPath.resolve(filename);
        FileUtils.checkDirectoryTraversal((Path)backupRootPath, (Path)backupPath);
        try {
            Files.delete(backupPath);
        }
        catch (NoSuchFileException e) {
            throw new NotFoundException("The file " + filename + " was not found", (Throwable)e);
        }
        catch (IOException e) {
            throw new ServiceException("Failed to delete backup", (Throwable)e);
        }
    }

    private BackupDTO buildBackupDto(@NonNull String basePath, @NonNull Path backupPath) {
        Assert.notNull((Object)basePath, (String)"Base path must not be null");
        Assert.notNull((Object)backupPath, (String)"Backup path must not be null");
        String backupFileName = backupPath.getFileName().toString();
        BackupDTO backup = new BackupDTO();
        try {
            backup.setDownloadLink(this.buildDownloadUrl(basePath, backupFileName));
            backup.setFilename(backupFileName);
            backup.setUpdateTime(Long.valueOf(Files.getLastModifiedTime(backupPath, new LinkOption[0]).toMillis()));
            backup.setFileSize(Long.valueOf(Files.size(backupPath)));
        }
        catch (IOException e) {
            throw new ServiceException("Failed to access file " + backupPath, (Throwable)e);
        }
        return backup;
    }

    @NonNull
    private String buildDownloadUrl(@NonNull String basePath, @NonNull String filename) {
        Assert.notNull((Object)basePath, (String)"Base path must not be null");
        Assert.hasText((String)filename, (String)"File name must not be blank");
        String backupUri = basePath + "/" + filename;
        String oneTimeToken = this.oneTimeTokenService.create(backupUri);
        return HaloUtils.compositeHttpUrl((String[])new String[]{this.optionService.getBlogBaseUrl(), backupUri}) + "?ott=" + oneTimeToken;
    }
}

