/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.event.comment.CommentNewEvent;
import run.halo.app.event.comment.CommentReplyEvent;
import run.halo.app.exception.BadRequestException;
import run.halo.app.exception.NotFoundException;
import run.halo.app.model.entity.BaseComment;
import run.halo.app.model.entity.User;
import run.halo.app.model.enums.CommentStatus;
import run.halo.app.model.params.BaseCommentParam;
import run.halo.app.model.params.CommentQuery;
import run.halo.app.model.projection.CommentChildrenCountProjection;
import run.halo.app.model.projection.CommentCountProjection;
import run.halo.app.model.properties.BlogProperties;
import run.halo.app.model.properties.CommentProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.vo.BaseCommentVO;
import run.halo.app.model.vo.BaseCommentWithParentVO;
import run.halo.app.model.vo.CommentWithHasChildrenVO;
import run.halo.app.repository.base.BaseCommentRepository;
import run.halo.app.security.authentication.Authentication;
import run.halo.app.security.context.SecurityContextHolder;
import run.halo.app.service.OptionService;
import run.halo.app.service.UserService;
import run.halo.app.service.assembler.comment.BaseCommentAssembler;
import run.halo.app.service.base.AbstractCrudService;
import run.halo.app.service.base.BaseCommentService;
import run.halo.app.utils.HaloUtils;
import run.halo.app.utils.ServiceUtils;
import run.halo.app.utils.ServletUtils;
import run.halo.app.utils.ValidationUtils;

public abstract class BaseCommentServiceImpl<COMMENT extends BaseComment>
extends AbstractCrudService<COMMENT, Long>
implements BaseCommentService<COMMENT> {
    private static final Logger log = LoggerFactory.getLogger(BaseCommentServiceImpl.class);
    protected final OptionService optionService;
    protected final UserService userService;
    protected final ApplicationEventPublisher eventPublisher;
    private final BaseCommentRepository<COMMENT> baseCommentRepository;
    private final BaseCommentAssembler<COMMENT> commentAssembler;

    public BaseCommentServiceImpl(BaseCommentRepository<COMMENT> baseCommentRepository, OptionService optionService, UserService userService, ApplicationEventPublisher eventPublisher, BaseCommentAssembler<COMMENT> commentAssembler) {
        super(baseCommentRepository);
        this.baseCommentRepository = baseCommentRepository;
        this.optionService = optionService;
        this.userService = userService;
        this.eventPublisher = eventPublisher;
        this.commentAssembler = commentAssembler;
    }

    @NonNull
    public List<COMMENT> listBy(@NonNull Integer postId) {
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        return this.baseCommentRepository.findAllByPostId(postId);
    }

    @NonNull
    public Page<COMMENT> pageLatest(@NonNull int top) {
        return this.pageLatest(top, null);
    }

    @NonNull
    public Page<COMMENT> pageLatest(int top, CommentStatus status) {
        if (status == null) {
            return this.listAll(ServiceUtils.buildLatestPageable((int)top));
        }
        return this.baseCommentRepository.findAllByStatus(status, ServiceUtils.buildLatestPageable((int)top));
    }

    @NonNull
    public Page<COMMENT> pageBy(@NonNull CommentStatus status, @NonNull Pageable pageable) {
        Assert.notNull((Object)status, (String)"Comment status must not be null");
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        return this.baseCommentRepository.findAllByStatus(status, pageable);
    }

    @NonNull
    public Page<COMMENT> pageBy(@NonNull CommentQuery commentQuery, @NonNull Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        return this.baseCommentRepository.findAll(this.buildSpecByQuery(commentQuery), pageable);
    }

    @NonNull
    public Page<BaseCommentVO> pageVosAllBy(@NonNull Integer postId, @NonNull Pageable pageable) {
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        log.debug("Getting comment tree view of post: [{}], page info: [{}]", (Object)postId, (Object)pageable);
        List comments = this.baseCommentRepository.findAllByPostId(postId);
        return this.commentAssembler.pageVosBy(comments, pageable);
    }

    @NonNull
    public Page<BaseCommentVO> pageVosBy(@NonNull Integer postId, @NonNull Pageable pageable) {
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        log.debug("Getting comment tree view of post: [{}], page info: [{}]", (Object)postId, (Object)pageable);
        List comments = this.baseCommentRepository.findAllByPostIdAndStatus(postId, CommentStatus.PUBLISHED);
        return this.commentAssembler.pageVosBy(comments, pageable);
    }

    @NonNull
    public Page<BaseCommentWithParentVO> pageWithParentVoBy(@NonNull Integer postId, @NonNull Pageable pageable) {
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        log.debug("Getting comment list view of post: [{}], page info: [{}]", (Object)postId, (Object)pageable);
        Page commentPage = this.baseCommentRepository.findAllByPostIdAndStatus(postId, CommentStatus.PUBLISHED, pageable);
        List comments = commentPage.getContent();
        Set parentIds = ServiceUtils.fetchProperty((Collection)comments, BaseComment::getParentId);
        List parentComments = this.baseCommentRepository.findAllByIdIn((Collection)parentIds, pageable.getSort());
        Map parentCommentMap = ServiceUtils.convertToMap((Collection)parentComments, BaseComment::getId);
        HashMap parentCommentVoMap = new HashMap(parentCommentMap.size());
        return commentPage.map(comment -> {
            BaseComment parentComment;
            BaseCommentWithParentVO commentWithParentVo = (BaseCommentWithParentVO)new BaseCommentWithParentVO().convertFrom(comment);
            commentWithParentVo.setAvatar(this.commentAssembler.buildAvatarUrl(commentWithParentVo.getGravatarMd5()));
            BaseCommentWithParentVO parentCommentVo = (BaseCommentWithParentVO)parentCommentVoMap.get(comment.getParentId());
            if (parentCommentVo == null && (parentComment = (BaseComment)parentCommentMap.get(comment.getParentId())) != null) {
                parentCommentVo = (BaseCommentWithParentVO)new BaseCommentWithParentVO().convertFrom((Object)parentComment);
                parentCommentVo.setAvatar(this.commentAssembler.buildAvatarUrl(parentComment.getGravatarMd5()));
                parentCommentVoMap.put(parentComment.getId(), parentCommentVo);
            }
            commentWithParentVo.setParent(parentCommentVo == null ? null : parentCommentVo.clone());
            return commentWithParentVo;
        });
    }

    @NonNull
    public Map<Integer, Long> countByPostIds(Collection<Integer> postIds) {
        if (CollectionUtils.isEmpty(postIds)) {
            return Collections.emptyMap();
        }
        List commentCountProjections = this.baseCommentRepository.countByPostIds(postIds);
        return ServiceUtils.convertToMap((Collection)commentCountProjections, CommentCountProjection::getPostId, CommentCountProjection::getCount);
    }

    public Map<Integer, Long> countByStatusAndPostIds(@NonNull CommentStatus status, @NonNull Collection<Integer> postIds) {
        if (CollectionUtils.isEmpty(postIds)) {
            return Collections.emptyMap();
        }
        List commentCountProjections = this.baseCommentRepository.countByStatusAndPostIds(status, postIds);
        return ServiceUtils.convertToMap((Collection)commentCountProjections, CommentCountProjection::getPostId, CommentCountProjection::getCount);
    }

    public long countByPostId(@NonNull Integer postId) {
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        return this.baseCommentRepository.countByPostId(postId);
    }

    public long countByStatusAndPostId(@NonNull CommentStatus status, @NonNull Integer postId) {
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        return this.baseCommentRepository.countByStatusAndPostId(status, postId);
    }

    public long countByStatus(@NonNull CommentStatus status) {
        return this.baseCommentRepository.countByStatus(status);
    }

    @NonNull
    @Transactional(rollbackFor={Exception.class})
    public COMMENT create(@NonNull COMMENT comment) {
        Assert.notNull(comment, (String)"Domain must not be null");
        if (!ServiceUtils.isEmptyId((Number)comment.getPostId())) {
            this.validateTarget(comment.getPostId());
        }
        if (!ServiceUtils.isEmptyId((Number)comment.getParentId())) {
            this.mustExistById((Object)comment.getParentId());
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (comment.getIpAddress() == null) {
            comment.setIpAddress(ServletUtils.getRequestIp());
        }
        if (comment.getUserAgent() == null) {
            comment.setUserAgent(ServletUtils.getHeaderIgnoreCase((String)"User-Agent"));
        }
        if (comment.getGravatarMd5() == null) {
            comment.setGravatarMd5(DigestUtils.md5Hex((String)Optional.ofNullable(comment.getEmail()).orElse("")));
        }
        if (StringUtils.isNotEmpty((CharSequence)comment.getAuthorUrl())) {
            comment.setAuthorUrl(HaloUtils.normalizeUrl((String)comment.getAuthorUrl()));
        }
        if (authentication != null) {
            comment.setIsAdmin(Boolean.valueOf(true));
            comment.setStatus(CommentStatus.PUBLISHED);
        } else {
            Boolean needAudit = (Boolean)this.optionService.getByPropertyOrDefault((PropertyEnum)CommentProperties.NEW_NEED_CHECK, Boolean.class, (Object)true);
            comment.setStatus(needAudit != false ? CommentStatus.AUDITING : CommentStatus.PUBLISHED);
        }
        BaseComment createdComment = (BaseComment)super.create(comment);
        if (ServiceUtils.isEmptyId((Number)createdComment.getParentId())) {
            if (authentication == null) {
                this.eventPublisher.publishEvent((ApplicationEvent)new CommentNewEvent((Object)this, createdComment.getId()));
            }
        } else {
            this.eventPublisher.publishEvent((ApplicationEvent)new CommentReplyEvent((Object)this, createdComment.getId()));
        }
        return (COMMENT)createdComment;
    }

    @NonNull
    @Transactional(rollbackFor={Exception.class})
    public COMMENT createBy(@NonNull BaseCommentParam<COMMENT> commentParam) {
        Assert.notNull(commentParam, (String)"Comment param must not be null");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            User user = authentication.getDetail().getUser();
            commentParam.setAuthor(StringUtils.isBlank((CharSequence)user.getNickname()) ? user.getUsername() : user.getNickname());
            commentParam.setEmail(user.getEmail());
            commentParam.setAuthorUrl((String)this.optionService.getByPropertyOrDefault((PropertyEnum)BlogProperties.BLOG_URL, String.class, null));
        }
        ValidationUtils.validate(commentParam, (Class[])new Class[0]);
        if (authentication == null && this.userService.getByEmail(commentParam.getEmail()).isPresent()) {
            throw new BadRequestException("\u4e0d\u80fd\u4f7f\u7528\u535a\u4e3b\u7684\u90ae\u7bb1\uff0c\u5982\u679c\u60a8\u662f\u535a\u4e3b\uff0c\u8bf7\u767b\u5f55\u7ba1\u7406\u7aef\u8fdb\u884c\u56de\u590d\u3002");
        }
        return (COMMENT)this.create((BaseComment)commentParam.convertTo());
    }

    @NonNull
    @Transactional(rollbackFor={Exception.class})
    public COMMENT updateStatus(@NonNull Long commentId, @NonNull CommentStatus status) {
        Assert.notNull((Object)commentId, (String)"Comment id must not be null");
        Assert.notNull((Object)status, (String)"Comment status must not be null");
        BaseComment comment = (BaseComment)this.getById((Object)commentId);
        comment.setStatus(status);
        return (COMMENT)((BaseComment)this.update((Object)comment));
    }

    @NonNull
    @Transactional(rollbackFor={Exception.class})
    public List<COMMENT> updateStatusByIds(@NonNull List<Long> ids, @NonNull CommentStatus status) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return ids.stream().map(id -> this.updateStatus(id, status)).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Exception.class})
    public List<COMMENT> removeByPostId(@NonNull Integer postId) {
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        return this.baseCommentRepository.deleteByPostId(postId);
    }

    @NonNull
    @Transactional(rollbackFor={Exception.class})
    public COMMENT removeById(@NonNull Long id) {
        Assert.notNull((Object)id, (String)"Comment id must not be null");
        BaseComment comment = (BaseComment)this.baseCommentRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u8bc4\u8bba\u7684\u4fe1\u606f").setErrorData((Object)id));
        List children = this.listChildrenBy(comment.getPostId(), id, Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        if (children.size() > 0) {
            children.forEach(child -> super.removeById((Object)child.getId()));
        }
        return (COMMENT)((BaseComment)super.removeById((Object)id));
    }

    @NonNull
    @Transactional(rollbackFor={Exception.class})
    public List<COMMENT> removeByIds(@NonNull Collection<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return ids.stream().map(arg_0 -> this.removeById(arg_0)).collect(Collectors.toList());
    }

    @NonNull
    protected Specification<COMMENT> buildSpecByQuery(@NonNull CommentQuery commentQuery) {
        Assert.notNull((Object)commentQuery, (String)"Comment query must not be null");
        return (Specification & Serializable)(root, query, criteriaBuilder) -> {
            LinkedList<Predicate> predicates = new LinkedList<Predicate>();
            if (commentQuery.getStatus() != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("status"), (Object)commentQuery.getStatus()));
            }
            if (commentQuery.getKeyword() != null) {
                String likeCondition = String.format("%%%s%%", StringUtils.strip((String)commentQuery.getKeyword()));
                Predicate authorLike = criteriaBuilder.like((Expression)root.get("author"), likeCondition);
                Predicate contentLike = criteriaBuilder.like((Expression)root.get("content"), likeCondition);
                Predicate emailLike = criteriaBuilder.like((Expression)root.get("email"), likeCondition);
                predicates.add(criteriaBuilder.or(new Predicate[]{authorLike, contentLike, emailLike}));
            }
            return query.where(predicates.toArray(new Predicate[0])).getRestriction();
        };
    }

    @NonNull
    public Page<CommentWithHasChildrenVO> pageTopCommentsBy(@NonNull Integer targetId, @NonNull CommentStatus status, @NonNull Pageable pageable) {
        Assert.notNull((Object)targetId, (String)"Target id must not be null");
        Assert.notNull((Object)status, (String)"Comment status must not be null");
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        Page topCommentPage = this.baseCommentRepository.findAllByPostIdAndStatusAndParentId(targetId, status, Long.valueOf(0L), pageable);
        if (topCommentPage.isEmpty()) {
            return ServiceUtils.buildEmptyPageImpl((Page)topCommentPage);
        }
        Set topCommentIds = ServiceUtils.fetchProperty((Collection)topCommentPage.getContent(), BaseComment::getId);
        List directChildrenCount = this.baseCommentRepository.findDirectChildrenCount((Collection)topCommentIds, CommentStatus.PUBLISHED);
        Map commentChildrenCountMap = ServiceUtils.convertToMap((Collection)directChildrenCount, CommentChildrenCountProjection::getCommentId, CommentChildrenCountProjection::getDirectChildrenCount);
        return topCommentPage.map(topComment -> {
            CommentWithHasChildrenVO comment = (CommentWithHasChildrenVO)new CommentWithHasChildrenVO().convertFrom(topComment);
            comment.setHasChildren(commentChildrenCountMap.getOrDefault(topComment.getId(), 0L) > 0L);
            comment.setAvatar(this.commentAssembler.buildAvatarUrl(topComment.getGravatarMd5()));
            return comment;
        });
    }

    @NonNull
    public List<COMMENT> listChildrenBy(@NonNull Integer targetId, @NonNull Long commentParentId, @NonNull CommentStatus status, @NonNull Sort sort) {
        Assert.notNull((Object)targetId, (String)"Target id must not be null");
        Assert.notNull((Object)commentParentId, (String)"Comment parent id must not be null");
        Assert.notNull((Object)sort, (String)"Sort info must not be null");
        List directChildren = this.baseCommentRepository.findAllByPostIdAndStatusAndParentId(targetId, status, commentParentId);
        HashSet children = new HashSet();
        this.getChildrenRecursively(directChildren, status, children);
        ArrayList<BaseComment> childrenList = new ArrayList<BaseComment>(children);
        childrenList.sort(Comparator.comparing(BaseComment::getId));
        return childrenList;
    }

    @NonNull
    public List<COMMENT> listChildrenBy(@NonNull Integer targetId, @NonNull Long commentParentId, @NonNull Sort sort) {
        Assert.notNull((Object)targetId, (String)"Target id must not be null");
        Assert.notNull((Object)commentParentId, (String)"Comment parent id must not be null");
        Assert.notNull((Object)sort, (String)"Sort info must not be null");
        List directChildren = this.baseCommentRepository.findAllByPostIdAndParentId(targetId, commentParentId);
        HashSet children = new HashSet();
        this.getChildrenRecursively(directChildren, children);
        ArrayList<BaseComment> childrenList = new ArrayList<BaseComment>(children);
        childrenList.sort(Comparator.comparing(BaseComment::getId));
        return childrenList;
    }

    private void getChildrenRecursively(@Nullable List<COMMENT> topComments, @NonNull CommentStatus status, @NonNull Set<COMMENT> children) {
        Assert.notNull((Object)status, (String)"Comment status must not be null");
        Assert.notNull(children, (String)"Children comment set must not be null");
        if (CollectionUtils.isEmpty(topComments)) {
            return;
        }
        Set commentIds = ServiceUtils.fetchProperty(topComments, BaseComment::getId);
        List directChildren = this.baseCommentRepository.findAllByStatusAndParentIdIn(status, (Collection)commentIds);
        this.getChildrenRecursively(directChildren, status, children);
        children.addAll(topComments);
    }

    private void getChildrenRecursively(@Nullable List<COMMENT> topComments, @NonNull Set<COMMENT> children) {
        Assert.notNull(children, (String)"Children comment set must not be null");
        if (CollectionUtils.isEmpty(topComments)) {
            return;
        }
        Set commentIds = ServiceUtils.fetchProperty(topComments, BaseComment::getId);
        List directChildren = this.baseCommentRepository.findAllByParentIdIn((Collection)commentIds);
        this.getChildrenRecursively(directChildren, children);
        children.addAll(topComments);
    }
}

