/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.model.dto.BaseMetaDTO;
import run.halo.app.model.entity.BaseMeta;
import run.halo.app.model.params.BaseMetaParam;
import run.halo.app.repository.base.BaseMetaRepository;
import run.halo.app.service.base.AbstractCrudService;
import run.halo.app.service.base.BaseMetaService;
import run.halo.app.utils.ServiceUtils;

public abstract class BaseMetaServiceImpl<META extends BaseMeta>
extends AbstractCrudService<META, Long>
implements BaseMetaService<META> {
    private static final Logger log = LoggerFactory.getLogger(BaseMetaServiceImpl.class);
    private final BaseMetaRepository<META> baseMetaRepository;

    public BaseMetaServiceImpl(BaseMetaRepository<META> baseMetaRepository) {
        super(baseMetaRepository);
        this.baseMetaRepository = baseMetaRepository;
    }

    @Transactional
    public List<META> createOrUpdateByPostId(@NonNull Integer postId, Set<META> metas) {
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        this.removeByPostId(postId);
        if (CollectionUtils.isEmpty(metas)) {
            return Collections.emptyList();
        }
        metas.forEach(postMeta -> {
            if (StringUtils.isNotEmpty((CharSequence)postMeta.getValue()) && StringUtils.isNotEmpty((CharSequence)postMeta.getKey())) {
                postMeta.setPostId(postId);
                this.baseMetaRepository.save(postMeta);
            }
        });
        return new ArrayList<META>(metas);
    }

    public List<META> removeByPostId(@NonNull Integer postId) {
        Assert.notNull((Object)postId, (String)"Post id must not be null of removeByPostId");
        return this.baseMetaRepository.deleteByPostId(postId);
    }

    public Map<Integer, List<META>> listPostMetaAsMap(@NonNull Set<Integer> postIds) {
        Assert.notNull(postIds, (String)"Post ids must not be null");
        if (CollectionUtils.isEmpty(postIds)) {
            return Collections.emptyMap();
        }
        List metas = this.baseMetaRepository.findAllByPostIdIn(postIds);
        Map postMetaMap = ServiceUtils.convertToMap((Collection)metas, BaseMeta::getId);
        HashMap postMetaListMap = new HashMap();
        metas.forEach(meta -> postMetaListMap.computeIfAbsent(meta.getPostId(), postId -> new LinkedList()).add((BaseMeta)postMetaMap.get(meta.getId())));
        return postMetaListMap;
    }

    @NonNull
    public List<META> listBy(@NonNull Integer postId) {
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        return this.baseMetaRepository.findAllByPostId(postId);
    }

    @NonNull
    public META create(@NonNull META meta) {
        Assert.notNull(meta, (String)"Domain must not be null");
        if (!ServiceUtils.isEmptyId((Number)meta.getPostId())) {
            this.validateTarget(meta.getPostId());
        }
        return (META)((BaseMeta)super.create(meta));
    }

    @NonNull
    public META createBy(@NonNull BaseMetaParam<META> metaParam) {
        Assert.notNull(metaParam, (String)"Meta param must not be null");
        return (META)this.create((BaseMeta)metaParam.convertTo());
    }

    public Map<String, Object> convertToMap(List<META> metas) {
        return ServiceUtils.convertToMap(metas, BaseMeta::getKey, BaseMeta::getValue);
    }

    @NonNull
    public BaseMetaDTO convertTo(@NonNull META postMeta) {
        Assert.notNull(postMeta, (String)"Category must not be null");
        return (BaseMetaDTO)new BaseMetaDTO().convertFrom(postMeta);
    }

    @NonNull
    public List<BaseMetaDTO> convertTo(@NonNull List<META> postMetaList) {
        if (CollectionUtils.isEmpty(postMetaList)) {
            return Collections.emptyList();
        }
        return postMetaList.stream().map(arg_0 -> this.convertTo(arg_0)).collect(Collectors.toList());
    }
}

