/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.exception.AlreadyExistsException;
import run.halo.app.exception.BadRequestException;
import run.halo.app.exception.NotFoundException;
import run.halo.app.exception.ServiceException;
import run.halo.app.model.dto.post.BasePostSimpleDTO;
import run.halo.app.model.entity.BasePost;
import run.halo.app.model.entity.Content;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.model.properties.PostProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.repository.base.BasePostRepository;
import run.halo.app.service.ContentPatchLogService;
import run.halo.app.service.ContentService;
import run.halo.app.service.OptionService;
import run.halo.app.service.base.AbstractCrudService;
import run.halo.app.service.base.BasePostService;
import run.halo.app.utils.DateUtils;
import run.halo.app.utils.HaloUtils;
import run.halo.app.utils.ServiceUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class BasePostServiceImpl<POST extends BasePost>
extends AbstractCrudService<POST, Integer>
implements BasePostService<POST> {
    private static final Logger log = LoggerFactory.getLogger(BasePostServiceImpl.class);
    private final BasePostRepository<POST> basePostRepository;
    private final OptionService optionService;
    private final ContentService contentService;
    private final ContentPatchLogService contentPatchLogService;
    private static final Pattern summaryPattern = Pattern.compile("\t|\r|\n");
    private static final Pattern BLANK_PATTERN = Pattern.compile("\\s");

    public BasePostServiceImpl(BasePostRepository<POST> basePostRepository, OptionService optionService, ContentService contentService, ContentPatchLogService contentPatchLogService) {
        super(basePostRepository);
        this.basePostRepository = basePostRepository;
        this.optionService = optionService;
        this.contentService = contentService;
        this.contentPatchLogService = contentPatchLogService;
    }

    public long countVisit() {
        return Optional.ofNullable(this.basePostRepository.countVisit()).orElse(0L);
    }

    public long countLike() {
        return Optional.ofNullable(this.basePostRepository.countLike()).orElse(0L);
    }

    public long countByStatus(PostStatus status) {
        Assert.notNull((Object)status, (String)"Post status must not be null");
        return this.basePostRepository.countByStatus(status);
    }

    public POST getBySlug(String slug) {
        Assert.hasText((String)slug, (String)"Slug must not be blank");
        return (POST)((BasePost)this.basePostRepository.getBySlug(slug).orElseThrow(() -> new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u6587\u7ae0\u7684\u4fe1\u606f").setErrorData((Object)slug)));
    }

    public POST getBy(PostStatus status, String slug) {
        Assert.notNull((Object)status, (String)"Post status must not be null");
        Assert.hasText((String)slug, (String)"Post slug must not be blank");
        Optional postOptional = this.basePostRepository.getBySlugAndStatus(slug, status);
        return (POST)((BasePost)postOptional.orElseThrow(() -> new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u6587\u7ae0\u7684\u4fe1\u606f").setErrorData((Object)slug)));
    }

    public POST getBy(PostStatus status, Integer id) {
        Assert.notNull((Object)status, (String)"Post status must not be null");
        Assert.notNull((Object)id, (String)"Post id must not be null");
        Optional postOptional = this.basePostRepository.getByIdAndStatus(id, status);
        return (POST)((BasePost)postOptional.orElseThrow(() -> new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u6587\u7ae0\u7684\u4fe1\u606f").setErrorData((Object)id)));
    }

    public Content.PatchedContent getLatestContentById(Integer id) {
        return this.contentPatchLogService.getByPostId(id);
    }

    public List<POST> listAllBy(PostStatus status) {
        Assert.notNull((Object)status, (String)"Post status must not be null");
        return this.basePostRepository.findAllByStatus(status);
    }

    public List<POST> listPrevPosts(POST post, int size) {
        Assert.notNull(post, (String)"Post must not be null");
        String indexSort = this.optionService.getByPropertyOfNonNull((PropertyEnum)PostProperties.INDEX_SORT).toString();
        PageRequest pageRequest = PageRequest.of((int)0, (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{indexSort}));
        switch (indexSort) {
            case "createTime": {
                return this.basePostRepository.findAllByStatusAndCreateTimeAfter(PostStatus.PUBLISHED, post.getCreateTime(), (Pageable)pageRequest).getContent();
            }
            case "editTime": {
                return this.basePostRepository.findAllByStatusAndEditTimeAfter(PostStatus.PUBLISHED, post.getEditTime(), (Pageable)pageRequest).getContent();
            }
            case "visits": {
                return this.basePostRepository.findAllByStatusAndVisitsAfter(PostStatus.PUBLISHED, post.getVisits(), (Pageable)pageRequest).getContent();
            }
        }
        return Collections.emptyList();
    }

    public List<POST> listNextPosts(POST post, int size) {
        Assert.notNull(post, (String)"Post must not be null");
        String indexSort = this.optionService.getByPropertyOfNonNull((PropertyEnum)PostProperties.INDEX_SORT).toString();
        PageRequest pageRequest = PageRequest.of((int)0, (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{indexSort}));
        switch (indexSort) {
            case "createTime": {
                return this.basePostRepository.findAllByStatusAndCreateTimeBefore(PostStatus.PUBLISHED, post.getCreateTime(), (Pageable)pageRequest).getContent();
            }
            case "editTime": {
                return this.basePostRepository.findAllByStatusAndEditTimeBefore(PostStatus.PUBLISHED, post.getEditTime(), (Pageable)pageRequest).getContent();
            }
            case "visits": {
                return this.basePostRepository.findAllByStatusAndVisitsBefore(PostStatus.PUBLISHED, post.getVisits(), (Pageable)pageRequest).getContent();
            }
        }
        return Collections.emptyList();
    }

    public Optional<POST> getPrevPost(POST post) {
        List posts = this.listPrevPosts(post, 1);
        return CollectionUtils.isEmpty((Collection)posts) ? Optional.empty() : Optional.of((BasePost)posts.get(0));
    }

    public Optional<POST> getNextPost(POST post) {
        List posts = this.listNextPosts(post, 1);
        return CollectionUtils.isEmpty((Collection)posts) ? Optional.empty() : Optional.of((BasePost)posts.get(0));
    }

    public Page<POST> pageLatest(int top) {
        Assert.isTrue((top > 0 ? 1 : 0) != 0, (String)"Top number must not be less than 0");
        PageRequest latestPageable = PageRequest.of((int)0, (int)top, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        return this.listAll((Pageable)latestPageable);
    }

    public List<POST> listLatest(int top) {
        Assert.isTrue((top > 0 ? 1 : 0) != 0, (String)"Top number must not be less than 0");
        PageRequest latestPageable = PageRequest.of((int)0, (int)top, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        return this.basePostRepository.findAllByStatus(PostStatus.PUBLISHED, (Pageable)latestPageable).getContent();
    }

    public Page<POST> pageBy(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        return this.listAll(pageable);
    }

    public Page<POST> pageBy(PostStatus status, Pageable pageable) {
        Assert.notNull((Object)status, (String)"Post status must not be null");
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        return this.basePostRepository.findAllByStatus(status, pageable);
    }

    @Transactional
    public void increaseVisit(long visits, Integer postId) {
        boolean finishedIncrease;
        Assert.isTrue((visits > 0L ? 1 : 0) != 0, (String)"Visits to increase must not be less than 1");
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        if (this.basePostRepository.getByIdAndStatus(postId, PostStatus.DRAFT).isPresent()) {
            finishedIncrease = true;
            log.info("Post with id: [{}] is a draft and visits will not be updated", (Object)postId);
        } else {
            boolean bl = finishedIncrease = this.basePostRepository.updateVisit(visits, postId) == 1;
        }
        if (!finishedIncrease) {
            log.error("Post with id: [{}] may not be found", (Object)postId);
            throw new BadRequestException("Failed to increase visits " + visits + " for post with id " + postId);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void increaseVisit(Integer postId) {
        this.increaseVisit(1L, postId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void increaseLike(long likes, Integer postId) {
        Assert.isTrue((likes > 0L ? 1 : 0) != 0, (String)"Likes to increase must not be less than 1");
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        long affectedRows = this.basePostRepository.updateLikes(likes, postId);
        if (affectedRows != 1L) {
            log.error("Post with id: [{}] may not be found", (Object)postId);
            throw new BadRequestException("Failed to increase likes " + likes + " for post with id " + postId);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void increaseLike(Integer postId) {
        this.increaseLike(1L, postId);
    }

    @Transactional(rollbackFor={Exception.class})
    public POST createOrUpdateBy(POST post) {
        BasePost savedPost;
        Assert.notNull(post, (String)"Post must not be null");
        Content.PatchedContent postContent = post.getContent();
        post.setWordCount(Long.valueOf(BasePostServiceImpl.htmlFormatWordCount((String)postContent.getContent())));
        if (ServiceUtils.isEmptyId((Number)post.getId())) {
            savedPost = this.create(post);
            this.contentService.createOrUpdateDraftBy(post.getId(), postContent.getContent(), postContent.getOriginalContent());
        } else {
            post.setEditTime(DateUtils.now());
            this.contentService.createOrUpdateDraftBy(post.getId(), postContent.getContent(), postContent.getOriginalContent());
            savedPost = this.update(post);
        }
        if (PostStatus.PUBLISHED.equals((Object)post.getStatus()) || PostStatus.INTIMATE.equals((Object)post.getStatus())) {
            this.contentService.publishContent(post.getId());
        }
        return (POST)savedPost;
    }

    @Transactional(rollbackFor={Exception.class})
    public POST updateDraftContent(String content, String originalContent, Integer postId) {
        Assert.isTrue((!ServiceUtils.isEmptyId((Number)postId) ? 1 : 0) != 0, (String)"Post id must not be empty");
        if (originalContent == null) {
            originalContent = "";
        }
        this.contentService.createOrUpdateDraftBy(postId, content, originalContent);
        BasePost post = (BasePost)this.getById((Object)postId);
        post.setContent(this.getLatestContentById(postId));
        return (POST)post;
    }

    @Transactional(rollbackFor={Exception.class})
    public POST updateStatus(PostStatus status, Integer postId) {
        Assert.notNull((Object)status, (String)"Post status must not be null");
        Assert.isTrue((!ServiceUtils.isEmptyId((Number)postId) ? 1 : 0) != 0, (String)"Post id must not be empty");
        BasePost post = (BasePost)this.getById((Object)postId);
        if (!status.equals((Object)post.getStatus())) {
            int updatedRows = this.basePostRepository.updateStatus(status, postId);
            if (updatedRows != 1) {
                throw new ServiceException("Failed to update post status of post with id " + postId);
            }
            post.setStatus(status);
        }
        if (PostStatus.PUBLISHED.equals((Object)status)) {
            Content postContent = this.contentService.publishContent(postId);
            post.setContent(Content.PatchedContent.of((Content)postContent));
        }
        return (POST)post;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<POST> updateStatusByIds(List<Integer> ids, PostStatus status) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return ids.stream().map(id -> this.updateStatus(status, id)).collect(Collectors.toList());
    }

    public String generateDescription(@Nullable String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        String text = HaloUtils.cleanHtmlTag((String)content);
        Matcher matcher = summaryPattern.matcher(text);
        text = matcher.replaceAll("");
        Integer summaryLength = (Integer)this.optionService.getByPropertyOrDefault((PropertyEnum)PostProperties.SUMMARY_LENGTH, Integer.class, (Object)150);
        return StringUtils.substring((String)text, (int)0, (int)summaryLength);
    }

    @Transactional(rollbackFor={Exception.class})
    public POST create(POST post) {
        this.slugMustNotExist(post);
        return (POST)((BasePost)super.create(post));
    }

    @Transactional(rollbackFor={Exception.class})
    public POST update(POST post) {
        this.slugMustNotExist(post);
        return (POST)((BasePost)super.update(post));
    }

    public Content getContentById(Integer postId) {
        Assert.notNull((Object)postId, (String)"The postId must not be null.");
        return (Content)this.contentService.getById((Object)postId);
    }

    protected void slugMustNotExist(@NonNull POST post) {
        Assert.notNull(post, (String)"Post must not be null");
        boolean exist = ServiceUtils.isEmptyId((Number)post.getId()) ? this.basePostRepository.existsBySlug(post.getSlug()) : this.basePostRepository.existsByIdNotAndSlug(post.getId(), post.getSlug());
        if (exist) {
            throw new AlreadyExistsException("\u6587\u7ae0\u522b\u540d " + post.getSlug() + " \u5df2\u5b58\u5728");
        }
    }

    @NonNull
    protected String generateSummary(@Nullable String htmlContent) {
        if (StringUtils.isBlank((CharSequence)htmlContent)) {
            return "";
        }
        String text = HaloUtils.cleanHtmlTag((String)htmlContent);
        Matcher matcher = summaryPattern.matcher(text);
        text = matcher.replaceAll("");
        Integer summaryLength = (Integer)this.optionService.getByPropertyOrDefault((PropertyEnum)PostProperties.SUMMARY_LENGTH, Integer.class, (Object)150);
        return StringUtils.substring((String)text, (int)0, (int)summaryLength);
    }

    protected <T extends BasePostSimpleDTO> void generateAndSetSummaryIfAbsent(POST post, T postVo) {
        Assert.notNull(post, (String)"The post must not be null.");
        if (StringUtils.isNotBlank((CharSequence)postVo.getSummary())) {
            return;
        }
        Content.PatchedContent patchedContent = post.getContentOfNullable();
        if (patchedContent == null) {
            Content postContent = this.getContentById(post.getId());
            postVo.setSummary(this.generateSummary(postContent.getContent()));
        } else {
            postVo.setSummary(this.generateSummary(patchedContent.getContent()));
        }
    }

    public static long htmlFormatWordCount(String htmlContent) {
        if (htmlContent == null) {
            return 0L;
        }
        String cleanContent = HaloUtils.cleanHtmlTag((String)htmlContent);
        Matcher matcher = BLANK_PATTERN.matcher(cleanContent);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return cleanContent.length() - count;
    }
}

