/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.event.category.CategoryUpdatedEvent;
import run.halo.app.exception.AlreadyExistsException;
import run.halo.app.exception.NotFoundException;
import run.halo.app.model.dto.CategoryDTO;
import run.halo.app.model.entity.Category;
import run.halo.app.model.entity.PostCategory;
import run.halo.app.model.vo.CategoryVO;
import run.halo.app.repository.CategoryRepository;
import run.halo.app.repository.base.BaseRepository;
import run.halo.app.service.CategoryService;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostCategoryService;
import run.halo.app.service.base.AbstractCrudService;
import run.halo.app.utils.BeanUtils;
import run.halo.app.utils.HaloUtils;
import run.halo.app.utils.ServiceUtils;

@Service
public class CategoryServiceImpl
extends AbstractCrudService<Category, Integer>
implements CategoryService {
    private static final Logger log = LoggerFactory.getLogger(CategoryServiceImpl.class);
    private final CategoryRepository categoryRepository;
    private final PostCategoryService postCategoryService;
    private final OptionService optionService;
    private final ApplicationContext applicationContext;

    public CategoryServiceImpl(CategoryRepository categoryRepository, PostCategoryService postCategoryService, OptionService optionService, ApplicationContext applicationContext) {
        super((BaseRepository)categoryRepository);
        this.categoryRepository = categoryRepository;
        this.postCategoryService = postCategoryService;
        this.optionService = optionService;
        this.applicationContext = applicationContext;
    }

    @Transactional
    public Category create(Category category) {
        Assert.notNull((Object)category, (String)"Category to create must not be null");
        long count = this.categoryRepository.countByName(category.getName());
        if (count > 0L) {
            log.error("Category has exist already: [{}]", (Object)category);
            throw new AlreadyExistsException("\u8be5\u5206\u7c7b\u5df2\u5b58\u5728");
        }
        if (!ServiceUtils.isEmptyId((Number)category.getParentId()) && (count = this.categoryRepository.countById(category.getParentId())) == 0L) {
            log.error("Parent category with id: [{}] was not found, category: [{}]", (Object)category.getParentId(), (Object)category);
            throw new NotFoundException("Parent category with id = " + category.getParentId() + " was not found");
        }
        if (StringUtils.isNotBlank((CharSequence)category.getPassword())) {
            category.setPassword(category.getPassword().trim());
        }
        return (Category)super.create((Object)category);
    }

    public Category update(Category category) {
        Category persisted = (Category)this.getById((Object)category.getId());
        Category beforeUpdated = new Category();
        BeanUtils.updateProperties((Object)persisted, (Object)beforeUpdated);
        boolean beforeIsPrivate = this.isPrivate(category.getId());
        Category updated = (Category)super.update((Object)category);
        Set postIds = this.listPostIdsByCategoryIdRecursively(category.getId());
        this.applicationContext.publishEvent((ApplicationEvent)new CategoryUpdatedEvent((Object)this, category, beforeUpdated, beforeIsPrivate, postIds));
        return updated;
    }

    public List<CategoryVO> listAsTree(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort info must not be null");
        List categories = this.listAll(sort);
        if (CollectionUtils.isEmpty((Collection)categories)) {
            return Collections.emptyList();
        }
        this.desensitizePassword(categories);
        return this.listToTree(categories);
    }

    private void desensitizePassword(List<Category> categories) {
        Assert.notNull(categories, (String)"The categories must not be null.");
        categories.forEach(category -> category.setPassword(null));
    }

    @NonNull
    public String buildCategoryFullPath(@NonNull String slug) {
        Assert.notNull((Object)slug, (String)"The slug must not be null.");
        StringBuilder fullPath = new StringBuilder();
        if (this.optionService.isEnabledAbsolutePath().booleanValue()) {
            fullPath.append(this.optionService.getBlogBaseUrl());
        }
        fullPath.append("/").append(this.optionService.getCategoriesPrefix()).append("/").append(slug).append(this.optionService.getPathSuffix());
        return fullPath.toString();
    }

    public Category getBySlug(String slug) {
        return this.categoryRepository.getBySlug(slug).orElse(null);
    }

    @NonNull
    private CategoryVO convertToCategoryVo(Category category) {
        Assert.notNull((Object)category, (String)"The category must not be null.");
        CategoryVO categoryVo = (CategoryVO)new CategoryVO().convertFrom((Object)category);
        categoryVo.setFullPath(this.buildCategoryFullPath(categoryVo.getSlug()));
        return categoryVo;
    }

    public Category getBySlugOfNonNull(String slug) {
        return (Category)this.categoryRepository.getBySlug(slug).orElseThrow(() -> new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u5206\u7c7b\u7684\u4fe1\u606f").setErrorData((Object)slug));
    }

    public Category getByName(String name) {
        return this.categoryRepository.getByName(name).orElse(null);
    }

    @Transactional(rollbackFor={Exception.class})
    public void removeCategoryAndPostCategoryBy(Integer categoryId) {
        boolean beforeIsPrivate = this.isPrivate(categoryId);
        Set postIds = this.listPostIdsByCategoryIdRecursively(categoryId);
        List categories = this.listByParentId(categoryId);
        if (null != categories && categories.size() > 0) {
            categories.forEach(category -> {
                category.setParentId(Integer.valueOf(0));
                this.update(category);
            });
        }
        Category category2 = (Category)this.removeById((Object)categoryId);
        this.postCategoryService.removeByCategoryId(categoryId);
        this.applicationContext.publishEvent((ApplicationEvent)new CategoryUpdatedEvent((Object)this, null, category2, beforeIsPrivate, postIds));
    }

    public List<Category> listByParentId(@NonNull Integer id) {
        Assert.notNull((Object)id, (String)"Parent id must not be null");
        return this.categoryRepository.findByParentId(id);
    }

    public List<Category> listAllByParentId(@NonNull Integer id) {
        Assert.notNull((Object)id, (String)"Parent id must not be null");
        List categories = super.listAll(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"name")}));
        List categoryTree = this.listToTree(categories);
        return this.findCategoryTreeNodeById(categoryTree, id).map(arg_0 -> this.walkCategoryTree(arg_0)).orElse(Collections.emptyList());
    }

    @NonNull
    private List<Category> walkCategoryTree(CategoryVO root) {
        Assert.notNull((Object)root, (String)"The category 'root' must not be null");
        LinkedList<Category> categories = new LinkedList<Category>();
        ArrayDeque<CategoryVO> queue = new ArrayDeque<CategoryVO>();
        queue.add(root);
        while (!queue.isEmpty()) {
            CategoryVO categoryNode = (CategoryVO)queue.poll();
            Category category = new Category();
            BeanUtils.updateProperties((Object)categoryNode, (Object)category);
            categories.add(category);
            if (!HaloUtils.isNotEmpty((Collection)categoryNode.getChildren())) continue;
            queue.addAll(categoryNode.getChildren());
        }
        return categories;
    }

    private Optional<CategoryVO> findCategoryTreeNodeById(List<CategoryVO> categoryVos, Integer categoryId) {
        Assert.notNull((Object)categoryId, (String)"categoryId id must not be null");
        ArrayDeque<CategoryVO> queue = new ArrayDeque<CategoryVO>(categoryVos);
        while (!queue.isEmpty()) {
            CategoryVO category = (CategoryVO)queue.poll();
            if (Objects.equals(category.getId(), categoryId)) {
                return Optional.of(category);
            }
            if (!HaloUtils.isNotEmpty((Collection)category.getChildren())) continue;
            queue.addAll(category.getChildren());
        }
        return Optional.empty();
    }

    public CategoryDTO convertTo(Category category) {
        Assert.notNull((Object)category, (String)"Category must not be null");
        CategoryDTO categoryDto = (CategoryDTO)new CategoryDTO().convertFrom((Object)category);
        categoryDto.setFullPath(this.buildCategoryFullPath(category.getSlug()));
        return categoryDto;
    }

    public List<CategoryDTO> convertTo(List<Category> categories) {
        if (CollectionUtils.isEmpty(categories)) {
            return Collections.emptyList();
        }
        return categories.stream().map(arg_0 -> this.convertTo(arg_0)).collect(Collectors.toList());
    }

    public boolean isPrivate(Integer categoryId) {
        return this.lookupFirstEncryptedBy(categoryId).isPresent();
    }

    public List<CategoryVO> listToTree(List<Category> categories) {
        Assert.notNull(categories, (String)"The categories must not be null.");
        List<CategoryVO> categoryVoList = categories.stream().map(arg_0 -> this.convertToCategoryVo(arg_0)).collect(Collectors.toList());
        Map<Integer, List<CategoryVO>> parentIdMap = categoryVoList.stream().collect(Collectors.groupingBy(CategoryDTO::getParentId));
        categoryVoList.forEach(category -> {
            List children = (List)parentIdMap.get(category.getId());
            if (CollectionUtils.isEmpty((Collection)children)) {
                category.setChildren(Collections.emptyList());
            } else {
                category.setChildren(children);
            }
        });
        return categoryVoList.stream().filter(category -> category.getParentId() == null || category.getParentId() == 0).collect(Collectors.toList());
    }

    public Optional<Category> lookupFirstEncryptedBy(Integer categoryId) {
        List categories = this.listAll();
        Map categoryMap = ServiceUtils.convertToMap((Collection)categories, Category::getId);
        return Optional.ofNullable(this.findFirstEncryptedCategoryBy(categoryMap, categoryId));
    }

    private Category findFirstEncryptedCategoryBy(Map<Integer, Category> idToCategoryMap, Integer categoryId) {
        Category category = idToCategoryMap.get(categoryId);
        if (categoryId == 0 || category == null) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)category.getPassword())) {
            return category;
        }
        return this.findFirstEncryptedCategoryBy(idToCategoryMap, category.getParentId());
    }

    @Transactional(rollbackFor={Exception.class})
    public List<Category> updateInBatch(Collection<Category> categories) {
        if (CollectionUtils.isEmpty(categories)) {
            return Collections.emptyList();
        }
        Set categoryIds = ServiceUtils.fetchProperty(categories, Category::getId);
        Map idCategoryParamMap = ServiceUtils.convertToMap(categories, Category::getId);
        return this.categoryRepository.findAllById((Iterable)categoryIds).stream().map(categoryToUpdate -> {
            Category categoryBefore = (Category)BeanUtils.transformFrom((Object)categoryToUpdate, Category.class);
            boolean beforeIsPrivate = this.isPrivate(categoryToUpdate.getId());
            Category categoryParam = (Category)idCategoryParamMap.get(categoryToUpdate.getId());
            BeanUtils.updateProperties((Object)categoryParam, (Object)categoryToUpdate);
            Category categoryUpdated = this.update(categoryToUpdate);
            Set postIds = this.listPostIdsByCategoryIdRecursively(categoryUpdated.getId());
            this.applicationContext.publishEvent((ApplicationEvent)new CategoryUpdatedEvent((Object)this, categoryUpdated, categoryBefore, beforeIsPrivate, postIds));
            return categoryUpdated;
        }).collect(Collectors.toList());
    }

    @NonNull
    public Set<Integer> listPostIdsByCategoryIdRecursively(@NonNull Integer categoryId) {
        Set categoryIds = ServiceUtils.fetchProperty((Collection)this.listAllByParentId(categoryId), Category::getId);
        if (CollectionUtils.isEmpty((Collection)categoryIds)) {
            return Collections.emptySet();
        }
        List postCategories = this.postCategoryService.listByCategoryIdList(new ArrayList(categoryIds));
        return ServiceUtils.fetchProperty((Collection)postCategories, PostCategory::getPostId);
    }
}

