/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import com.qiniu.storage.Region;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import run.halo.app.model.dto.OptionSimpleDTO;
import run.halo.app.model.params.OptionQuery;
import run.halo.app.service.ClientOptionService;
import run.halo.app.service.OptionService;
import run.halo.app.service.impl.OptionFilter;

@Service
public class ClientOptionServiceImpl
implements ClientOptionService {
    private final OptionService optionService;
    private final OptionFilter optionFilter;

    ClientOptionServiceImpl(OptionService optionService) {
        this.optionService = optionService;
        this.optionFilter = new OptionFilter(optionService);
    }

    @Transactional
    public Map<String, Object> listOptions() {
        Map options = this.optionService.listOptions();
        return this.optionFilter.filter(options.keySet()).parallelStream().collect(Collectors.toMap(optionName -> optionName, options::get));
    }

    public Page<OptionSimpleDTO> pageDtosBy(Pageable pageable, OptionQuery optionQuery) {
        return this.optionService.pageDtosBy(pageable, optionQuery);
    }

    public int getPostPageSize() {
        return this.optionService.getPostPageSize();
    }

    public int getArchivesPageSize() {
        return this.optionService.getArchivesPageSize();
    }

    public int getCommentPageSize() {
        return this.optionService.getCommentPageSize();
    }

    public int getRssPageSize() {
        return this.optionService.getRssPageSize();
    }

    public Region getQiniuRegion() {
        return this.optionService.getQiniuRegion();
    }

    public Locale getLocale() {
        return this.optionService.getLocale();
    }

    public String getBlogBaseUrl() {
        return this.optionService.getBlogBaseUrl();
    }

    public long getBirthday() {
        return this.optionService.getBirthday();
    }

    public void flush() {
        this.optionService.flush();
    }
}

