/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import run.halo.app.model.entity.CommentBlackList;
import run.halo.app.model.enums.CommentViolationTypeEnum;
import run.halo.app.model.properties.CommentProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.repository.CommentBlackListRepository;
import run.halo.app.repository.PostCommentRepository;
import run.halo.app.repository.base.BaseRepository;
import run.halo.app.service.CommentBlackListService;
import run.halo.app.service.OptionService;
import run.halo.app.service.base.AbstractCrudService;
import run.halo.app.utils.DateTimeUtils;

@Service
public class CommentBlackListServiceImpl
extends AbstractCrudService<CommentBlackList, Long>
implements CommentBlackListService {
    private static final Logger log = LoggerFactory.getLogger(CommentBlackListServiceImpl.class);
    private final CommentBlackListRepository commentBlackListRepository;
    private final PostCommentRepository postCommentRepository;
    private final OptionService optionService;

    public CommentBlackListServiceImpl(CommentBlackListRepository commentBlackListRepository, PostCommentRepository postCommentRepository, OptionService optionService) {
        super((BaseRepository)commentBlackListRepository);
        this.commentBlackListRepository = commentBlackListRepository;
        this.postCommentRepository = postCommentRepository;
        this.optionService = optionService;
    }

    public CommentViolationTypeEnum commentsBanStatus(String ipAddress) {
        boolean isPresent;
        Optional blackList = this.commentBlackListRepository.findByIpAddress(ipAddress);
        LocalDateTime now = LocalDateTime.now();
        Date endTime = new Date(DateTimeUtils.toEpochMilli((LocalDateTime)now));
        Integer banTime = (Integer)this.optionService.getByPropertyOrDefault((PropertyEnum)CommentProperties.COMMENT_BAN_TIME, Integer.class, (Object)10);
        Date startTime = new Date(DateTimeUtils.toEpochMilli((LocalDateTime)now.minusMinutes(banTime.intValue())));
        Integer range = (Integer)this.optionService.getByPropertyOrDefault((PropertyEnum)CommentProperties.COMMENT_RANGE, Integer.class, (Object)30);
        boolean bl = isPresent = this.postCommentRepository.countByIpAndTime(ipAddress, startTime, endTime) >= range;
        if (isPresent && blackList.isPresent()) {
            this.update(now, (CommentBlackList)blackList.get(), banTime);
            return CommentViolationTypeEnum.FREQUENTLY;
        }
        if (isPresent) {
            CommentBlackList commentBlackList = CommentBlackList.builder().banTime(this.getBanTime(now, banTime)).ipAddress(ipAddress).build();
            super.create((Object)commentBlackList);
            return CommentViolationTypeEnum.FREQUENTLY;
        }
        return CommentViolationTypeEnum.NORMAL;
    }

    private void update(LocalDateTime localDateTime, CommentBlackList blackList, Integer banTime) {
        blackList.setBanTime(this.getBanTime(localDateTime, banTime));
        int updateResult = this.commentBlackListRepository.updateByIpAddress(blackList);
        Optional.of(updateResult).filter(result -> result <= 0).ifPresent(result -> log.error("\u66f4\u65b0\u8bc4\u8bba\u5c01\u7981\u65f6\u95f4\u5931\u8d25"));
    }

    private Date getBanTime(LocalDateTime localDateTime, Integer banTime) {
        return new Date(DateTimeUtils.toEpochMilli((LocalDateTime)localDateTime.plusMinutes(banTime.intValue())));
    }
}

