/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.data.domain.Example;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import run.halo.app.exception.NotFoundException;
import run.halo.app.model.entity.Content;
import run.halo.app.model.entity.ContentPatchLog;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.repository.ContentPatchLogRepository;
import run.halo.app.repository.ContentRepository;
import run.halo.app.repository.base.BaseRepository;
import run.halo.app.service.ContentPatchLogService;
import run.halo.app.service.base.AbstractCrudService;
import run.halo.app.utils.PatchUtils;

@Service
public class ContentPatchLogServiceImpl
extends AbstractCrudService<ContentPatchLog, Integer>
implements ContentPatchLogService {
    public static final int BASE_VERSION = 1;
    private final ContentPatchLogRepository contentPatchLogRepository;
    private final ContentRepository contentRepository;

    public ContentPatchLogServiceImpl(ContentPatchLogRepository contentPatchLogRepository, ContentRepository contentRepository) {
        super((BaseRepository)contentPatchLogRepository);
        this.contentPatchLogRepository = contentPatchLogRepository;
        this.contentRepository = contentRepository;
    }

    protected Optional<Content> getContentByPostId(Integer postId) {
        return this.contentRepository.findById((Object)postId);
    }

    @Transactional(rollbackFor={Exception.class})
    public ContentPatchLog createOrUpdate(Integer postId, String content, String originalContent) {
        Integer version = this.getVersionByPostId(postId);
        if (this.existDraftBy(postId)) {
            return this.updateDraftBy(postId, content, originalContent);
        }
        return this.createDraftContent(postId, version, content, originalContent);
    }

    private Integer getVersionByPostId(Integer postId) {
        ContentPatchLog latestPatchLog = this.contentPatchLogRepository.findFirstByPostIdOrderByVersionDesc(postId);
        Integer version = latestPatchLog == null ? Integer.valueOf(1) : (this.shouldUpgradeVersion(latestPatchLog) ? Integer.valueOf(latestPatchLog.getVersion() + 1) : latestPatchLog.getVersion());
        return version;
    }

    private ContentPatchLog createDraftContent(Integer postId, Integer version, String formatContent, String originalContent) {
        ContentPatchLog contentPatchLog = this.buildPatchLog(postId, version, formatContent, originalContent);
        Integer sourceId = this.getContentByPostId(postId).map(Content::getPatchLogId).orElse(0);
        contentPatchLog.setSourceId(sourceId);
        this.contentPatchLogRepository.save((Object)contentPatchLog);
        return contentPatchLog;
    }

    private ContentPatchLog buildPatchLog(Integer postId, Integer version, String formatContent, String originalContent) {
        ContentPatchLog contentPatchLog = new ContentPatchLog();
        if (Objects.equals(version, 1)) {
            contentPatchLog.setContentDiff(formatContent);
            contentPatchLog.setOriginalContentDiff(originalContent);
        } else {
            Content.ContentDiff contentDiff = this.generateDiff(postId, formatContent, originalContent);
            contentPatchLog.setContentDiff(contentDiff.getDiff());
            contentPatchLog.setOriginalContentDiff(contentDiff.getOriginalDiff());
        }
        contentPatchLog.setPostId(postId);
        contentPatchLog.setStatus(PostStatus.DRAFT);
        ContentPatchLog latestPatchLog = this.contentPatchLogRepository.findFirstByPostIdOrderByVersionDesc(postId);
        if (this.shouldUpgradeVersion(latestPatchLog)) {
            contentPatchLog.setVersion(Integer.valueOf(latestPatchLog.getVersion() + 1));
        } else {
            contentPatchLog.setVersion(Integer.valueOf(1));
        }
        return contentPatchLog;
    }

    private boolean shouldUpgradeVersion(ContentPatchLog latestPatchLog) {
        if (latestPatchLog == null) {
            return false;
        }
        return PostStatus.PUBLISHED.equals((Object)latestPatchLog.getStatus()) || PostStatus.INTIMATE.equals((Object)latestPatchLog.getStatus());
    }

    private boolean existDraftBy(Integer postId) {
        ContentPatchLog contentPatchLog = new ContentPatchLog();
        contentPatchLog.setPostId(postId);
        contentPatchLog.setStatus(PostStatus.DRAFT);
        Example example = Example.of((Object)contentPatchLog);
        boolean exists = this.contentPatchLogRepository.exists(example);
        if (exists) {
            return true;
        }
        contentPatchLog.setStatus(PostStatus.RECYCLE);
        return this.contentPatchLogRepository.exists(Example.of((Object)contentPatchLog));
    }

    private ContentPatchLog updateDraftBy(Integer postId, String formatContent, String originalContent) {
        ContentPatchLog draftPatchLog = this.findLatestDraftBy(postId);
        if (draftPatchLog == null) {
            throw new NotFoundException("The latest draft version must not be null to update.");
        }
        if (Objects.equals(draftPatchLog.getVersion(), 1)) {
            draftPatchLog.setContentDiff(formatContent);
            draftPatchLog.setOriginalContentDiff(originalContent);
            this.contentPatchLogRepository.save((Object)draftPatchLog);
            return draftPatchLog;
        }
        Content.ContentDiff contentDiff = this.generateDiff(postId, formatContent, originalContent);
        draftPatchLog.setContentDiff(contentDiff.getDiff());
        draftPatchLog.setOriginalContentDiff(contentDiff.getOriginalDiff());
        this.contentPatchLogRepository.save((Object)draftPatchLog);
        return draftPatchLog;
    }

    private ContentPatchLog findLatestDraftBy(Integer postId) {
        ContentPatchLog draftPatchLog = this.contentPatchLogRepository.findFirstByPostIdAndStatusOrderByVersionDesc(postId, PostStatus.DRAFT);
        if (draftPatchLog == null) {
            draftPatchLog = this.contentPatchLogRepository.findFirstByPostIdAndStatusOrderByVersionDesc(postId, PostStatus.RECYCLE);
        }
        return draftPatchLog;
    }

    public Content.PatchedContent applyPatch(ContentPatchLog patchLog) {
        Assert.notNull((Object)patchLog, (String)"The contentRecord must not be null.");
        Assert.notNull((Object)patchLog.getVersion(), (String)"The contentRecord.version must not be null.");
        Assert.notNull((Object)patchLog.getPostId(), (String)"The contentRecord.postId must not be null.");
        Content.PatchedContent patchedContent = new Content.PatchedContent();
        if (patchLog.getVersion() == 1) {
            patchedContent.setContent(patchLog.getContentDiff());
            patchedContent.setOriginalContent(patchLog.getOriginalContentDiff());
            return patchedContent;
        }
        ContentPatchLog baseContentRecord = this.contentPatchLogRepository.findByPostIdAndVersion(patchLog.getPostId(), Integer.valueOf(1));
        String content = PatchUtils.restoreContent((String)patchLog.getContentDiff(), (String)baseContentRecord.getContentDiff());
        patchedContent.setContent(content);
        String originalContent = PatchUtils.restoreContent((String)patchLog.getOriginalContentDiff(), (String)baseContentRecord.getOriginalContentDiff());
        patchedContent.setOriginalContent(originalContent);
        return patchedContent;
    }

    public Content.ContentDiff generateDiff(Integer postId, String formatContent, String originalContent) {
        ContentPatchLog basePatchLog = this.contentPatchLogRepository.findByPostIdAndVersion(postId, Integer.valueOf(1));
        Content.ContentDiff contentDiff = new Content.ContentDiff();
        String contentChanges = PatchUtils.diffToJsonPatch((String)basePatchLog.getContentDiff(), (String)formatContent);
        contentDiff.setDiff(contentChanges);
        String originalContentChanges = PatchUtils.diffToJsonPatch((String)basePatchLog.getOriginalContentDiff(), (String)originalContent);
        contentDiff.setOriginalDiff(originalContentChanges);
        return contentDiff;
    }

    public ContentPatchLog getDraftByPostId(Integer postId) {
        return this.findLatestDraftBy(postId);
    }

    public Content.PatchedContent getByPostId(Integer postId) {
        ContentPatchLog contentPatchLog = this.contentPatchLogRepository.findFirstByPostIdOrderByVersionDesc(postId);
        if (contentPatchLog == null) {
            throw new NotFoundException("Post content patch log was not found or has been deleted.");
        }
        return this.applyPatch(contentPatchLog);
    }

    public Content.PatchedContent getPatchedContentById(Integer id) {
        ContentPatchLog contentPatchLog = this.getById(id);
        return this.applyPatch(contentPatchLog);
    }

    @NonNull
    public ContentPatchLog getById(@NonNull Integer id) {
        return (ContentPatchLog)this.contentPatchLogRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Post content patch log was not found or has been deleted."));
    }

    @Transactional(rollbackFor={Exception.class})
    public List<ContentPatchLog> removeByPostId(Integer postId) {
        List patchLogsToDelete = this.contentPatchLogRepository.findAllByPostId(postId);
        this.contentPatchLogRepository.deleteAllInBatch((Iterable)patchLogsToDelete);
        return patchLogsToDelete;
    }
}

