/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import run.halo.app.exception.NotFoundException;
import run.halo.app.model.entity.Content;
import run.halo.app.model.entity.ContentPatchLog;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.repository.ContentRepository;
import run.halo.app.repository.base.BaseRepository;
import run.halo.app.service.ContentPatchLogService;
import run.halo.app.service.ContentService;
import run.halo.app.service.base.AbstractCrudService;

@Service
public class ContentServiceImpl
extends AbstractCrudService<Content, Integer>
implements ContentService {
    private final ContentRepository contentRepository;
    private final ContentPatchLogService contentPatchLogService;

    protected ContentServiceImpl(ContentRepository contentRepository, ContentPatchLogService contentPatchLogService) {
        super((BaseRepository)contentRepository);
        this.contentRepository = contentRepository;
        this.contentPatchLogService = contentPatchLogService;
    }

    @Transactional(rollbackFor={Exception.class})
    public void createOrUpdateDraftBy(Integer postId, String content, String originalContent) {
        Assert.notNull((Object)postId, (String)"The postId must not be null.");
        ContentPatchLog contentPatchLog = this.contentPatchLogService.createOrUpdate(postId, content, originalContent);
        Optional savedContentOptional = this.contentRepository.findById((Object)postId);
        if (savedContentOptional.isPresent()) {
            Content savedContent = (Content)savedContentOptional.get();
            savedContent.setHeadPatchLogId(contentPatchLog.getId());
            this.contentRepository.save((Object)savedContent);
            return;
        }
        Content postContent = new Content();
        postContent.setPatchLogId(contentPatchLog.getId());
        postContent.setContent(content);
        postContent.setOriginalContent(originalContent);
        postContent.setId(postId);
        postContent.setStatus(PostStatus.DRAFT);
        postContent.setHeadPatchLogId(contentPatchLog.getId());
        this.contentRepository.save((Object)postContent);
    }

    @Transactional(rollbackFor={Exception.class})
    public Content publishContent(Integer postId) {
        ContentPatchLog contentPatchLog = this.contentPatchLogService.getDraftByPostId(postId);
        if (contentPatchLog == null) {
            return (Content)this.contentRepository.getById((Object)postId);
        }
        contentPatchLog.setStatus(PostStatus.PUBLISHED);
        contentPatchLog.setPublishTime(new Date());
        this.contentPatchLogService.create((Object)contentPatchLog);
        Content postContent = this.getById(postId);
        postContent.setPatchLogId(contentPatchLog.getId());
        postContent.setStatus(PostStatus.PUBLISHED);
        Content.PatchedContent patchedContent = this.contentPatchLogService.applyPatch(contentPatchLog);
        postContent.setContent(patchedContent.getContent());
        postContent.setOriginalContent(patchedContent.getOriginalContent());
        this.contentRepository.save((Object)postContent);
        return postContent;
    }

    @NonNull
    public Content getById(@NonNull Integer postId) {
        Assert.notNull((Object)postId, (String)"The postId must not be null.");
        return (Content)this.contentRepository.findById((Object)postId).orElseThrow(() -> new NotFoundException("content was not found or has been deleted"));
    }

    public Boolean draftingInProgress(Integer postId) {
        ContentPatchLog draft = this.contentPatchLogService.getDraftByPostId(postId);
        return Objects.nonNull(draft);
    }
}

