/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.exception.BadRequestException;
import run.halo.app.model.dto.JournalWithCmtCountDTO;
import run.halo.app.model.entity.Journal;
import run.halo.app.model.enums.CommentStatus;
import run.halo.app.model.enums.JournalType;
import run.halo.app.model.params.JournalParam;
import run.halo.app.model.params.JournalQuery;
import run.halo.app.repository.JournalRepository;
import run.halo.app.repository.base.BaseRepository;
import run.halo.app.service.JournalCommentService;
import run.halo.app.service.JournalService;
import run.halo.app.service.base.AbstractCrudService;
import run.halo.app.utils.ServiceUtils;

@Service
public class JournalServiceImpl
extends AbstractCrudService<Journal, Integer>
implements JournalService {
    private static final Logger log = LoggerFactory.getLogger(JournalServiceImpl.class);
    private final JournalRepository journalRepository;
    private final JournalCommentService journalCommentService;

    public JournalServiceImpl(JournalRepository journalRepository, JournalCommentService journalCommentService) {
        super((BaseRepository)journalRepository);
        this.journalRepository = journalRepository;
        this.journalCommentService = journalCommentService;
    }

    public Journal createBy(JournalParam journalParam) {
        Assert.notNull((Object)journalParam, (String)"Journal param must not be null");
        Journal journal = journalParam.convertTo();
        return (Journal)this.create((Object)journal);
    }

    public Journal updateBy(Journal journal) {
        Assert.notNull((Object)journal, (String)"Journal must not be null");
        return (Journal)this.update((Object)journal);
    }

    public Page<Journal> pageLatest(int top) {
        return this.listAll(ServiceUtils.buildLatestPageable((int)top));
    }

    public Page<Journal> pageBy(JournalQuery journalQuery, Pageable pageable) {
        Assert.notNull((Object)journalQuery, (String)"Journal query must not be null");
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        return this.journalRepository.findAll(this.buildSpecByQuery(journalQuery), pageable);
    }

    public Page<Journal> pageBy(JournalType type, Pageable pageable) {
        Assert.notNull((Object)type, (String)"Journal type must not be null");
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        return this.journalRepository.findAllByType(type, pageable);
    }

    public Journal removeById(Integer id) {
        Assert.notNull((Object)id, (String)"Journal id must not be null");
        List journalComments = this.journalCommentService.removeByPostId(id);
        log.debug("Removed journal comments: [{}]", (Object)journalComments);
        return (Journal)super.removeById((Object)id);
    }

    public JournalWithCmtCountDTO convertTo(Journal journal) {
        Assert.notNull((Object)journal, (String)"Journal must not be null");
        JournalWithCmtCountDTO journalWithCmtCountDto = (JournalWithCmtCountDTO)new JournalWithCmtCountDTO().convertFrom((Object)journal);
        journalWithCmtCountDto.setCommentCount(Long.valueOf(this.journalCommentService.countByStatusAndPostId(CommentStatus.PUBLISHED, journal.getId())));
        return journalWithCmtCountDto;
    }

    public List<JournalWithCmtCountDTO> convertToCmtCountDto(List<Journal> journals) {
        if (CollectionUtils.isEmpty(journals)) {
            return Collections.emptyList();
        }
        Set journalIds = ServiceUtils.fetchProperty(journals, Journal::getId);
        Map journalCommentCountMap = this.journalCommentService.countByStatusAndPostIds(CommentStatus.PUBLISHED, (Collection)journalIds);
        return journals.stream().map(journal -> {
            JournalWithCmtCountDTO journalWithCmtCountDTO = (JournalWithCmtCountDTO)new JournalWithCmtCountDTO().convertFrom(journal);
            journalWithCmtCountDTO.setCommentCount(journalCommentCountMap.getOrDefault(journal.getId(), 0L));
            return journalWithCmtCountDTO;
        }).collect(Collectors.toList());
    }

    public Page<JournalWithCmtCountDTO> convertToCmtCountDto(Page<Journal> journalPage) {
        Assert.notNull(journalPage, (String)"Journal page must not be null");
        List journalWithCmtCountDTOS = this.convertToCmtCountDto(journalPage.getContent());
        return new PageImpl(journalWithCmtCountDTOS, journalPage.getPageable(), journalPage.getTotalElements());
    }

    @Transactional
    public void increaseLike(Integer id) {
        this.increaseLike(1L, id);
    }

    @Transactional
    public void increaseLike(long likes, Integer id) {
        Assert.isTrue((likes > 0L ? 1 : 0) != 0, (String)"Likes to increase must not be less than 1");
        Assert.notNull((Object)id, (String)"Journal id must not be null");
        long affectedRows = this.journalRepository.updateLikes(likes, id);
        if (affectedRows != 1L) {
            log.error("Journal with id: [{}] may not be found", (Object)id);
            throw new BadRequestException("Failed to increase likes " + likes + " for journal with id " + id);
        }
    }

    @NonNull
    private Specification<Journal> buildSpecByQuery(@NonNull JournalQuery journalQuery) {
        Assert.notNull((Object)journalQuery, (String)"Journal query must not be null");
        return (Specification & Serializable)(root, query, criteriaBuilder) -> {
            LinkedList<Predicate> predicates = new LinkedList<Predicate>();
            if (journalQuery.getType() != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("type"), (Object)journalQuery.getType()));
            }
            if (journalQuery.getKeyword() != null) {
                String likeCondition = String.format("%%%s%%", StringUtils.strip((String)journalQuery.getKeyword()));
                Predicate contentLike = criteriaBuilder.like((Expression)root.get("content"), likeCondition);
                predicates.add(criteriaBuilder.or(new Predicate[]{contentLike}));
            }
            return query.where(predicates.toArray(new Predicate[0])).getRestriction();
        };
    }
}

