/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.exception.AlreadyExistsException;
import run.halo.app.model.dto.LinkDTO;
import run.halo.app.model.entity.Link;
import run.halo.app.model.params.LinkParam;
import run.halo.app.model.vo.LinkTeamVO;
import run.halo.app.repository.LinkRepository;
import run.halo.app.repository.base.BaseRepository;
import run.halo.app.service.LinkService;
import run.halo.app.service.base.AbstractCrudService;
import run.halo.app.utils.ServiceUtils;

@Service
public class LinkServiceImpl
extends AbstractCrudService<Link, Integer>
implements LinkService {
    private final LinkRepository linkRepository;

    public LinkServiceImpl(LinkRepository linkRepository) {
        super((BaseRepository)linkRepository);
        this.linkRepository = linkRepository;
    }

    @NonNull
    public List<LinkDTO> listDtos(@NonNull Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort info must not be null");
        return this.convertTo(this.listAll(sort));
    }

    @NonNull
    public List<LinkTeamVO> listTeamVos(@NonNull Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort info must not be null");
        List links = this.listDtos(sort);
        Set teams = ServiceUtils.fetchProperty((Collection)links, LinkDTO::getTeam);
        Map teamLinkListMap = ServiceUtils.convertToListMap((Collection)teams, (Collection)links, LinkDTO::getTeam);
        LinkedList<LinkTeamVO> result = new LinkedList<LinkTeamVO>();
        teamLinkListMap.forEach((team, linkList) -> {
            LinkTeamVO linkTeamVO = new LinkTeamVO();
            linkTeamVO.setTeam(team);
            linkTeamVO.setLinks(linkList);
            result.add(linkTeamVO);
        });
        return result;
    }

    @NonNull
    public List<LinkTeamVO> listTeamVosByRandom(@NonNull Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort info must not be null");
        List links = this.listDtos(sort);
        Set teams = ServiceUtils.fetchProperty((Collection)links, LinkDTO::getTeam);
        Map teamLinkListMap = ServiceUtils.convertToListMap((Collection)teams, (Collection)links, LinkDTO::getTeam);
        LinkedList<LinkTeamVO> result = new LinkedList<LinkTeamVO>();
        teamLinkListMap.forEach((team, linkList) -> {
            LinkTeamVO linkTeamVO = new LinkTeamVO();
            linkTeamVO.setTeam(team);
            Collections.shuffle(linkList);
            linkTeamVO.setLinks(linkList);
            result.add(linkTeamVO);
        });
        return result;
    }

    @NonNull
    public Link createBy(@NonNull LinkParam linkParam) {
        Assert.notNull((Object)linkParam, (String)"Link param must not be null");
        boolean exist = this.existByName(linkParam.getName());
        if (exist) {
            throw new AlreadyExistsException("\u53cb\u60c5\u94fe\u63a5 " + linkParam.getName() + " \u5df2\u5b58\u5728").setErrorData((Object)linkParam.getName());
        }
        exist = this.existByUrl(linkParam.getUrl());
        if (exist) {
            throw new AlreadyExistsException("\u53cb\u60c5\u94fe\u63a5 " + linkParam.getUrl() + " \u5df2\u5b58\u5728").setErrorData((Object)linkParam.getUrl());
        }
        return (Link)this.create((Object)((Link)linkParam.convertTo()));
    }

    @NonNull
    public Link updateBy(Integer id, @NonNull LinkParam linkParam) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull((Object)linkParam, (String)"Link param must not be null");
        boolean exist = this.linkRepository.existsByNameAndIdNot(linkParam.getName(), id);
        if (exist) {
            throw new AlreadyExistsException("\u53cb\u60c5\u94fe\u63a5 " + linkParam.getName() + " \u5df2\u5b58\u5728").setErrorData((Object)linkParam.getName());
        }
        exist = this.linkRepository.existsByUrlAndIdNot(linkParam.getUrl(), id);
        if (exist) {
            throw new AlreadyExistsException("\u53cb\u60c5\u94fe\u63a5 " + linkParam.getUrl() + " \u5df2\u5b58\u5728").setErrorData((Object)linkParam.getUrl());
        }
        Link link = (Link)this.getById((Object)id);
        linkParam.update((Object)link);
        return (Link)this.update((Object)link);
    }

    public boolean existByName(String name) {
        Assert.hasText((String)name, (String)"Link name must not be blank");
        Link link = new Link();
        link.setName(name);
        return this.linkRepository.exists(Example.of((Object)link));
    }

    public boolean existByUrl(String url) {
        Assert.hasText((String)url, (String)"Link url must not be blank");
        Link link = new Link();
        link.setUrl(url);
        return this.linkRepository.exists(Example.of((Object)link));
    }

    public List<String> listAllTeams() {
        return this.linkRepository.findAllTeams();
    }

    @NonNull
    public List<Link> listAllByRandom() {
        List allLink = this.linkRepository.findAll();
        Collections.shuffle(allLink);
        return allLink;
    }

    @NonNull
    private List<LinkDTO> convertTo(@Nullable List<Link> links) {
        if (CollectionUtils.isEmpty(links)) {
            return Collections.emptyList();
        }
        return links.stream().map(link -> (LinkDTO)new LinkDTO().convertFrom(link)).collect(Collectors.toList());
    }
}

