/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import run.halo.app.model.dto.LogDTO;
import run.halo.app.model.entity.Log;
import run.halo.app.repository.LogRepository;
import run.halo.app.repository.base.BaseRepository;
import run.halo.app.service.LogService;
import run.halo.app.service.base.AbstractCrudService;

@Service
public class LogServiceImpl
extends AbstractCrudService<Log, Long>
implements LogService {
    private final LogRepository logRepository;

    public LogServiceImpl(LogRepository logRepository) {
        super((BaseRepository)logRepository);
        this.logRepository = logRepository;
    }

    public Page<LogDTO> pageLatest(int top) {
        Assert.isTrue((top > 0 ? 1 : 0) != 0, (String)"Top number must not be less than 0");
        PageRequest latestPageable = PageRequest.of((int)0, (int)top, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        return this.listAll((Pageable)latestPageable).map(log -> (LogDTO)new LogDTO().convertFrom(log));
    }
}

