/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.model.dto.MenuDTO;
import run.halo.app.model.entity.Menu;
import run.halo.app.model.params.MenuParam;
import run.halo.app.model.vo.MenuTeamVO;
import run.halo.app.model.vo.MenuVO;
import run.halo.app.repository.MenuRepository;
import run.halo.app.repository.base.BaseRepository;
import run.halo.app.service.MenuService;
import run.halo.app.service.base.AbstractCrudService;
import run.halo.app.utils.BeanUtils;
import run.halo.app.utils.ServiceUtils;

@Service
public class MenuServiceImpl
extends AbstractCrudService<Menu, Integer>
implements MenuService {
    private final MenuRepository menuRepository;

    public MenuServiceImpl(MenuRepository menuRepository) {
        super((BaseRepository)menuRepository);
        this.menuRepository = menuRepository;
    }

    @NonNull
    public List<MenuDTO> listDtos(@NonNull Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort info must not be null");
        return this.convertTo(this.listAll(sort));
    }

    @NonNull
    public List<MenuTeamVO> listTeamVos(@NonNull Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort info must not be null");
        List menus = this.listDtos(sort);
        Set teams = ServiceUtils.fetchProperty((Collection)menus, MenuDTO::getTeam);
        Map teamMenuListMap = ServiceUtils.convertToListMap((Collection)teams, (Collection)menus, MenuDTO::getTeam);
        LinkedList<MenuTeamVO> result = new LinkedList<MenuTeamVO>();
        teamMenuListMap.forEach((team, menuList) -> {
            MenuTeamVO menuTeamVO = new MenuTeamVO();
            menuTeamVO.setTeam(team);
            menuTeamVO.setMenus(menuList);
            result.add(menuTeamVO);
        });
        return result;
    }

    public List<MenuDTO> listByTeam(@NonNull String team, Sort sort) {
        List menus = this.menuRepository.findByTeam(team, sort);
        return menus.stream().map(menu -> (MenuDTO)new MenuDTO().convertFrom(menu)).collect(Collectors.toList());
    }

    public List<MenuVO> listByTeamAsTree(@NonNull String team, Sort sort) {
        Assert.notNull((Object)team, (String)"Team must not be null");
        List menus = this.menuRepository.findByTeam(team, sort);
        if (CollectionUtils.isEmpty((Collection)menus)) {
            return Collections.emptyList();
        }
        MenuVO topLevelMenu = this.createTopLevelMenu();
        this.concreteTree(topLevelMenu, menus);
        return topLevelMenu.getChildren();
    }

    @NonNull
    public Menu createBy(@NonNull MenuParam menuParam) {
        Assert.notNull((Object)menuParam, (String)"Menu param must not be null");
        return this.create((Menu)menuParam.convertTo());
    }

    public List<MenuVO> listAsTree(@NonNull Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort info must not be null");
        List menus = this.listAll(sort);
        if (CollectionUtils.isEmpty((Collection)menus)) {
            return Collections.emptyList();
        }
        MenuVO topLevelMenu = this.createTopLevelMenu();
        this.concreteTree(topLevelMenu, menus);
        return topLevelMenu.getChildren();
    }

    public List<Menu> listByParentId(@NonNull Integer id) {
        Assert.notNull((Object)id, (String)"Menu parent id must not be null");
        return this.menuRepository.findByParentId(id);
    }

    public List<String> listAllTeams() {
        return this.menuRepository.findAllTeams();
    }

    @NonNull
    public Menu create(@NonNull Menu menu) {
        return (Menu)super.create((Object)menu);
    }

    @NonNull
    public Menu update(@NonNull Menu menu) {
        return (Menu)super.update((Object)menu);
    }

    @NonNull
    @Transactional(rollbackFor={Exception.class})
    public List<Menu> updateInBatch(@NonNull Collection<Menu> menus) {
        Set menuIds = ServiceUtils.fetchProperty(menus, Menu::getId);
        Map idMenuParamMap = ServiceUtils.convertToMap(menus, Menu::getId);
        return this.menuRepository.findAllById((Iterable)menuIds).stream().map(menuToUpdate -> {
            Menu menuParam = (Menu)idMenuParamMap.get(menuToUpdate.getId());
            BeanUtils.updateProperties((Object)menuParam, (Object)menuToUpdate);
            return this.update(menuToUpdate);
        }).collect(Collectors.toList());
    }

    private void concreteTree(MenuVO parentMenu, List<Menu> menus) {
        Assert.notNull((Object)parentMenu, (String)"Parent menu must not be null");
        if (CollectionUtils.isEmpty(menus)) {
            return;
        }
        LinkedList children = new LinkedList();
        menus.forEach(menu -> {
            if (parentMenu.getId().equals(menu.getParentId())) {
                children.add(menu);
                MenuVO child = (MenuVO)new MenuVO().convertFrom(menu);
                if (parentMenu.getChildren() == null) {
                    parentMenu.setChildren(new LinkedList());
                }
                parentMenu.getChildren().add(child);
            }
        });
        menus.removeAll(children);
        if (!CollectionUtils.isEmpty((Collection)parentMenu.getChildren())) {
            parentMenu.getChildren().forEach(childMenu -> this.concreteTree(childMenu, menus));
        }
    }

    @NonNull
    private MenuVO createTopLevelMenu() {
        MenuVO topMenu = new MenuVO();
        topMenu.setId(Integer.valueOf(0));
        topMenu.setChildren(new LinkedList());
        topMenu.setParentId(Integer.valueOf(-1));
        return topMenu;
    }

    private List<MenuDTO> convertTo(List<Menu> menus) {
        if (CollectionUtils.isEmpty(menus)) {
            return Collections.emptyList();
        }
        return menus.stream().map(menu -> (MenuDTO)new MenuDTO().convertFrom(menu)).collect(Collectors.toList());
    }
}

