/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.handler.migrate.MigrateHandlers;
import run.halo.app.model.enums.MigrateType;
import run.halo.app.service.MigrateService;

@Service
public class MigrateServiceImpl
implements MigrateService {
    private final MigrateHandlers migrateHandlers;

    public MigrateServiceImpl(MigrateHandlers migrateHandlers) {
        this.migrateHandlers = migrateHandlers;
    }

    public void migrate(MultipartFile file, MigrateType migrateType) {
        Assert.notNull((Object)file, (String)"Multipart file must not be null");
        Assert.notNull((Object)migrateType, (String)"Migrate type must not be null");
        this.migrateHandlers.upload(file, migrateType);
    }
}

