/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import com.qiniu.storage.Region;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.cache.AbstractStringCacheStore;
import run.halo.app.event.options.OptionUpdatedEvent;
import run.halo.app.model.dto.OptionSimpleDTO;
import run.halo.app.model.entity.Option;
import run.halo.app.model.enums.PostPermalinkType;
import run.halo.app.model.enums.SheetPermalinkType;
import run.halo.app.model.params.OptionParam;
import run.halo.app.model.params.OptionQuery;
import run.halo.app.model.properties.BlogProperties;
import run.halo.app.model.properties.CommentProperties;
import run.halo.app.model.properties.PermalinkProperties;
import run.halo.app.model.properties.PostProperties;
import run.halo.app.model.properties.PrimaryProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.properties.QiniuOssProperties;
import run.halo.app.repository.OptionRepository;
import run.halo.app.repository.base.BaseRepository;
import run.halo.app.service.OptionService;
import run.halo.app.service.base.AbstractCrudService;
import run.halo.app.utils.ServiceUtils;
import run.halo.app.utils.ValidationUtils;

@Service
public class OptionServiceImpl
extends AbstractCrudService<Option, Integer>
implements OptionService {
    private static final Logger log = LoggerFactory.getLogger(OptionServiceImpl.class);
    private final OptionRepository optionRepository;
    private final ApplicationContext applicationContext;
    private final AbstractStringCacheStore cacheStore;
    private final Map<String, PropertyEnum> propertyEnumMap;
    private final ApplicationEventPublisher eventPublisher;

    public OptionServiceImpl(OptionRepository optionRepository, ApplicationContext applicationContext, AbstractStringCacheStore cacheStore, ApplicationEventPublisher eventPublisher) {
        super((BaseRepository)optionRepository);
        this.optionRepository = optionRepository;
        this.applicationContext = applicationContext;
        this.cacheStore = cacheStore;
        this.eventPublisher = eventPublisher;
        this.propertyEnumMap = Collections.unmodifiableMap(PropertyEnum.getValuePropertyEnumMap());
    }

    @Deprecated
    @Transactional
    private void save(@NonNull String key, @Nullable String value) {
        Assert.hasText((String)key, (String)"Option key must not be blank");
        this.save(Collections.singletonMap(key, value));
    }

    @Transactional
    public void save(Map<String, Object> optionMap) {
        if (CollectionUtils.isEmpty(optionMap)) {
            return;
        }
        Map optionKeyMap = ServiceUtils.convertToMap((Collection)this.listAll(), Option::getKey);
        LinkedList optionsToCreate = new LinkedList();
        LinkedList optionsToUpdate = new LinkedList();
        optionMap.forEach((key, value) -> {
            Option oldOption = (Option)optionKeyMap.get(key);
            if (oldOption == null || !StringUtils.equals((CharSequence)oldOption.getValue(), (CharSequence)value.toString())) {
                OptionParam optionParam = new OptionParam();
                optionParam.setKey(key);
                optionParam.setValue(value.toString());
                ValidationUtils.validate((Object)optionParam, (Class[])new Class[0]);
                if (oldOption == null) {
                    optionsToCreate.add((Option)optionParam.convertTo());
                } else if (!StringUtils.equals((CharSequence)oldOption.getValue(), (CharSequence)value.toString())) {
                    optionParam.update((Object)oldOption);
                    optionsToUpdate.add(oldOption);
                }
            }
        });
        this.updateInBatch(optionsToUpdate);
        this.createInBatch(optionsToCreate);
        if (!CollectionUtils.isEmpty(optionsToUpdate) || !CollectionUtils.isEmpty(optionsToCreate)) {
            this.eventPublisher.publishEvent((ApplicationEvent)new OptionUpdatedEvent((Object)this));
        }
    }

    public void save(List<OptionParam> optionParams) {
        if (CollectionUtils.isEmpty(optionParams)) {
            return;
        }
        Map optionMap = ServiceUtils.convertToMap(optionParams, OptionParam::getKey, OptionParam::getValue);
        this.save(optionMap);
    }

    public void save(OptionParam optionParam) {
        Option option = (Option)optionParam.convertTo();
        this.create((Object)option);
        this.eventPublisher.publishEvent((ApplicationEvent)new OptionUpdatedEvent((Object)this));
    }

    public void update(Integer optionId, OptionParam optionParam) {
        Option optionToUpdate = (Option)this.getById((Object)optionId);
        optionParam.update((Object)optionToUpdate);
        this.update((Object)optionToUpdate);
        this.eventPublisher.publishEvent((ApplicationEvent)new OptionUpdatedEvent((Object)this));
    }

    public void saveProperty(PropertyEnum property, String value) {
        Assert.notNull((Object)property, (String)"Property must not be null");
        this.save((String)property.getValue(), value);
    }

    public void saveProperties(Map<? extends PropertyEnum, String> properties) {
        if (CollectionUtils.isEmpty(properties)) {
            return;
        }
        LinkedHashMap optionMap = new LinkedHashMap();
        properties.forEach((property, value) -> optionMap.put((String)property.getValue(), value));
        this.save(optionMap);
    }

    public Map<String, Object> listOptions() {
        return this.cacheStore.getAny("options", Map.class).orElseGet(() -> {
            List options = this.listAll();
            Set keys = ServiceUtils.fetchProperty((Collection)options, Option::getKey);
            Map userDefinedOptionMap = ServiceUtils.convertToMap((Collection)options, Option::getKey, option -> {
                String key = option.getKey();
                PropertyEnum propertyEnum = (PropertyEnum)this.propertyEnumMap.get(key);
                if (propertyEnum == null) {
                    return option.getValue();
                }
                return PropertyEnum.convertTo((String)option.getValue(), (PropertyEnum)propertyEnum);
            });
            HashMap result = new HashMap(userDefinedOptionMap);
            this.propertyEnumMap.keySet().stream().filter(key -> !keys.contains(key)).forEach(key -> {
                PropertyEnum propertyEnum = (PropertyEnum)this.propertyEnumMap.get(key);
                result.put(key, PropertyEnum.convertTo((String)propertyEnum.defaultValue(), (PropertyEnum)propertyEnum));
            });
            this.cacheStore.putAny("options", result);
            return result;
        });
    }

    public Page<OptionSimpleDTO> pageDtosBy(Pageable pageable, OptionQuery optionQuery) {
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        Page optionPage = this.optionRepository.findAll(this.buildSpecByQuery(optionQuery), pageable);
        return optionPage.map(arg_0 -> this.convertToDto(arg_0));
    }

    public Option removePermanently(Integer id) {
        Option deletedOption = (Option)this.removeById((Object)id);
        this.eventPublisher.publishEvent((ApplicationEvent)new OptionUpdatedEvent((Object)this));
        return deletedOption;
    }

    @NonNull
    private Specification<Option> buildSpecByQuery(@NonNull OptionQuery optionQuery) {
        Assert.notNull((Object)optionQuery, (String)"Option query must not be null");
        return (Specification & Serializable)(root, query, criteriaBuilder) -> {
            LinkedList<Predicate> predicates = new LinkedList<Predicate>();
            if (optionQuery.getType() != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("type"), (Object)optionQuery.getType()));
            }
            if (optionQuery.getKeyword() != null) {
                String likeCondition = String.format("%%%s%%", StringUtils.strip((String)optionQuery.getKeyword()));
                Predicate keyLike = criteriaBuilder.like((Expression)root.get("key"), likeCondition);
                Predicate valueLike = criteriaBuilder.like((Expression)root.get("value"), likeCondition);
                predicates.add(criteriaBuilder.or((Expression)keyLike, (Expression)valueLike));
            }
            return query.where(predicates.toArray(new Predicate[0])).getRestriction();
        };
    }

    public int getPostPageSize() {
        try {
            return (Integer)this.getByPropertyOrDefault((PropertyEnum)PostProperties.INDEX_PAGE_SIZE, Integer.class, (Object)10);
        }
        catch (NumberFormatException e) {
            log.error(PostProperties.INDEX_PAGE_SIZE.getValue() + " option is not a number format", (Throwable)e);
            return 10;
        }
    }

    public int getArchivesPageSize() {
        try {
            return (Integer)this.getByPropertyOrDefault((PropertyEnum)PostProperties.ARCHIVES_PAGE_SIZE, Integer.class, (Object)10);
        }
        catch (NumberFormatException e) {
            log.error(PostProperties.ARCHIVES_PAGE_SIZE.getValue() + " option is not a number format", (Throwable)e);
            return 10;
        }
    }

    public int getCommentPageSize() {
        try {
            return (Integer)this.getByPropertyOrDefault((PropertyEnum)CommentProperties.PAGE_SIZE, Integer.class, (Object)10);
        }
        catch (NumberFormatException e) {
            log.error(CommentProperties.PAGE_SIZE.getValue() + " option is not a number format", (Throwable)e);
            return 10;
        }
    }

    public int getRssPageSize() {
        try {
            return (Integer)this.getByPropertyOrDefault((PropertyEnum)PostProperties.RSS_PAGE_SIZE, Integer.class, (Object)20);
        }
        catch (NumberFormatException e) {
            log.error(PostProperties.RSS_PAGE_SIZE.getValue() + " setting is not a number format", (Throwable)e);
            return 20;
        }
    }

    public Region getQiniuRegion() {
        return this.getByProperty((PropertyEnum)QiniuOssProperties.OSS_ZONE).map(qiniuZone -> {
            Region region;
            switch (qiniuZone.toString()) {
                case "z0": {
                    region = Region.region0();
                    break;
                }
                case "z1": {
                    region = Region.region1();
                    break;
                }
                case "z2": {
                    region = Region.region2();
                    break;
                }
                case "na0": {
                    region = Region.regionNa0();
                    break;
                }
                case "as0": {
                    region = Region.regionAs0();
                    break;
                }
                default: {
                    region = Region.autoRegion();
                }
            }
            return region;
        }).orElseGet(Region::autoRegion);
    }

    public Locale getLocale() {
        return this.getByProperty((PropertyEnum)BlogProperties.BLOG_LOCALE).map(localeStr -> {
            try {
                return Locale.forLanguageTag(localeStr.toString());
            }
            catch (Exception e) {
                return Locale.getDefault();
            }
        }).orElseGet(Locale::getDefault);
    }

    public String getBlogBaseUrl() {
        String serverPort = this.applicationContext.getEnvironment().getProperty("server.port", "8080");
        String blogUrl = this.getByProperty((PropertyEnum)BlogProperties.BLOG_URL).orElse("").toString();
        blogUrl = StringUtils.isNotBlank((CharSequence)blogUrl) ? StringUtils.removeEnd((String)blogUrl, (String)"/") : String.format("http://%s:%s", "127.0.0.1", serverPort);
        return blogUrl;
    }

    public long getBirthday() {
        return Long.parseLong((String)this.getByPropertyOrDefault((PropertyEnum)PrimaryProperties.BIRTHDAY, String.class));
    }

    public PostPermalinkType getPostPermalinkType() {
        return (PostPermalinkType)this.getEnumByPropertyOrDefault((PropertyEnum)PermalinkProperties.POST_PERMALINK_TYPE, PostPermalinkType.class, (Enum)PostPermalinkType.DEFAULT);
    }

    public SheetPermalinkType getSheetPermalinkType() {
        return (SheetPermalinkType)this.getEnumByPropertyOrDefault((PropertyEnum)PermalinkProperties.SHEET_PERMALINK_TYPE, SheetPermalinkType.class, (Enum)SheetPermalinkType.SECONDARY);
    }

    public String getSheetPrefix() {
        return (String)this.getByPropertyOrDefault((PropertyEnum)PermalinkProperties.SHEET_PREFIX, String.class, (Object)PermalinkProperties.SHEET_PREFIX.defaultValue());
    }

    public String getLinksPrefix() {
        return (String)this.getByPropertyOrDefault((PropertyEnum)PermalinkProperties.LINKS_PREFIX, String.class, (Object)PermalinkProperties.LINKS_PREFIX.defaultValue());
    }

    public String getPhotosPrefix() {
        return (String)this.getByPropertyOrDefault((PropertyEnum)PermalinkProperties.PHOTOS_PREFIX, String.class, (Object)PermalinkProperties.PHOTOS_PREFIX.defaultValue());
    }

    public String getJournalsPrefix() {
        return (String)this.getByPropertyOrDefault((PropertyEnum)PermalinkProperties.JOURNALS_PREFIX, String.class, (Object)PermalinkProperties.JOURNALS_PREFIX.defaultValue());
    }

    public String getArchivesPrefix() {
        return (String)this.getByPropertyOrDefault((PropertyEnum)PermalinkProperties.ARCHIVES_PREFIX, String.class, (Object)PermalinkProperties.ARCHIVES_PREFIX.defaultValue());
    }

    public String getCategoriesPrefix() {
        return (String)this.getByPropertyOrDefault((PropertyEnum)PermalinkProperties.CATEGORIES_PREFIX, String.class, (Object)PermalinkProperties.CATEGORIES_PREFIX.defaultValue());
    }

    public String getTagsPrefix() {
        return (String)this.getByPropertyOrDefault((PropertyEnum)PermalinkProperties.TAGS_PREFIX, String.class, (Object)PermalinkProperties.TAGS_PREFIX.defaultValue());
    }

    public String getPathSuffix() {
        return (String)this.getByPropertyOrDefault((PropertyEnum)PermalinkProperties.PATH_SUFFIX, String.class, (Object)PermalinkProperties.PATH_SUFFIX.defaultValue());
    }

    public OptionSimpleDTO convertToDto(Option option) {
        Assert.notNull((Object)option, (String)"Option must not be null");
        return (OptionSimpleDTO)new OptionSimpleDTO().convertFrom((Object)option);
    }
}

