/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import run.halo.app.exception.BadRequestException;
import run.halo.app.model.dto.PhotoDTO;
import run.halo.app.model.entity.Photo;
import run.halo.app.model.params.PhotoParam;
import run.halo.app.model.params.PhotoQuery;
import run.halo.app.model.vo.PhotoTeamVO;
import run.halo.app.repository.PhotoRepository;
import run.halo.app.repository.base.BaseRepository;
import run.halo.app.service.PhotoService;
import run.halo.app.service.base.AbstractCrudService;
import run.halo.app.utils.ServiceUtils;

@Service
public class PhotoServiceImpl
extends AbstractCrudService<Photo, Integer>
implements PhotoService {
    private static final Logger log = LoggerFactory.getLogger(PhotoServiceImpl.class);
    private final PhotoRepository photoRepository;

    public PhotoServiceImpl(PhotoRepository photoRepository) {
        super((BaseRepository)photoRepository);
        this.photoRepository = photoRepository;
    }

    public List<PhotoDTO> listDtos(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort info must not be null");
        return this.listAll(sort).stream().map(photo -> (PhotoDTO)new PhotoDTO().convertFrom(photo)).collect(Collectors.toList());
    }

    public List<PhotoTeamVO> listTeamVos(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort info must not be null");
        List photos = this.listDtos(sort);
        Set teams = ServiceUtils.fetchProperty((Collection)photos, PhotoDTO::getTeam);
        Map teamPhotoListMap = ServiceUtils.convertToListMap((Collection)teams, (Collection)photos, PhotoDTO::getTeam);
        LinkedList<PhotoTeamVO> result = new LinkedList<PhotoTeamVO>();
        teamPhotoListMap.forEach((team, photoList) -> {
            PhotoTeamVO photoTeamVO = new PhotoTeamVO();
            photoTeamVO.setTeam(team);
            photoTeamVO.setPhotos(photoList);
            result.add(photoTeamVO);
        });
        return result;
    }

    public List<PhotoDTO> listByTeam(String team, Sort sort) {
        List photos = this.photoRepository.findByTeam(team, sort);
        return photos.stream().map(photo -> (PhotoDTO)new PhotoDTO().convertFrom(photo)).collect(Collectors.toList());
    }

    public Page<PhotoDTO> pageBy(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        Page photos = this.photoRepository.findAll(pageable);
        return photos.map(photo -> (PhotoDTO)new PhotoDTO().convertFrom(photo));
    }

    public Page<PhotoDTO> pageDtosBy(Pageable pageable, PhotoQuery photoQuery) {
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        Page photoPage = this.photoRepository.findAll(this.buildSpecByQuery(photoQuery), pageable);
        return photoPage.map(photo -> (PhotoDTO)new PhotoDTO().convertFrom(photo));
    }

    public Photo createBy(PhotoParam photoParam) {
        Assert.notNull((Object)photoParam, (String)"Photo param must not be null");
        return (Photo)this.create((Object)((Photo)photoParam.convertTo()));
    }

    public List<String> listAllTeams() {
        return this.photoRepository.findAllTeams();
    }

    @Transactional
    public void increaseLike(Integer photoId) {
        Assert.notNull((Object)photoId, (String)"Photo id must not be null");
        int affectedRows = this.photoRepository.updateLikes(1L, photoId);
        if (affectedRows != 1) {
            log.error("Photo with id: [{}] may not be found", (Object)photoId);
            throw new BadRequestException("Failed to increase likes 1 for photo with id " + photoId);
        }
    }

    @NonNull
    private Specification<Photo> buildSpecByQuery(@NonNull PhotoQuery photoQuery) {
        Assert.notNull((Object)photoQuery, (String)"Photo query must not be null");
        return (Specification & Serializable)(root, query, criteriaBuilder) -> {
            LinkedList<Predicate> predicates = new LinkedList<Predicate>();
            if (photoQuery.getTeam() != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("team"), (Object)photoQuery.getTeam()));
            }
            if (photoQuery.getKeyword() != null) {
                String likeCondition = String.format("%%%s%%", StringUtils.strip((String)photoQuery.getKeyword()));
                Predicate nameLike = criteriaBuilder.like((Expression)root.get("name"), likeCondition);
                Predicate descriptionLike = criteriaBuilder.like((Expression)root.get("description"), likeCondition);
                Predicate locationLike = criteriaBuilder.like((Expression)root.get("location"), likeCondition);
                predicates.add(criteriaBuilder.or(new Predicate[]{nameLike, descriptionLike, locationLike}));
            }
            return query.where(predicates.toArray(new Predicate[0])).getRestriction();
        };
    }
}

