/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.exception.NotFoundException;
import run.halo.app.model.dto.CategoryWithPostCountDTO;
import run.halo.app.model.entity.Category;
import run.halo.app.model.entity.Post;
import run.halo.app.model.entity.PostCategory;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.model.projection.CategoryIdPostStatusProjection;
import run.halo.app.model.vo.CategoryVO;
import run.halo.app.repository.PostCategoryRepository;
import run.halo.app.repository.PostRepository;
import run.halo.app.repository.base.BaseRepository;
import run.halo.app.service.CategoryService;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostCategoryService;
import run.halo.app.service.base.AbstractCrudService;
import run.halo.app.utils.HaloUtils;
import run.halo.app.utils.ServiceUtils;

@Service
public class PostCategoryServiceImpl
extends AbstractCrudService<PostCategory, Integer>
implements PostCategoryService {
    private final PostCategoryRepository postCategoryRepository;
    private final PostRepository postRepository;
    private CategoryService categoryService;
    private final OptionService optionService;

    public PostCategoryServiceImpl(PostCategoryRepository postCategoryRepository, PostRepository postRepository, OptionService optionService) {
        super((BaseRepository)postCategoryRepository);
        this.postCategoryRepository = postCategoryRepository;
        this.postRepository = postRepository;
        this.optionService = optionService;
    }

    @Lazy
    @Autowired
    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    public List<Category> listCategoriesBy(Integer postId) {
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        Set categoryIds = this.postCategoryRepository.findAllCategoryIdsByPostId(postId);
        return this.categoryService.listAllByIds((Collection)categoryIds);
    }

    public Map<Integer, List<Category>> listCategoryListMap(Collection<Integer> postIds) {
        if (CollectionUtils.isEmpty(postIds)) {
            return Collections.emptyMap();
        }
        List postCategories = this.postCategoryRepository.findAllByPostIdIn(postIds);
        Set categoryIds = ServiceUtils.fetchProperty((Collection)postCategories, PostCategory::getCategoryId);
        List categories = this.categoryService.listAllByIds((Collection)categoryIds);
        Map categoryMap = ServiceUtils.convertToMap((Collection)categories, Category::getId);
        HashMap<Integer, List<Category>> categoryListMap = new HashMap<Integer, List<Category>>();
        postCategories.forEach(postCategory -> categoryListMap.computeIfAbsent(postCategory.getPostId(), postId -> new LinkedList()).add((Category)categoryMap.get(postCategory.getCategoryId())));
        return categoryListMap;
    }

    public List<Post> listPostBy(Integer categoryId) {
        Assert.notNull((Object)categoryId, (String)"Category id must not be null");
        Set postIds = this.postCategoryRepository.findAllPostIdsByCategoryId(categoryId);
        return this.postRepository.findAllById((Iterable)postIds);
    }

    public List<Post> listPostBy(Integer categoryId, PostStatus status) {
        Assert.notNull((Object)categoryId, (String)"Category id must not be null");
        Assert.notNull((Object)status, (String)"Post status must not be null");
        Set postIds = this.postCategoryRepository.findAllPostIdsByCategoryId(categoryId, status);
        return this.postRepository.findAllById((Iterable)postIds);
    }

    public List<Post> listPostBy(Integer categoryId, Set<PostStatus> status) {
        Assert.notNull((Object)categoryId, (String)"Category id must not be null");
        Assert.notNull(status, (String)"Post status must not be null");
        Set postIds = this.postCategoryRepository.findAllPostIdsByCategoryId(categoryId, status);
        return this.postRepository.findAllById((Iterable)postIds);
    }

    public List<Post> listPostBy(String slug, Set<PostStatus> status) {
        Assert.notNull((Object)slug, (String)"Category slug must not be null");
        Assert.notNull(status, (String)"Post status must not be null");
        Category category = this.categoryService.getBySlug(slug);
        if (Objects.isNull(category)) {
            throw new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u5206\u7c7b\u7684\u4fe1\u606f").setErrorData((Object)slug);
        }
        Set postsIds = this.postCategoryRepository.findAllPostIdsByCategoryId(category.getId(), status);
        return this.postRepository.findAllById((Iterable)postsIds);
    }

    public List<Post> listPostBy(String slug, PostStatus status) {
        Assert.notNull((Object)slug, (String)"Category slug must not be null");
        Assert.notNull((Object)status, (String)"Post status must not be null");
        Category category = this.categoryService.getBySlug(slug);
        if (Objects.isNull(category)) {
            throw new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u5206\u7c7b\u7684\u4fe1\u606f").setErrorData((Object)slug);
        }
        Set postsIds = this.postCategoryRepository.findAllPostIdsByCategoryId(category.getId(), status);
        return this.postRepository.findAllById((Iterable)postsIds);
    }

    public Page<Post> pagePostBy(Integer categoryId, Pageable pageable) {
        Assert.notNull((Object)categoryId, (String)"Category id must not be null");
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        Set postIds = this.postCategoryRepository.findAllPostIdsByCategoryId(categoryId);
        return this.postRepository.findAllByIdIn((Collection)postIds, pageable);
    }

    public Page<Post> pagePostBy(Integer categoryId, PostStatus status, Pageable pageable) {
        Assert.notNull((Object)categoryId, (String)"Category id must not be null");
        Assert.notNull((Object)status, (String)"Post status must not be null");
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        Set postIds = this.postCategoryRepository.findAllPostIdsByCategoryId(categoryId, status);
        return this.postRepository.findAllByIdIn((Collection)postIds, pageable);
    }

    public Page<Post> pagePostBy(Integer categoryId, Set<PostStatus> status, Pageable pageable) {
        Assert.notNull((Object)categoryId, (String)"Category id must not be null");
        Assert.notNull(status, (String)"Post status must not be null");
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        Set postIds = this.postCategoryRepository.findAllPostIdsByCategoryId(categoryId, status);
        return this.postRepository.findAllByIdIn((Collection)postIds, pageable);
    }

    public List<PostCategory> mergeOrCreateByIfAbsent(Integer postId, Set<Integer> categoryIds) {
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        if (CollectionUtils.isEmpty(categoryIds)) {
            return Collections.emptyList();
        }
        List<PostCategory> postCategoriesStaging = categoryIds.stream().map(categoryId -> {
            PostCategory postCategory = new PostCategory();
            postCategory.setPostId(postId);
            postCategory.setCategoryId(categoryId);
            return postCategory;
        }).collect(Collectors.toList());
        LinkedList postCategoriesToCreate = new LinkedList();
        LinkedList postCategoriesToRemove = new LinkedList();
        List postCategories = this.postCategoryRepository.findAllByPostId(postId);
        postCategories.forEach(postCategory -> {
            if (!postCategoriesStaging.contains(postCategory)) {
                postCategoriesToRemove.add(postCategory);
            }
        });
        postCategoriesStaging.forEach(postCategoryStaging -> {
            if (!postCategories.contains(postCategoryStaging)) {
                postCategoriesToCreate.add(postCategoryStaging);
            }
        });
        this.removeAll(postCategoriesToRemove);
        postCategories.removeAll(postCategoriesToRemove);
        postCategories.addAll(this.createInBatch(postCategoriesToCreate));
        return postCategories;
    }

    public List<PostCategory> listByPostId(Integer postId) {
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        return this.postCategoryRepository.findAllByPostId(postId);
    }

    public List<PostCategory> listByCategoryId(Integer categoryId) {
        Assert.notNull((Object)categoryId, (String)"Category id must not be null");
        return this.postCategoryRepository.findAllByCategoryId(categoryId);
    }

    public Set<Integer> listCategoryIdsByPostId(Integer postId) {
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        return this.postCategoryRepository.findAllCategoryIdsByPostId(postId);
    }

    public List<PostCategory> removeByPostId(Integer postId) {
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        return this.postCategoryRepository.deleteByPostId(postId);
    }

    public List<PostCategory> removeByCategoryId(Integer categoryId) {
        Assert.notNull((Object)categoryId, (String)"Category id must not be null");
        return this.postCategoryRepository.deleteByCategoryId(categoryId);
    }

    public List<CategoryWithPostCountDTO> listCategoryWithPostCountDto(@NonNull Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort info must not be null");
        List categories = this.categoryService.listAll(sort);
        List categoryTreeVo = this.categoryService.listToTree(categories);
        this.populatePostIds(categoryTreeVo, postStatus -> !PostStatus.RECYCLE.equals(postStatus));
        return this.flatTreeToList(categoryTreeVo);
    }

    private List<CategoryWithPostCountDTO> flatTreeToList(List<CategoryVO> categoryTree) {
        Assert.notNull(categoryTree, (String)"The categoryTree must not be null.");
        LinkedList<CategoryWithPostCountDTO> result = new LinkedList<CategoryWithPostCountDTO>();
        this.walkCategoryTree(categoryTree, category -> {
            CategoryWithPostCountDTO categoryWithPostCountDto = new CategoryWithPostCountDTO();
            BeanUtils.copyProperties((Object)category, (Object)categoryWithPostCountDto);
            String fullPath = this.categoryService.buildCategoryFullPath(category.getSlug());
            categoryWithPostCountDto.setFullPath(fullPath);
            int postCount = Objects.requireNonNullElse(category.getPostIds(), Collections.emptySet()).size();
            categoryWithPostCountDto.setPostCount(Long.valueOf(postCount));
            result.add(categoryWithPostCountDto);
        });
        return result;
    }

    private void populatePostIds(List<CategoryVO> categoryTree, Predicate<PostStatus> statusFilter) {
        Assert.notNull(categoryTree, (String)"The categoryTree must not be null.");
        Map categoryPostIdsMap = this.postCategoryRepository.findAllWithPostStatus().stream().filter(record -> statusFilter.test(record.getPostStatus())).collect(Collectors.groupingBy(CategoryIdPostStatusProjection::getCategoryId, Collectors.mapping(CategoryIdPostStatusProjection::getPostId, Collectors.toSet())));
        this.walkCategoryTree(categoryTree, category -> {
            Set postIds = categoryPostIdsMap.getOrDefault(category.getId(), new LinkedHashSet());
            category.setPostIds(postIds);
        });
        CategoryVO categoryTreeRootNode = new CategoryVO();
        categoryTreeRootNode.setChildren(categoryTree);
        this.mergePostIdsFromBottomToTop(categoryTreeRootNode);
    }

    private void mergePostIdsFromBottomToTop(CategoryVO root) {
        if (root == null) {
            return;
        }
        List children = root.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        for (CategoryVO category : children) {
            this.mergePostIdsFromBottomToTop(category);
            if (root.getPostIds() == null) {
                root.setPostIds(new LinkedHashSet());
            }
            root.getPostIds().addAll(category.getPostIds());
        }
    }

    private void walkCategoryTree(List<CategoryVO> categoryTree, Consumer<CategoryVO> consumer) {
        ArrayDeque<CategoryVO> queue = new ArrayDeque<CategoryVO>(categoryTree);
        while (!queue.isEmpty()) {
            CategoryVO category = (CategoryVO)queue.poll();
            consumer.accept(category);
            if (!HaloUtils.isNotEmpty((Collection)category.getChildren())) continue;
            queue.addAll(category.getChildren());
        }
    }

    public List<PostCategory> listByCategoryIdList(List<Integer> categoryIdList) {
        Assert.notEmpty(categoryIdList, (String)"category id list not empty");
        return this.postCategoryRepository.findAllByCategoryIdList(categoryIdList);
    }
}

