/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import run.halo.app.exception.BadRequestException;
import run.halo.app.exception.ForbiddenException;
import run.halo.app.exception.NotFoundException;
import run.halo.app.model.entity.Post;
import run.halo.app.model.entity.PostComment;
import run.halo.app.model.enums.CommentViolationTypeEnum;
import run.halo.app.model.properties.CommentProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.repository.PostCommentRepository;
import run.halo.app.repository.PostRepository;
import run.halo.app.repository.base.BaseCommentRepository;
import run.halo.app.service.CommentBlackListService;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostCommentService;
import run.halo.app.service.UserService;
import run.halo.app.service.assembler.comment.BaseCommentAssembler;
import run.halo.app.service.assembler.comment.PostCommentAssembler;
import run.halo.app.service.impl.BaseCommentServiceImpl;
import run.halo.app.utils.ServletUtils;

@Service
public class PostCommentServiceImpl
extends BaseCommentServiceImpl<PostComment>
implements PostCommentService {
    private static final Logger log = LoggerFactory.getLogger(PostCommentServiceImpl.class);
    private final PostRepository postRepository;
    private final CommentBlackListService commentBlackListService;

    public PostCommentServiceImpl(PostCommentRepository postCommentRepository, PostRepository postRepository, UserService userService, OptionService optionService, CommentBlackListService commentBlackListService, ApplicationEventPublisher eventPublisher, PostCommentAssembler postCommentAssembler) {
        super((BaseCommentRepository)postCommentRepository, optionService, userService, eventPublisher, (BaseCommentAssembler)postCommentAssembler);
        this.postRepository = postRepository;
        this.commentBlackListService = commentBlackListService;
    }

    public void validateTarget(@NonNull Integer postId) {
        Post post = (Post)this.postRepository.findById((Object)postId).orElseThrow(() -> new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u6587\u7ae0\u7684\u4fe1\u606f").setErrorData((Object)postId));
        if (post.getDisallowComment().booleanValue()) {
            throw new BadRequestException("\u8be5\u6587\u7ae0\u5df2\u7ecf\u88ab\u7981\u6b62\u8bc4\u8bba").setErrorData((Object)postId);
        }
    }

    public void validateCommentBlackListStatus() {
        CommentViolationTypeEnum banStatus = this.commentBlackListService.commentsBanStatus(ServletUtils.getRequestIp());
        Integer banTime = (Integer)this.optionService.getByPropertyOrDefault((PropertyEnum)CommentProperties.COMMENT_BAN_TIME, Integer.class, (Object)10);
        if (banStatus == CommentViolationTypeEnum.FREQUENTLY) {
            throw new ForbiddenException(String.format("\u60a8\u7684\u8bc4\u8bba\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7%s\u5206\u949f\u4e4b\u540e\u518d\u8bd5\u3002", banTime));
        }
    }
}

