/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.event.logger.LogEvent;
import run.halo.app.event.post.PostUpdatedEvent;
import run.halo.app.event.post.PostVisitEvent;
import run.halo.app.exception.NotFoundException;
import run.halo.app.model.entity.BasePost;
import run.halo.app.model.entity.Category;
import run.halo.app.model.entity.Content;
import run.halo.app.model.entity.Post;
import run.halo.app.model.entity.PostCategory;
import run.halo.app.model.entity.PostMeta;
import run.halo.app.model.entity.Tag;
import run.halo.app.model.enums.LogType;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.model.params.PostParam;
import run.halo.app.model.params.PostQuery;
import run.halo.app.model.properties.PostProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.vo.ArchiveMonthVO;
import run.halo.app.model.vo.ArchiveYearVO;
import run.halo.app.model.vo.PostDetailVO;
import run.halo.app.model.vo.PostMarkdownVO;
import run.halo.app.repository.PostRepository;
import run.halo.app.repository.base.BasePostRepository;
import run.halo.app.service.CategoryService;
import run.halo.app.service.ContentPatchLogService;
import run.halo.app.service.ContentService;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostCategoryService;
import run.halo.app.service.PostCommentService;
import run.halo.app.service.PostMetaService;
import run.halo.app.service.PostService;
import run.halo.app.service.PostTagService;
import run.halo.app.service.TagService;
import run.halo.app.service.assembler.PostAssembler;
import run.halo.app.service.impl.BasePostServiceImpl;
import run.halo.app.utils.DateUtils;
import run.halo.app.utils.HaloUtils;
import run.halo.app.utils.MarkdownUtils;
import run.halo.app.utils.ServiceUtils;
import run.halo.app.utils.SlugUtils;

@Service
public class PostServiceImpl
extends BasePostServiceImpl<Post>
implements PostService {
    private static final Logger log = LoggerFactory.getLogger(PostServiceImpl.class);
    private final PostAssembler postAssembler;
    private final PostRepository postRepository;
    private final TagService tagService;
    private final CategoryService categoryService;
    private final PostTagService postTagService;
    private final ContentService postContentService;
    private final PostCategoryService postCategoryService;
    private final PostCommentService postCommentService;
    private final ApplicationEventPublisher eventPublisher;
    private final PostMetaService postMetaService;
    private final OptionService optionService;
    private final ContentPatchLogService postContentPatchLogService;
    private final ApplicationContext applicationContext;

    public PostServiceImpl(BasePostRepository<Post> basePostRepository, PostAssembler postAssembler, OptionService optionService, PostRepository postRepository, TagService tagService, CategoryService categoryService, PostTagService postTagService, PostCategoryService postCategoryService, PostCommentService postCommentService, ApplicationEventPublisher eventPublisher, PostMetaService postMetaService, ContentService contentService, ContentPatchLogService contentPatchLogService, ApplicationContext applicationContext) {
        super(basePostRepository, optionService, contentService, contentPatchLogService);
        this.postAssembler = postAssembler;
        this.postRepository = postRepository;
        this.tagService = tagService;
        this.categoryService = categoryService;
        this.postTagService = postTagService;
        this.postCategoryService = postCategoryService;
        this.postCommentService = postCommentService;
        this.eventPublisher = eventPublisher;
        this.postMetaService = postMetaService;
        this.optionService = optionService;
        this.postContentService = contentService;
        this.postContentPatchLogService = contentPatchLogService;
        this.applicationContext = applicationContext;
    }

    public Page<Post> pageBy(PostQuery postQuery, Pageable pageable) {
        Assert.notNull((Object)postQuery, (String)"Post query must not be null");
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        return this.postRepository.findAll(this.buildSpecByQuery(postQuery), pageable);
    }

    public Page<Post> pageBy(String keyword, Pageable pageable) {
        Assert.notNull((Object)keyword, (String)"keyword must not be null");
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        PostQuery postQuery = new PostQuery();
        postQuery.setKeyword(keyword);
        postQuery.setStatuses(Set.of(PostStatus.PUBLISHED));
        return this.postRepository.findAll(this.buildSpecByQuery(postQuery), pageable);
    }

    @Transactional(rollbackFor={Exception.class})
    public PostDetailVO createBy(Post postToCreate, Set<Integer> tagIds, Set<Integer> categoryIds, Set<PostMeta> metas, boolean autoSave) {
        PostDetailVO createdPost = this.createOrUpdate(postToCreate, tagIds, categoryIds, metas);
        if (!autoSave) {
            LogEvent logEvent = new LogEvent((Object)this, createdPost.getId().toString(), LogType.POST_PUBLISHED, createdPost.getTitle());
            this.eventPublisher.publishEvent((ApplicationEvent)logEvent);
        }
        return createdPost;
    }

    @Transactional(rollbackFor={Exception.class})
    public PostDetailVO createBy(Post postToCreate, Set<Integer> tagIds, Set<Integer> categoryIds, boolean autoSave) {
        PostDetailVO createdPost = this.createOrUpdate(postToCreate, tagIds, categoryIds, null);
        if (!autoSave) {
            LogEvent logEvent = new LogEvent((Object)this, createdPost.getId().toString(), LogType.POST_PUBLISHED, createdPost.getTitle());
            this.eventPublisher.publishEvent((ApplicationEvent)logEvent);
        }
        return createdPost;
    }

    @Transactional(rollbackFor={Exception.class})
    public PostDetailVO updateBy(Post postToUpdate, Set<Integer> tagIds, Set<Integer> categoryIds, Set<PostMeta> metas, boolean autoSave) {
        postToUpdate.setEditTime(DateUtils.now());
        PostDetailVO updatedPost = this.createOrUpdate(postToUpdate, tagIds, categoryIds, metas);
        if (!autoSave) {
            LogEvent logEvent = new LogEvent((Object)this, updatedPost.getId().toString(), LogType.POST_EDITED, updatedPost.getTitle());
            this.eventPublisher.publishEvent((ApplicationEvent)logEvent);
        }
        return updatedPost;
    }

    @Transactional(rollbackFor={Exception.class})
    public Post updateStatus(PostStatus status, Integer postId) {
        Post post = (Post)super.updateStatus(status, postId);
        this.eventPublisher.publishEvent((ApplicationEvent)new PostUpdatedEvent((Object)this, post));
        return post;
    }

    public Post getBy(PostStatus status, String slug) {
        return (Post)super.getBy(status, slug);
    }

    public Post getBy(Integer year, Integer month, String slug) {
        Assert.notNull((Object)year, (String)"Post create year must not be null");
        Assert.notNull((Object)month, (String)"Post create month must not be null");
        Assert.notNull((Object)slug, (String)"Post slug must not be null");
        Optional postOptional = this.postRepository.findBy(year, month, slug);
        return (Post)postOptional.orElseThrow(() -> new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u6587\u7ae0\u7684\u4fe1\u606f").setErrorData((Object)slug));
    }

    @NonNull
    public Post getBy(@NonNull Integer year, @NonNull String slug) {
        Assert.notNull((Object)year, (String)"Post create year must not be null");
        Assert.notNull((Object)slug, (String)"Post slug must not be null");
        Optional postOptional = this.postRepository.findBy(year, slug);
        return (Post)postOptional.orElseThrow(() -> new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u6587\u7ae0\u7684\u4fe1\u606f").setErrorData((Object)slug));
    }

    public Post getBy(Integer year, Integer month, String slug, PostStatus status) {
        Assert.notNull((Object)year, (String)"Post create year must not be null");
        Assert.notNull((Object)month, (String)"Post create month must not be null");
        Assert.notNull((Object)slug, (String)"Post slug must not be null");
        Assert.notNull((Object)status, (String)"Post status must not be null");
        Optional postOptional = this.postRepository.findBy(year, month, slug, status);
        return (Post)postOptional.orElseThrow(() -> new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u6587\u7ae0\u7684\u4fe1\u606f").setErrorData((Object)slug));
    }

    public Post getBy(Integer year, Integer month, Integer day, String slug) {
        Assert.notNull((Object)year, (String)"Post create year must not be null");
        Assert.notNull((Object)month, (String)"Post create month must not be null");
        Assert.notNull((Object)day, (String)"Post create day must not be null");
        Assert.notNull((Object)slug, (String)"Post slug must not be null");
        Optional postOptional = this.postRepository.findBy(year, month, day, slug);
        return (Post)postOptional.orElseThrow(() -> new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u6587\u7ae0\u7684\u4fe1\u606f").setErrorData((Object)slug));
    }

    public Post getBy(Integer year, Integer month, Integer day, String slug, PostStatus status) {
        Assert.notNull((Object)year, (String)"Post create year must not be null");
        Assert.notNull((Object)month, (String)"Post create month must not be null");
        Assert.notNull((Object)day, (String)"Post create day must not be null");
        Assert.notNull((Object)slug, (String)"Post slug must not be null");
        Assert.notNull((Object)status, (String)"Post status must not be null");
        Optional postOptional = this.postRepository.findBy(year, month, day, slug, status);
        return (Post)postOptional.orElseThrow(() -> new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u6587\u7ae0\u7684\u4fe1\u606f").setErrorData((Object)slug));
    }

    public Content.PatchedContent getLatestContentById(Integer id) {
        return this.postContentPatchLogService.getByPostId(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<Post> removeByIds(Collection<Integer> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return ids.stream().map(arg_0 -> this.removeById(arg_0)).collect(Collectors.toList());
    }

    public Post getBySlug(String slug) {
        return (Post)super.getBySlug(slug);
    }

    public Post getWithLatestContentById(Integer postId) {
        Post post = (Post)this.getById((Object)postId);
        Content postContent = this.getContentById(postId);
        Content.PatchedContent patchedContent = this.postContentPatchLogService.getPatchedContentById(postContent.getHeadPatchLogId());
        post.setContent(patchedContent);
        return post;
    }

    public List<ArchiveYearVO> listYearArchives() {
        List posts = this.postRepository.findAllByStatus(PostStatus.PUBLISHED, Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        return this.postAssembler.convertToYearArchives(posts);
    }

    public List<ArchiveMonthVO> listMonthArchives() {
        List posts = this.postRepository.findAllByStatus(PostStatus.PUBLISHED, Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        return this.postAssembler.convertToMonthArchives(posts);
    }

    public PostDetailVO importMarkdown(String markdown, String filename) {
        Assert.notNull((Object)markdown, (String)"Markdown document must not be null");
        Map frontMatter = MarkdownUtils.getFrontMatter((String)markdown);
        markdown = MarkdownUtils.removeFrontMatter((String)markdown);
        PostParam post = new PostParam();
        post.setStatus(null);
        HashSet<Integer> tagIds = new HashSet<Integer>();
        HashSet<Integer> categoryIds = new HashSet<Integer>();
        if (frontMatter.size() > 0) {
            for (String key : frontMatter.keySet()) {
                List elementValue = (List)frontMatter.get(key);
                block21: for (String ele : elementValue) {
                    ele = HaloUtils.strip((String)ele, (String)"[", (String)"]");
                    ele = StringUtils.strip((String)ele, (String)"\"");
                    if ("".equals(ele = StringUtils.strip((String)ele, (String)"'"))) continue;
                    switch (key) {
                        case "title": {
                            post.setTitle(ele);
                            break;
                        }
                        case "date": {
                            post.setCreateTime(DateUtils.parseDate((String)ele));
                            break;
                        }
                        case "permalink": {
                            post.setSlug(ele);
                            break;
                        }
                        case "thumbnail": {
                            post.setThumbnail(ele);
                            break;
                        }
                        case "status": {
                            post.setStatus(PostStatus.valueOf((String)ele));
                            break;
                        }
                        case "comments": {
                            post.setDisallowComment(Boolean.valueOf(Boolean.parseBoolean(ele)));
                            break;
                        }
                        case "tags": {
                            for (String tagName : ele.split(",")) {
                                tagName = tagName.trim();
                                tagName = StringUtils.strip((String)tagName, (String)"\"");
                                tagName = StringUtils.strip((String)tagName, (String)"'");
                                Tag tag = this.tagService.getByName(tagName);
                                String slug = SlugUtils.slug((String)tagName);
                                if (null == tag) {
                                    tag = this.tagService.getBySlug(slug);
                                }
                                if (null == tag) {
                                    tag = new Tag();
                                    tag.setName(tagName);
                                    tag.setSlug(slug);
                                    tag = (Tag)this.tagService.create((Object)tag);
                                }
                                tagIds.add(tag.getId());
                            }
                            continue block21;
                        }
                        case "categories": {
                            Integer lastCategoryId = null;
                            for (String categoryName : ele.split(",")) {
                                categoryName = categoryName.trim();
                                categoryName = StringUtils.strip((String)categoryName, (String)"\"");
                                Category category = this.categoryService.getByName(categoryName = StringUtils.strip((String)categoryName, (String)"'"));
                                if (null == category) {
                                    category = new Category();
                                    category.setName(categoryName);
                                    category.setSlug(SlugUtils.slug((String)categoryName));
                                    category.setDescription(categoryName);
                                    if (lastCategoryId != null) {
                                        category.setParentId(lastCategoryId);
                                    }
                                    category = (Category)this.categoryService.create((Object)category);
                                }
                                lastCategoryId = category.getId();
                                categoryIds.add(lastCategoryId);
                            }
                            continue block21;
                        }
                    }
                }
            }
        }
        if (null == post.getStatus()) {
            post.setStatus(PostStatus.PUBLISHED);
        }
        if (StringUtils.isEmpty((CharSequence)post.getTitle())) {
            post.setTitle(filename);
        }
        if (StringUtils.isEmpty((CharSequence)post.getSlug())) {
            post.setSlug(SlugUtils.slug((String)post.getTitle()));
        }
        post.setOriginalContent(markdown);
        return this.createBy(post.convertTo(), tagIds, categoryIds, false);
    }

    public String exportMarkdown(Integer id) {
        Assert.notNull((Object)id, (String)"Post id must not be null");
        Post post = (Post)this.getById((Object)id);
        return this.exportMarkdown(post);
    }

    public String exportMarkdown(Post post) {
        List metas;
        List categories;
        Assert.notNull((Object)post, (String)"Post must not be null");
        StringBuilder content = new StringBuilder("---\n");
        content.append("type: ").append("post").append("\n");
        content.append("title: ").append(post.getTitle()).append("\n");
        content.append("permalink: ").append(post.getSlug()).append("\n");
        content.append("thumbnail: ").append(post.getThumbnail()).append("\n");
        content.append("status: ").append(post.getStatus()).append("\n");
        content.append("date: ").append(post.getCreateTime()).append("\n");
        content.append("updated: ").append(post.getEditTime()).append("\n");
        content.append("comments: ").append(post.getDisallowComment() == false).append("\n");
        List tags = this.postTagService.listTagsBy(post.getId());
        if (tags.size() > 0) {
            content.append("tags:").append("\n");
            for (Object tag : tags) {
                content.append("  - ").append(tag.getName()).append("\n");
            }
        }
        if ((categories = this.postCategoryService.listCategoriesBy(post.getId())).size() > 0) {
            content.append("categories:").append("\n");
            for (Object category : categories) {
                content.append("  - ").append(category.getName()).append("\n");
            }
        }
        if ((metas = this.postMetaService.listBy(post.getId())).size() > 0) {
            content.append("metas:").append("\n");
            for (PostMeta postMeta : metas) {
                content.append("  - ").append(postMeta.getKey()).append(" :  ").append(postMeta.getValue()).append("\n");
            }
        }
        content.append("---\n\n");
        Content.PatchedContent postContent = post.getContent();
        content.append(postContent.getOriginalContent());
        return content.toString();
    }

    @Transactional(rollbackFor={Exception.class})
    public Post removeById(Integer postId) {
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        log.debug("Removing post: [{}]", (Object)postId);
        List postTags = this.postTagService.removeByPostId(postId);
        log.debug("Removed post tags: [{}]", (Object)postTags);
        List postCategories = this.postCategoryService.removeByPostId(postId);
        log.debug("Removed post categories: [{}]", (Object)postCategories);
        List metas = this.postMetaService.removeByPostId(postId);
        log.debug("Removed post metas: [{}]", (Object)metas);
        List postComments = this.postCommentService.removeByPostId(postId);
        log.debug("Removed post comments: [{}]", (Object)postComments);
        Content postContent = (Content)this.postContentService.removeById((Object)postId);
        log.debug("Removed post content: [{}]", (Object)postContent);
        Post deletedPost = (Post)super.removeById((Object)postId);
        deletedPost.setContent(Content.PatchedContent.of((Content)postContent));
        this.eventPublisher.publishEvent((ApplicationEvent)new LogEvent((Object)this, postId.toString(), LogType.POST_DELETED, deletedPost.getTitle()));
        return deletedPost;
    }

    @NonNull
    private Specification<Post> buildSpecByQuery(@NonNull PostQuery postQuery) {
        Assert.notNull((Object)postQuery, (String)"Post query must not be null");
        return (Specification & Serializable)(root, query, criteriaBuilder) -> {
            LinkedList<Predicate> predicates = new LinkedList<Predicate>();
            Set statuses = postQuery.getStatuses();
            if (!CollectionUtils.isEmpty((Collection)statuses)) {
                predicates.add(root.get("status").in((Collection)statuses));
            }
            if (postQuery.getCategoryId() != null) {
                List categoryIds = this.categoryService.listAllByParentId(postQuery.getCategoryId()).stream().map(Category::getId).collect(Collectors.toList());
                Subquery postSubquery = query.subquery(Post.class);
                Root postCategoryRoot = postSubquery.from(PostCategory.class);
                postSubquery.select((Expression)postCategoryRoot.get("postId"));
                postSubquery.where(new Predicate[]{criteriaBuilder.equal((Expression)root.get("id"), (Expression)postCategoryRoot.get("postId")), postCategoryRoot.get("categoryId").in(categoryIds)});
                predicates.add(criteriaBuilder.exists(postSubquery));
            }
            if (postQuery.getKeyword() != null) {
                String likeCondition = String.format("%%%s%%", StringUtils.strip((String)postQuery.getKeyword()));
                Predicate titleLike = criteriaBuilder.like((Expression)root.get("title"), likeCondition);
                Predicate originalContentLike = criteriaBuilder.like((Expression)root.get("originalContent"), likeCondition);
                predicates.add(criteriaBuilder.or((Expression)titleLike, (Expression)originalContentLike));
            }
            return query.where(predicates.toArray(new Predicate[0])).getRestriction();
        };
    }

    private PostDetailVO createOrUpdate(@NonNull Post post, Set<Integer> tagIds, Set<Integer> categoryIds, Set<PostMeta> metas) {
        Assert.notNull((Object)post, (String)"Post param must not be null");
        post = (Post)super.createOrUpdateBy((BasePost)post);
        this.postTagService.removeByPostId(post.getId());
        this.postCategoryService.removeByPostId(post.getId());
        List tags = this.tagService.listAllByIds(tagIds);
        List categories = this.categoryService.listAllByIds(categoryIds);
        List postTags = this.postTagService.mergeOrCreateByIfAbsent(post.getId(), ServiceUtils.fetchProperty((Collection)tags, Tag::getId));
        log.debug("Created post tags: [{}]", (Object)postTags);
        List postCategories = this.postCategoryService.mergeOrCreateByIfAbsent(post.getId(), ServiceUtils.fetchProperty((Collection)categories, Category::getId));
        log.debug("Created post categories: [{}]", (Object)postCategories);
        List postMetaList = this.postMetaService.createOrUpdateByPostId(post.getId(), metas);
        log.debug("Created post metas: [{}]", (Object)postMetaList);
        this.applicationContext.publishEvent((ApplicationEvent)new PostUpdatedEvent((Object)this, post));
        Content postContent = (Content)this.postContentService.getById((Object)post.getId());
        post.setContent(this.postContentPatchLogService.getPatchedContentById(postContent.getHeadPatchLogId()));
        return this.postAssembler.convertTo(post, tags, categories, postMetaList);
    }

    public void publishVisitEvent(Integer postId) {
        this.eventPublisher.publishEvent((ApplicationEvent)new PostVisitEvent((Object)this, postId));
    }

    @NotNull
    public Sort getPostDefaultSort() {
        String indexSort = this.optionService.getByPropertyOfNonNull((PropertyEnum)PostProperties.INDEX_SORT).toString();
        return Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"topPriority"}).and(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{indexSort}).and(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"})));
    }

    public List<PostMarkdownVO> listPostMarkdowns() {
        List allPostList = this.listAll();
        ArrayList<PostMarkdownVO> result = new ArrayList<PostMarkdownVO>(allPostList.size());
        for (Post post : allPostList) {
            Content postContent = this.getContentById(post.getId());
            post.setContent(Content.PatchedContent.of((Content)postContent));
            result.add(this.convertToPostMarkdownVo(post));
        }
        return result;
    }

    private PostMarkdownVO convertToPostMarkdownVo(Post post) {
        PostMarkdownVO postMarkdownVO = new PostMarkdownVO();
        StringBuilder frontMatter = this.getFrontMatterYaml(post);
        postMarkdownVO.setFrontMatter(frontMatter.toString());
        Content.PatchedContent postContent = post.getContent();
        postMarkdownVO.setOriginalContent(postContent.getOriginalContent());
        postMarkdownVO.setTitle(post.getTitle());
        postMarkdownVO.setSlug(post.getSlug());
        return postMarkdownVO;
    }

    private StringBuilder getFrontMatterYaml(Post post) {
        StringBuilder frontMatter = new StringBuilder("---\n");
        frontMatter.append("title: ").append(post.getTitle()).append("\n");
        frontMatter.append("date: ").append(post.getCreateTime()).append("\n");
        frontMatter.append("updated: ").append(post.getUpdateTime()).append("\n");
        frontMatter.append("url: ").append(this.postAssembler.buildFullPath(post)).append("\n");
        List categories = this.postCategoryService.listCategoriesBy(post.getId());
        StringBuilder categoryContent = new StringBuilder();
        categories.forEach(category -> categoryContent.append("- ").append(category.getName()).append("\n"));
        frontMatter.append("categories: ").append("\n").append((CharSequence)categoryContent);
        List tags = this.postTagService.listTagsBy(post.getId());
        StringBuilder tagContent = new StringBuilder();
        tags.forEach(tag -> tagContent.append("- ").append(tag.getName()).append("\n"));
        frontMatter.append("tags: ").append("\n").append((CharSequence)tagContent);
        frontMatter.append("---\n");
        return frontMatter;
    }
}

