/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.exception.NotFoundException;
import run.halo.app.model.dto.TagWithPostCountDTO;
import run.halo.app.model.entity.Post;
import run.halo.app.model.entity.PostTag;
import run.halo.app.model.entity.Tag;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.model.projection.TagPostPostCountProjection;
import run.halo.app.repository.PostRepository;
import run.halo.app.repository.PostTagRepository;
import run.halo.app.repository.TagRepository;
import run.halo.app.repository.base.BaseRepository;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostTagService;
import run.halo.app.service.base.AbstractCrudService;
import run.halo.app.utils.ServiceUtils;

@Service
public class PostTagServiceImpl
extends AbstractCrudService<PostTag, Integer>
implements PostTagService {
    private final PostTagRepository postTagRepository;
    private final PostRepository postRepository;
    private final TagRepository tagRepository;
    private final OptionService optionService;

    public PostTagServiceImpl(PostTagRepository postTagRepository, PostRepository postRepository, TagRepository tagRepository, OptionService optionService) {
        super((BaseRepository)postTagRepository);
        this.postTagRepository = postTagRepository;
        this.postRepository = postRepository;
        this.tagRepository = tagRepository;
        this.optionService = optionService;
    }

    public List<Tag> listTagsBy(Integer postId) {
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        Set tagIds = this.postTagRepository.findAllTagIdsByPostId(postId);
        return this.tagRepository.findAllById((Iterable)tagIds);
    }

    public List<TagWithPostCountDTO> listTagWithCountDtos(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort info must not be null");
        List tags = this.tagRepository.findAll(sort);
        Map tagPostCountMap = ServiceUtils.convertToMap((Collection)this.postTagRepository.findPostCount(), TagPostPostCountProjection::getTagId, TagPostPostCountProjection::getPostCount);
        return tags.stream().map(tag -> {
            TagWithPostCountDTO tagWithCountOutputDTO = (TagWithPostCountDTO)new TagWithPostCountDTO().convertFrom(tag);
            tagWithCountOutputDTO.setPostCount(tagPostCountMap.getOrDefault(tag.getId(), 0L));
            StringBuilder fullPath = new StringBuilder();
            if (this.optionService.isEnabledAbsolutePath().booleanValue()) {
                fullPath.append(this.optionService.getBlogBaseUrl());
            }
            fullPath.append("/").append(this.optionService.getTagsPrefix()).append("/").append(tag.getSlug()).append(this.optionService.getPathSuffix());
            tagWithCountOutputDTO.setFullPath(fullPath.toString());
            return tagWithCountOutputDTO;
        }).collect(Collectors.toList());
    }

    public Map<Integer, List<Tag>> listTagListMapBy(Collection<Integer> postIds) {
        if (CollectionUtils.isEmpty(postIds)) {
            return Collections.emptyMap();
        }
        List postTags = this.postTagRepository.findAllByPostIdIn(postIds);
        Set tagIds = ServiceUtils.fetchProperty((Collection)postTags, PostTag::getTagId);
        List tags = this.tagRepository.findAllById((Iterable)tagIds);
        Map tagMap = ServiceUtils.convertToMap((Collection)tags, Tag::getId);
        HashMap<Integer, List<Tag>> tagListMap = new HashMap<Integer, List<Tag>>();
        postTags.forEach(postTag -> tagListMap.computeIfAbsent(postTag.getPostId(), postId -> new LinkedList()).add((Tag)tagMap.get(postTag.getTagId())));
        return tagListMap;
    }

    public List<Post> listPostsBy(Integer tagId) {
        Assert.notNull((Object)tagId, (String)"Tag id must not be null");
        Set postIds = this.postTagRepository.findAllPostIdsByTagId(tagId);
        return this.postRepository.findAllById((Iterable)postIds);
    }

    public List<Post> listPostsBy(Integer tagId, PostStatus status) {
        Assert.notNull((Object)tagId, (String)"Tag id must not be null");
        Assert.notNull((Object)status, (String)"Post status must not be null");
        Set postIds = this.postTagRepository.findAllPostIdsByTagId(tagId, status);
        return this.postRepository.findAllById((Iterable)postIds);
    }

    public List<Post> listPostsBy(String slug, PostStatus status) {
        Assert.notNull((Object)slug, (String)"Tag slug must not be null");
        Assert.notNull((Object)status, (String)"Post status must not be null");
        Tag tag = (Tag)this.tagRepository.getBySlug(slug).orElseThrow(() -> new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u6807\u7b7e\u7684\u4fe1\u606f").setErrorData((Object)slug));
        Set postIds = this.postTagRepository.findAllPostIdsByTagId(tag.getId(), status);
        return this.postRepository.findAllById((Iterable)postIds);
    }

    public Page<Post> pagePostsBy(Integer tagId, Pageable pageable) {
        Assert.notNull((Object)tagId, (String)"Tag id must not be null");
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        Set postIds = this.postTagRepository.findAllPostIdsByTagId(tagId);
        return this.postRepository.findAllByIdIn((Collection)postIds, pageable);
    }

    public Page<Post> pagePostsBy(Integer tagId, PostStatus status, Pageable pageable) {
        Assert.notNull((Object)tagId, (String)"Tag id must not be null");
        Assert.notNull((Object)status, (String)"Post status must not be null");
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        Set postIds = this.postTagRepository.findAllPostIdsByTagId(tagId, status);
        return this.postRepository.findAllByIdIn((Collection)postIds, pageable);
    }

    public List<PostTag> mergeOrCreateByIfAbsent(Integer postId, Set<Integer> tagIds) {
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        if (CollectionUtils.isEmpty(tagIds)) {
            return Collections.emptyList();
        }
        List<PostTag> postTagsStaging = tagIds.stream().map(tagId -> {
            PostTag postTag = new PostTag();
            postTag.setPostId(postId);
            postTag.setTagId(tagId);
            return postTag;
        }).collect(Collectors.toList());
        LinkedList postTagsToRemove = new LinkedList();
        LinkedList postTagsToCreate = new LinkedList();
        List postTags = this.postTagRepository.findAllByPostId(postId);
        postTags.forEach(postTag -> {
            if (!postTagsStaging.contains(postTag)) {
                postTagsToRemove.add(postTag);
            }
        });
        postTagsStaging.forEach(postTagStaging -> {
            if (!postTags.contains(postTagStaging)) {
                postTagsToCreate.add(postTagStaging);
            }
        });
        this.removeAll(postTagsToRemove);
        postTags.removeAll(postTagsToRemove);
        postTags.addAll(this.createInBatch(postTagsToCreate));
        return postTags;
    }

    public List<PostTag> listByPostId(Integer postId) {
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        return this.postTagRepository.findAllByPostId(postId);
    }

    public List<PostTag> listByTagId(Integer tagId) {
        Assert.notNull((Object)tagId, (String)"Tag id must not be null");
        return this.postTagRepository.findAllByTagId(tagId);
    }

    public Set<Integer> listTagIdsByPostId(Integer postId) {
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        return this.postTagRepository.findAllTagIdsByPostId(postId);
    }

    public List<PostTag> removeByPostId(Integer postId) {
        Assert.notNull((Object)postId, (String)"Post id must not be null");
        return this.postTagRepository.deleteByPostId(postId);
    }

    public List<PostTag> removeByTagId(Integer tagId) {
        Assert.notNull((Object)tagId, (String)"Tag id must not be null");
        return this.postTagRepository.deleteByTagId(tagId);
    }
}

