/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import run.halo.app.exception.BadRequestException;
import run.halo.app.exception.NotFoundException;
import run.halo.app.model.entity.Sheet;
import run.halo.app.model.entity.SheetComment;
import run.halo.app.repository.SheetCommentRepository;
import run.halo.app.repository.SheetRepository;
import run.halo.app.repository.base.BaseCommentRepository;
import run.halo.app.service.OptionService;
import run.halo.app.service.SheetCommentService;
import run.halo.app.service.UserService;
import run.halo.app.service.assembler.comment.BaseCommentAssembler;
import run.halo.app.service.assembler.comment.SheetCommentAssembler;
import run.halo.app.service.impl.BaseCommentServiceImpl;

@Service
public class SheetCommentServiceImpl
extends BaseCommentServiceImpl<SheetComment>
implements SheetCommentService {
    private final SheetRepository sheetRepository;

    public SheetCommentServiceImpl(SheetCommentRepository sheetCommentRepository, OptionService optionService, UserService userService, ApplicationEventPublisher eventPublisher, SheetRepository sheetRepository, SheetCommentAssembler sheetCommentAssembler) {
        super((BaseCommentRepository)sheetCommentRepository, optionService, userService, eventPublisher, (BaseCommentAssembler)sheetCommentAssembler);
        this.sheetRepository = sheetRepository;
    }

    public void validateTarget(@NonNull Integer sheetId) {
        Sheet sheet = (Sheet)this.sheetRepository.findById((Object)sheetId).orElseThrow(() -> new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u9875\u9762\u7684\u4fe1\u606f").setErrorData((Object)sheetId));
        if (sheet.getDisallowComment().booleanValue()) {
            throw new BadRequestException("\u8be5\u9875\u9762\u5df2\u88ab\u7981\u6b62\u8bc4\u8bba").setErrorData((Object)sheetId);
        }
    }
}

