/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import run.halo.app.event.logger.LogEvent;
import run.halo.app.event.post.SheetVisitEvent;
import run.halo.app.exception.AlreadyExistsException;
import run.halo.app.exception.NotFoundException;
import run.halo.app.model.dto.IndependentSheetDTO;
import run.halo.app.model.entity.BasePost;
import run.halo.app.model.entity.Content;
import run.halo.app.model.entity.Sheet;
import run.halo.app.model.entity.SheetMeta;
import run.halo.app.model.enums.LogType;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.repository.SheetRepository;
import run.halo.app.repository.base.BasePostRepository;
import run.halo.app.service.ContentPatchLogService;
import run.halo.app.service.ContentService;
import run.halo.app.service.OptionService;
import run.halo.app.service.SheetCommentService;
import run.halo.app.service.SheetMetaService;
import run.halo.app.service.SheetService;
import run.halo.app.service.ThemeService;
import run.halo.app.service.impl.BasePostServiceImpl;
import run.halo.app.utils.MarkdownUtils;
import run.halo.app.utils.ServiceUtils;

@Service
public class SheetServiceImpl
extends BasePostServiceImpl<Sheet>
implements SheetService {
    private static final Logger log = LoggerFactory.getLogger(SheetServiceImpl.class);
    private final SheetRepository sheetRepository;
    private final ApplicationEventPublisher eventPublisher;
    private final SheetCommentService sheetCommentService;
    private final SheetMetaService sheetMetaService;
    private final ThemeService themeService;
    private final OptionService optionService;
    private final ContentService sheetContentService;
    private final ContentPatchLogService sheetContentPatchLogService;

    public SheetServiceImpl(SheetRepository sheetRepository, ApplicationEventPublisher eventPublisher, SheetCommentService sheetCommentService, ContentService sheetContentService, SheetMetaService sheetMetaService, ThemeService themeService, OptionService optionService, ContentPatchLogService sheetContentPatchLogService) {
        super((BasePostRepository)sheetRepository, optionService, sheetContentService, sheetContentPatchLogService);
        this.sheetRepository = sheetRepository;
        this.eventPublisher = eventPublisher;
        this.sheetCommentService = sheetCommentService;
        this.sheetMetaService = sheetMetaService;
        this.themeService = themeService;
        this.optionService = optionService;
        this.sheetContentService = sheetContentService;
        this.sheetContentPatchLogService = sheetContentPatchLogService;
    }

    @Transactional(rollbackFor={Exception.class})
    public Sheet createBy(Sheet sheet, boolean autoSave) {
        Sheet createdSheet = (Sheet)this.createOrUpdateBy((BasePost)sheet);
        if (!autoSave) {
            LogEvent logEvent = new LogEvent((Object)this, createdSheet.getId().toString(), LogType.SHEET_PUBLISHED, createdSheet.getTitle());
            this.eventPublisher.publishEvent((ApplicationEvent)logEvent);
        }
        return createdSheet;
    }

    @Transactional(rollbackFor={Exception.class})
    public Sheet createBy(Sheet sheet, Set<SheetMeta> metas, boolean autoSave) {
        Sheet createdSheet = (Sheet)this.createOrUpdateBy((BasePost)sheet);
        List sheetMetaList = this.sheetMetaService.createOrUpdateByPostId(sheet.getId(), metas);
        log.debug("Created sheet metas: [{}]", (Object)sheetMetaList);
        if (!autoSave) {
            LogEvent logEvent = new LogEvent((Object)this, createdSheet.getId().toString(), LogType.SHEET_PUBLISHED, createdSheet.getTitle());
            this.eventPublisher.publishEvent((ApplicationEvent)logEvent);
        }
        return createdSheet;
    }

    @Transactional(rollbackFor={Exception.class})
    public Sheet updateBy(Sheet sheet, boolean autoSave) {
        Sheet updatedSheet = (Sheet)this.createOrUpdateBy((BasePost)sheet);
        if (!autoSave) {
            LogEvent logEvent = new LogEvent((Object)this, updatedSheet.getId().toString(), LogType.SHEET_EDITED, updatedSheet.getTitle());
            this.eventPublisher.publishEvent((ApplicationEvent)logEvent);
        }
        return updatedSheet;
    }

    @Transactional(rollbackFor={Exception.class})
    public Sheet updateBy(Sheet sheet, Set<SheetMeta> metas, boolean autoSave) {
        Sheet updatedSheet = (Sheet)this.createOrUpdateBy((BasePost)sheet);
        List sheetMetaList = this.sheetMetaService.createOrUpdateByPostId(updatedSheet.getId(), metas);
        log.debug("Created sheet metas: [{}]", (Object)sheetMetaList);
        if (!autoSave) {
            LogEvent logEvent = new LogEvent((Object)this, updatedSheet.getId().toString(), LogType.SHEET_EDITED, updatedSheet.getTitle());
            this.eventPublisher.publishEvent((ApplicationEvent)logEvent);
        }
        return updatedSheet;
    }

    public Page<Sheet> pageBy(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Page info must not be null");
        return this.listAll(pageable);
    }

    public Sheet getBySlug(String slug) {
        Assert.hasText((String)slug, (String)"Sheet slug must not be blank");
        return (Sheet)this.sheetRepository.getBySlug(slug).orElseThrow(() -> new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u9875\u9762\u7684\u4fe1\u606f").setErrorData((Object)slug));
    }

    public Sheet getWithLatestContentById(Integer postId) {
        Sheet sheet = (Sheet)this.getById((Object)postId);
        Content sheetContent = this.getContentById(postId);
        Content.PatchedContent patchedContent = this.sheetContentPatchLogService.getPatchedContentById(sheetContent.getHeadPatchLogId());
        sheet.setContent(patchedContent);
        return sheet;
    }

    public Sheet getBy(PostStatus status, String slug) {
        Assert.notNull((Object)status, (String)"Sheet status must not be null");
        Assert.hasText((String)slug, (String)"Sheet slug must not be blank");
        Optional postOptional = this.sheetRepository.getBySlugAndStatus(slug, status);
        return (Sheet)postOptional.orElseThrow(() -> new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u9875\u9762\u7684\u4fe1\u606f").setErrorData((Object)slug));
    }

    public Sheet importMarkdown(String markdown) {
        Assert.notNull((Object)markdown, (String)"Markdown document must not be null");
        String content = MarkdownUtils.renderHtml((String)markdown);
        Map frontMatter = MarkdownUtils.getFrontMatter((String)markdown);
        return null;
    }

    public String exportMarkdown(Integer id) {
        Assert.notNull((Object)id, (String)"sheet id must not be null");
        Sheet sheet = (Sheet)this.getById((Object)id);
        return this.exportMarkdown(sheet);
    }

    public String exportMarkdown(Sheet sheet) {
        Assert.notNull((Object)sheet, (String)"Sheet must not be null");
        StringBuilder content = new StringBuilder("---\n");
        content.append("type: ").append("sheet").append("\n");
        content.append("title: ").append(sheet.getTitle()).append("\n");
        content.append("permalink: ").append(sheet.getSlug()).append("\n");
        content.append("thumbnail: ").append(sheet.getThumbnail()).append("\n");
        content.append("status: ").append(sheet.getStatus()).append("\n");
        content.append("date: ").append(sheet.getCreateTime()).append("\n");
        content.append("updated: ").append(sheet.getEditTime()).append("\n");
        content.append("comments: ").append(sheet.getDisallowComment() == false).append("\n");
        content.append("---\n\n");
        content.append(sheet.getContent().getOriginalContent());
        return content.toString();
    }

    public List<IndependentSheetDTO> listIndependentSheets() {
        String context = (this.optionService.isEnabledAbsolutePath() != false ? this.optionService.getBlogBaseUrl() : "") + "/";
        IndependentSheetDTO linkSheet = new IndependentSheetDTO();
        linkSheet.setId(Integer.valueOf(1));
        linkSheet.setTitle("\u53cb\u60c5\u94fe\u63a5");
        linkSheet.setFullPath(context + this.optionService.getLinksPrefix());
        linkSheet.setRouteName("LinkList");
        linkSheet.setAvailable(Boolean.valueOf(this.themeService.templateExists("links.ftl")));
        IndependentSheetDTO photoSheet = new IndependentSheetDTO();
        photoSheet.setId(Integer.valueOf(2));
        photoSheet.setTitle("\u56fe\u5e93\u9875\u9762");
        photoSheet.setFullPath(context + this.optionService.getPhotosPrefix());
        photoSheet.setRouteName("PhotoList");
        photoSheet.setAvailable(Boolean.valueOf(this.themeService.templateExists("photos.ftl")));
        IndependentSheetDTO journalSheet = new IndependentSheetDTO();
        journalSheet.setId(Integer.valueOf(3));
        journalSheet.setTitle("\u65e5\u5fd7\u9875\u9762");
        journalSheet.setFullPath(context + this.optionService.getJournalsPrefix());
        journalSheet.setRouteName("JournalList");
        journalSheet.setAvailable(Boolean.valueOf(this.themeService.templateExists("journals.ftl")));
        return Arrays.asList(linkSheet, photoSheet, journalSheet);
    }

    @Transactional(rollbackFor={Exception.class})
    public Sheet removeById(Integer id) {
        List metas = this.sheetMetaService.removeByPostId(id);
        log.debug("Removed sheet metas: [{}]", (Object)metas);
        List sheetComments = this.sheetCommentService.removeByPostId(id);
        log.debug("Removed sheet comments: [{}]", (Object)sheetComments);
        Content sheetContent = (Content)this.sheetContentService.removeById((Object)id);
        log.debug("Removed sheet content: [{}]", (Object)sheetContent);
        Sheet sheet = (Sheet)super.removeById((Object)id);
        sheet.setContent(Content.PatchedContent.of((Content)sheetContent));
        this.eventPublisher.publishEvent((ApplicationEvent)new LogEvent((Object)this, id.toString(), LogType.SHEET_DELETED, sheet.getTitle()));
        return sheet;
    }

    public void publishVisitEvent(Integer sheetId) {
        this.eventPublisher.publishEvent((ApplicationEvent)new SheetVisitEvent((Object)this, sheetId));
    }

    protected void slugMustNotExist(Sheet sheet) {
        Assert.notNull((Object)sheet, (String)"Sheet must not be null");
        boolean exist = ServiceUtils.isEmptyId((Number)sheet.getId()) ? this.sheetRepository.existsBySlug(sheet.getSlug()) : this.sheetRepository.existsByIdNotAndSlug(sheet.getId(), sheet.getSlug());
        if (exist) {
            throw new AlreadyExistsException("\u9875\u9762\u522b\u540d " + sheet.getSlug() + " \u5df2\u5b58\u5728");
        }
    }
}

